// ExtractCallbackSfx.h

#ifndef __EXTRACT_CALLBACK_SFX_H
#define __EXTRACT_CALLBACK_SFX_H

#include "resource.h"

#include "../../../../Windows/ResourceString.h"			// pXύX

#include "../../../Archive/IArchive.h"					// pXύX

#include "../../../Common/FileStreams.h"				// pXύX
#include "../../../ICoder.h"							// pXύX

#include "../../../UI/FileManager/LangUtils.h"			// pXύX

#ifndef _NO_PROGRESS
#include "ProgressDialog.h"								// pXύX
#endif
#include "../../../UI/Common/ArchiveOpenCallback.h"		// pXύX

class CExtractCallbackImp:
  public IArchiveExtractCallback,
  public IOpenCallbackUI,
  public CMyUnknownImp
{
public:
  
  MY_UNKNOWN_IMP

  INTERFACE_IArchiveExtractCallback(;)
  INTERFACE_IOpenCallbackUI(;)

private:
  CMyComPtr<IInArchive> _archiveHandler;
  FString _directoryPath;
  UString _filePath;
  FString _diskFilePath;

  bool _extractMode;
  struct CProcessedFileInfo
  {
    FILETIME MTime;
    bool IsDir;
    UInt32 Attributes;
  } _processedFileInfo;

  COutFileStream *_outFileStreamSpec;
  CMyComPtr<ISequentialOutStream> _outFileStream;

  UString _itemDefaultName;
  FILETIME _defaultMTime;
  UInt32 _defaultAttributes;

  void CreateComplexDirectory(const UStringVector &dirPathParts);
public:
  #ifndef _NO_PROGRESS
  CProgressDialog ProgressDialog;
  #endif

  bool _isCorrupt;
  UString _message;

  void Init(IInArchive *archiveHandler,
    const FString &directoryPath,
    const UString &itemDefaultName,
    const FILETIME &defaultMTime,
    UInt32 defaultAttributes);

  #ifndef _NO_PROGRESS
  HRESULT StartProgressDialog(const UString &title, NWindows::CThread &thread)
  {
    ProgressDialog.Create(title, thread, 0);
    {
      #ifdef LANG
      ProgressDialog.SetText(LangLoadString(IDS_PROGRESS_EXTRACTING, 0x02000890));	// ύX
      #else
      ProgressDialog.SetText(NWindows::MyLoadString(IDS_PROGRESS_EXTRACTING));		// ύX
      #endif
    }

    ProgressDialog.Show(SW_SHOWNORMAL);
    return S_OK;
  }
  virtual ~CExtractCallbackImp() { ProgressDialog.Destroy(); }
  #endif

};

#endif
