﻿//CommonSettings.h
//設定関係共通ヘッダファイル

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#ifndef COMMONSETTINGS_H
#define COMMONSETTINGS_H

#include"resources/resource.h"

//ウインドウ幅
#define DEFAULT_WIDTH 900
//ウインドウ高さ
#define DEFAULT_HEIGHT 450

//デフォルトカラムサイズ
#define DEFAULT_CURRENTFILENAME_WIDTH 180
#define DEFAULT_NEWFILENAME_WIDTH 220
#define DEFAULT_STATUS_WIDTH 220
#define DEFAULT_DIRECTORY_WIDTH 220
#define DEFAULT_SIZE_WIDTH 100
#define DEFAULT_TYPE_WIDTH 130
#define DEFAULT_LASTMODIFIED_WIDTH 130

//デフォルトサムネイルサイズ
#define DEFAULT_SMALLTHUMB_SIZE 128
#define DEFAULT_NORMALTHUMB_SIZE 192
#define DEFAULT_LARGETHUMB_SIZE 256

//サムネイル最小サイズ
#define MINIMUM_THUMB_SIZE 50
//サムネイル最大サイズ
#define MAXIMUM_THUMB_SIZE 512

//デフォルトのサムネイルの間隔
#define DEFAULT_THUMBSPACING_X 30
#define DEFAULT_THUMBSPACING_Y 60

//サムネイルの最小間隔
#define MINIMUM_THUMBSPACING -1
//サムネイルの最大間隔
#define MAXIMUM_THUMBSPACING 512

//フォント最小サイズ
//0=フォントサイズ変更なし
#define MINIMUM_FONT_SIZE 0
//フォント最大サイズ
#define MAXIMUM_FONT_SIZE 20

//リストビューのカラム
enum{
	LISTITEM_CURRENTFILENAME,//現在のファイル名
	LISTITEM_NEWFILENAME,//新しいファイル名
	LISTITEM_STATUS,//ステータス
	LISTITEM_DIRECTORY,//ディレクトリ
	LISTITEM_SIZE,//サイズ
	LISTITEM_TYPE,//種類
	LISTITEM_LASTMODIFIED,//更新日時
	LISTITEM_NUM//LISTITEM数
};

//起動時のサムネイル
enum{
	STARTUP_NO_THUMBNAIL=0,//サムネイルを表示しない
	STARTUP_SMALL_THUMBNAIL,//小さいサイズのサムネイル
	STARTUP_NORMAL_THUMBNAIL,//標準サイズのサムネイル
	STARTUP_LARGE_THUMBNAIL,//大きいサイズのサムネイル
	STARTUP_LASTTIME=10//前回終了時の設定
};

struct WINDOWSTATE{
	//最大化
	bool bMaximized;
	//ウインドウサイズ
	SIZE sizeWindow;
	//ウインドウ座標
	RECT rcWindow;
};

struct LISTVIEWCOLUMN{
	//リストビューカラムの並び順
	int iOrder[LISTITEM_NUM];

	//現在のファイル名カラムの幅
	int iCurrentFileNameWidth;

	//新しいファイル名カラムの幅
	int iNewFileNameWidth;

	//ステータスカラムの幅
	int iStatusWidth;

	//ディレクトリカラムの幅
	int iDirectoryWidth;

	//サイズカラムの幅
	int iSizeWidth;

	//種類カラムの幅
	int iTypeWidth;

	//更新日時カラムの幅
	int iLastModifiedWidth;
};

struct ENABLEFILETYPE{
	bool bZip;
	bool b7z;
	bool bCab;
	bool bLzh;
	bool bRar;
};

struct THUMBNAIL{
	//小さいサイズ
	int iSmall;
	//標準サイズ
	int iNormal;
	//大きいサイズ
	int iLarge;

	//サムネイルの間隔
	int iSpacingX;
	int iSpacingY;

	//起動時のサムネイル
	int iStartup;

	//先頭のファイルを採用する
	bool bFirstFile;

	//サムネイルの補間モード
	int iInterpolationMode;
};

struct ITEMDESIGN{
	//フォント名
	TCHAR szFont[128];
	//サイズ
	int iFontSize;
	//スタイル
	int iFontStyle;

	//文字色
	COLORREF clrText;
	//背景色
	COLORREF clrTextBk;
	//アウトライン色
	COLORREF clrOutline;
};

struct SHORTCUT{
	//「送る」メニューに追加する
	bool bSendTo;
	//デスクトップに追加する
	bool bDesktop;
	//オプション
	//0=ウインドウを表示する
	//1=進捗/報告ダイアログを表示する
	//2=進捗ダイアログを表示しない
	//3=進捗/報告ダイアログを表示しない
	int iOptions;
};

//ログ
struct LOG{
	//ログファイルの最大行数
	//-1=保存しない(bNoLog)
	//0=無制限
	int iMaxLine;
};

struct CONFIG{
	//ウインドウの状態
	struct WINDOWSTATE WindowState;

	//リストビューのカラム
	struct LISTVIEWCOLUMN ListViewColumn;

	//対象書庫ファイル
	struct ENABLEFILETYPE EnableFileType;

	//サムネイル
	struct THUMBNAIL Thumbnail;

	//リストビューアイテムのデザイン
	//リストビューの仕様上、iFontSizeはDefaultItemDesignでのみ有効にすること
	struct ITEMDESIGN DefaultItemDesign;
	struct ITEMDESIGN ReadyItemDesign;
	struct ITEMDESIGN RenamedItemDesign;
	struct ITEMDESIGN FailedItemDesign;

	//外部ビューアのパス
	TCHAR szViewerPath[MAX_PATH];

	//「送る」メニュー
	struct SHORTCUT Shortcut;

	//ログ
	struct LOG Log;

	//zip書庫のファイル名取得に7-zip32.dllを使用する
	bool bUse7zip32;

	//リストに追加するファイルの重複を認める
	bool bAllowDuplicate;

	//終了時に確認する
	bool bConfirmExit;

	//新しいファイル名のフォーマット
	TCHAR szFormat[130];
};

extern struct CONFIG g_Config;

#endif //COMMONSETTINGS_H
