﻿//CtrlAHook.cpp
//Ctrl+Aをローカルフックして、エディットコントロールの文字列を全選択できるようにする

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"CtrlAHook.h"

//コンストラクタ
CCtrlAHook::CCtrlAHook(){
	m_hCtrlAHook=SetWindowsHookEx(WH_MSGFILTER,CtrlAHookProc,NULL,GetCurrentThreadId());
}

//デストラクタ
CCtrlAHook::~CCtrlAHook(){
	UnhookWindowsHookEx(m_hCtrlAHook);
	m_hCtrlAHook=NULL;
}

LRESULT CALLBACK CCtrlAHook::CtrlAHookProc(int nCode,WPARAM wParam,LPARAM lParam){
	if(nCode<0)return CallNextHookEx(NULL/*This parameter is ignored.(by MSDN)*/,nCode,wParam,lParam);

	MSG *pMsg=(MSG*)lParam;
	TCHAR szClassName[64];
	HWND hWnd;

	if(pMsg->message==WM_KEYDOWN){
		if(pMsg->wParam=='A'&&
		   GetAsyncKeyState(VK_CONTROL)<0&&
		   GetAsyncKeyState(VK_SHIFT)>=0&&
		   GetAsyncKeyState(VK_MENU)>=0){
			//Ctrl+Aが押下されている場合
			hWnd=GetFocus();
			if(hWnd!=NULL){
				GetClassName(hWnd,szClassName,64);
				if(lstrcmpi(szClassName,_T("Edit"))==0){
					//フォーカスがエディットコントロールにある
					SendMessage(hWnd,EM_SETSEL,0,-1);
					return true;
				}
			}
		}
	}
	return CallNextHookEx(NULL/*This parameter is ignored.(by MSDN)*/,nCode,wParam,lParam);
}
