﻿//Funciton.h

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#ifndef FUNCTION_H
#define FUNCTION_H

//ファイル処理中
extern bool g_bWorking;

#ifdef __cplusplus
extern "C"{
#endif

//CreateGUIFont()
typedef enum{
	SFONT_BOLD=1<<0,
	SFONT_ITALIC=1<<1,
	SFONT_UNDERLINE=1<<2,
	SFONT_STRIKEOUT=1<<3
}SFONT_TYPE;

//一つのファイルを選択
bool OpenSingleFileDialog(HWND hWnd,TCHAR* pszResult,int iLength,const TCHAR* pszFilter,const TCHAR* pszTitle);
//ディレクトリを選択
bool SelectDirectory(HWND hWnd,TCHAR* pResult,const TCHAR* pszTitle=NULL,const TCHAR* pszDefaultDirectory=NULL);
//ファイルの削除
int MoveToRecycleBin(HWND hWnd,const TCHAR* lpszPath);
//ショートカットを作成
bool CreateShortcut(LPCTSTR lpszShortcutFile,LPCTSTR lpszTargetFile,LPCTSTR lpszArgs,LPCTSTR lpszDescription,LPCTSTR lpszWorkingDirectory);
//ファイルの行数を取得
int GetFileLineCount(const TCHAR* pszFilePath);
//ファイルの先頭から指定された行まで削除
bool ShiftFile(const TCHAR* pszFilePath,int iLine);
//ログファイル出力[成功]
bool WriteLog(const TCHAR* szLogFile,const TCHAR* szState,const TCHAR* szOriginal,const TCHAR* szRenamed,bool bUTF8=false);
//ステータスバー上にプログレスバーを作成
HWND CreateProgressBarOnStatusBar(HINSTANCE hInstance,HWND hStatusBar,int iIndex);
//スピン+エディットコントロールの初期設定
bool InitializeSpinEditControl(HWND hSpin,HWND hEdit,int iMinimum,int iMaximum,int iCurrent);
//エディットボックスから数値を取得
int GetIntFromEdit(HWND hWnd,const int iMinimum,const int iMaximum);
//数値を文字列に変換してエディットボックスに入力
bool SetIntToEdit(HWND hEdit,const int iNumber);
//画面中央にダイアログを表示
void SetCenterWindow(HWND hDlg);
//ツールバー内のボタンの状態を調べる
bool GetStateButtonToolBar(HWND hToolBar,int iButtonId,LONG lState);
//エディットボックスの拡張子を除くファイル名を選択
void SelectEditExcludeExtension(HWND hEdit);
//ファイルのバージョンを取得
void GetFileVersion(TCHAR* pszResult,const TCHAR* pszFilePath);
//XPスタイルのソートを行う
int _StrCmpLogicalW(PCWSTR psz1,PCWSTR psz2);
//IDからめニュー内のアイテムの場所を取得
int _GetMenuPosFromID(HMENU hmenu,UINT id);
//文字列をクリップボードにコピー
bool SetClipboardText(HWND hWnd,const TCHAR* pszText,int iLength);
//スピン+エディットコントロールの初期設定
bool InitializeSpinEditControl(HWND hSpin,HWND hEdit,int iMinimum,int iMaximum,int iCurrent);
//エディットボックスから数値を取得
int GetIntFromEdit(HWND hWnd,const int iMinimum,const int iMaximum);
//数値を文字列に変換してエディットボックスに入力
bool SetIntToEdit(HWND hEdit,const int iNumber);
//数字の桁数を取得
int GetIntLength(int iNumber);
//16進数またはRGB表記の文字列をCOLORREF型に変換
COLORREF StringToCOLORREF(TCHAR* pszString);
//COLORREF型を16進数表記の文字列に変換
bool COLORREFToHex(TCHAR* pszResult,COLORREF color);
//COLORREF型をRGB表記の文字列に変換
bool COLORREFToRGB(TCHAR* pszResult,COLORREF color);
//標準のGUIフォントを作成
HFONT CreateGUIFont(LPCTSTR lpszFontName=NULL,int iSize=0,int iStyle=0);
//現在のフォントサイズを取得
int GetCurrentFontSize(HWND hWnd);
//最新版にアップデート
bool UpdateLatestVersion(HWND hWnd,HINSTANCE hInstance,HWND hStatusBar=NULL,HWND hStatusProgressBar=NULL,bool bNotFoundMessage=true);
//文字列をすべて置換する
void AllReplace(TCHAR* pszDest,const TCHAR* pszSrc,const TCHAR* pszPattern,const TCHAR* pszReplace);
//四角形を指定した純色で塗りつぶす
void FillSolidRect(HDC hDC,RECT *prcRect,COLORREF clColorRef);

#ifdef __cplusplus
}
#endif

#endif //FUNCTION_H
