﻿//GetDirName.cpp
//書庫内のディレクトリ名を取得

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"GetDirName.h"
#include"UnRarFile.h"
#include"UnZipFile.h"
#include"ArcDll.h"
#include"Function.h"
#include"Path.h"
#include<shlwapi.h>

//Rarファイル内のディレクトリ名を取得する
int GetDirectoryNameInRar(TCHAR* pszRetPath,const TCHAR* pszFilePath){
	BOOL bSuccess=false;
	CUnRar UnRar;

	if(!UnRar.CheckReady()||!UnRar.OpenFile(pszFilePath,false))return ARC_ERROR_FILE_CANT_OPEN;//書庫ファイルを開くことが出来ない
	//ソリッド、マルチボリューム、ヘッダ暗号化書庫は無視する
	if(UnRar.IsArchiveSolid()||UnRar.IsArchiveVolume()||UnRar.IsArchiveEncryptedHeaders())return ARC_ERROR_FILE_NOT_SUPPORTED;//書庫ファイルは対応していない
	while(UnRar.ReadFileInfo()){
		/*if(!UnRar.IsDirectory()){//ディレクトリではない
			UnRar.SkipFile();
			continue;
		}*/
		if(path::LocateLastCharacter(UnRar.GetFileName(),_T('\\'))!=-1){
			_tcscpy(pszRetPath,UnRar.GetFileName());
			if(path::GetRootDirectory(pszRetPath,pszRetPath)){
				if(lstrlen(pszRetPath)>0){
					bSuccess=true;
					break;
				}
			}
		}
		UnRar.SkipFile();
	}
	return (bSuccess)?ARC_DEFAULT:ARC_ERROR_DIRECTORY_NOT_FOUND_IN_ARCHIVE;//エラーなしor書庫ファイルの中にディレクトリが見つからない
}

//Zipファイル内のディレクトリ名を取得する
int GetDirectoryNameInZip(TCHAR* pszRetPath,const TCHAR* pszFilePath){
	bool bSuccess=false;
	int iCount=0;
	CUnZip UnZip;

	if(!UnZip.OpenFile(pszFilePath))return ARC_ERROR_FILE_CANT_OPEN;//書庫ファイルを開くことが出来ない
	if((iCount=UnZip.GetFileCount())==0)return ARC_ERROR_DIRECTORY_NOT_FOUND_IN_ARCHIVE;//書庫ファイルの中にディレクトリが見つからない
	for(int i=0;i<iCount;i++){
		if(!UnZip.GetFileInfo(i))return ARC_ERROR_FILE_CANT_GET_INFORMATION;//書庫ファイル内の情報を取得出来ない
		//if(!UnZip.IsDirectory())continue;//ディレクトリでない
		if(path::LocateLastCharacter(UnZip.GetFileName(),_T('/'))!=-1){
			_tcscpy(pszRetPath,UnZip.GetFileName());
			if(path::GetRootDirectory(pszRetPath,pszRetPath)){
				if(lstrlen(pszRetPath)<1)break;
				bSuccess=true;
				break;
			}
		}
	}
	return (bSuccess)?ARC_DEFAULT:ARC_ERROR_DIRECTORY_NOT_FOUND_IN_ARCHIVE;//エラーなしor書庫ファイルの中にディレクトリが見つからない
}

//統合アーカイバ系ファイル内のディレクトリ名を取得する
int GetDirectoryNameInArc(TCHAR* pszRetPath,const TCHAR* pszFilePath){
	int iResult=ARC_DEFAULT;
	bool bSuccess=false;
	const int iMode=1;//CHECKARCHIVE_BASIC(1) 通常モード
	CArcDll ArcDll;
	INDIVIDUALINFO IndividualInfo;

	do{
		if(!path::FileExists(pszFilePath))return ARC_ERROR_FILE_NOT_FOUND;//書庫ファイルが見つからない
		bool bSupported=false;

		for(size_t iDllTypeCount=0;DllInfo[iDllTypeCount].lpszExtension!=NULL;++iDllTypeCount){
			if(DllInfo[iDllTypeCount].pbEnable){
				//DLLを読み込む
				if(!ArcDll.LoadDll(DllInfo[iDllTypeCount].lpszDll,DllInfo[iDllTypeCount].lpszPrefix))continue;
				//DLL独自のカーソルを表示しない
				ArcDll.SetCursorMode(false);
				if(ArcDll.CheckArchive(pszFilePath,iMode)){
					bSupported=true;//正しい書庫ファイルである
					break;
				}
				//DLLを解放する
				ArcDll.UnloadDll();
			}
		}
		if(!bSupported){
			iResult=ARC_ERROR_FILE_NOT_SUPPORTED;//書庫ファイルは対応していない
			break;
		}

		if(ArcDll.GetRunning()){
			iResult=ARC_ERROR_DLL_IS_RUNNING;//DLLが実行中
			break;
		}

		if(ArcDll.OpenArchive(NULL,pszFilePath,0)==NULL){
			iResult=ARC_ERROR_FILE_CANT_OPEN;//書庫ファイルを開くことが出来ない
			break;
		}

		if(ArcDll.FindFirst(_T("*"),&IndividualInfo)==-1){
			iResult=ARC_ERROR_FILE_CANT_GET_INFORMATION;//書庫ファイル内の情報を取得出来ない
			break;
		}

		if(ArcDll.GetFileName(pszRetPath,MAX_PATH)!=0){
			iResult=ARC_ERROR_FILE_CANT_GETFILENAME;//書庫ファイル内のファイル名を取得出来ない
			break;
		}

		if(path::LocateLastCharacter(pszRetPath,_T('\\'))==-1&&path::LocateLastCharacter(pszRetPath,_T('/'))==-1){//区切り文字が含まれない
			if(ArcDll.FindNext(&IndividualInfo)==-1){
				iResult=ARC_ERROR_DIRECTORY_NOT_FOUND_IN_ARCHIVE;//書庫ファイルの中にディレクトリが見つからない
				break;
			}
			do{
				if(ArcDll.GetFileName(pszRetPath,MAX_PATH)!=0){
					iResult=ARC_ERROR_FILE_CANT_GETFILENAME;
					break;
				}

				if(path::LocateLastCharacter(pszRetPath,_T('\\'))!=-1||path::LocateLastCharacter(pszRetPath,_T('/'))!=-1){
					bSuccess=true;
					break;
				}
			}while(ArcDll.FindNext(&IndividualInfo)!=-1);//検索終了まで回す
			if(!bSuccess){
				if(iResult==ARC_DEFAULT){
					iResult=ARC_ERROR_DIRECTORY_NOT_FOUND_IN_ARCHIVE;//書庫ファイルの中にディレクトリが見つからない
				}
				break;
			}
		}
		path::GetRootDirectory(pszRetPath,pszRetPath);//ルートディレクトリを取得
	}while(0);

	ArcDll.CloseArchive();
	return iResult;
}

//書庫ファイル内のディレクトリ名を取得する
int GetDirectoryNameInArchive(TCHAR* pszRetPath,const TCHAR* pszFilePath){
	TCHAR szExtension[_MAX_EXT]={};
	int iResult=-1;

	_tcscpy(szExtension,PathFindExtension(pszFilePath));
	if(_tcsicmp(szExtension,_T(".zip"))==0){
		if(g_Config.bUse7zip32){
			iResult=GetDirectoryNameInArc(pszRetPath,pszFilePath);
		}
		if(iResult!=ARC_DEFAULT)iResult=GetDirectoryNameInZip(pszRetPath,pszFilePath);
	}else if(_tcsicmp(szExtension,_T(".rar"))==0){
		iResult=GetDirectoryNameInRar(pszRetPath,pszFilePath);
	}else{
		iResult=GetDirectoryNameInArc(pszRetPath,pszFilePath);
	}
	return iResult;
}
