﻿//GetDirName.h

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#ifndef GETDIRNAME_H
#define GETDIRNAME_H

#include"CommonSettings.h"

#ifdef __cplusplus
extern "C"{
#endif

//書庫ファイル情報
struct DllInfo{
	LPCTSTR lpszExtension;//書庫形式
	LPCTSTR lpszDll;//書庫DLL
	LPCTSTR lpszPrefix;//書庫Prefix
	bool* pbEnable;//対象書庫ファイル設定
}

const DllInfo[]={
	{_T(".7z"),_T("7-zip32.dll"),_T("SevenZip"),&g_Config.EnableFileType.b7z},
	{_T(".cab"),_T("cab32.dll"),_T("Cab"),&g_Config.EnableFileType.bCab},
	{_T(".lzh"),_T("unlha32.dll"),_T("Unlha"),&g_Config.EnableFileType.bLzh},
	{NULL,NULL,NULL,NULL}
};

//エラー情報
enum{
	ARC_DEFAULT,
	ARC_READY_FOR_RENAME,//リネームすることが出来ます
	ARC_RENAMED,//正常にリネームされました
	ARC_RENAME_FAILURE,//リネームに失敗しました
	ARC_ERROR_BADNAME,//ファイル名に使えない文字が含まれています
	ARC_ERROR_NEEDNT_TO_RENAME,//ファイル名とフォルダ名が一致します

//	ARC_ERROR_SUCCESS,//エラーなし
	ARC_ERROR_FILE_NOT_FOUND,//書庫ファイルが見つからない
	ARC_ERROR_FILE_NOT_SUPPORTED,//書庫ファイルは対応していない
	ARC_ERROR_DLL_IS_RUNNING,//DLLが実行中
	ARC_ERROR_FILE_CANT_OPEN,//書庫ファイルを開くことが出来ない
	ARC_ERROR_FILE_CANT_GET_INFORMATION,//書庫ファイル内の情報を取得出来ない
	ARC_ERROR_FILE_CANT_GETFILENAME,//書庫ファイル内のファイル名を取得出来ない
	ARC_ERROR_DIRECTORY_NOT_FOUND_IN_ARCHIVE//書庫ファイルの中にディレクトリが見つからない
};

//書庫ファイル内のディレクトリ名を取得
int GetDirectoryNameInArchive(TCHAR* pszRetPath,const TCHAR* pszFilePath);

#ifdef __cplusplus
}
#endif

#endif //GETDIRNAME_H
