﻿//GetFileList.cpp
//書庫ファイル内のファイルリストを取得する

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"GetFileList.h"
#include"CommonSettings.h"
#include"GetDirName.h"
#include"ArcDll.h"
#include"UnRarFile.h"
#include"UnZipFile.h"
#include"Function.h"
#include"Path.h"
#include<shlwapi.h>

//Rarファイル内のファイルリストを取得する
bool GetFileListInRar(std::vector<tstring>& vRetList,const TCHAR* pszFilePath){
	CUnRar UnRar;

	UnRar.CheckReady()&&UnRar.OpenFile(pszFilePath,false);
	//ソリッド、マルチボリューム、ヘッダ暗号化書庫は無視する
	if(UnRar.IsArchiveSolid()||UnRar.IsArchiveVolume()||UnRar.IsArchiveEncryptedHeaders())return false;//書庫ファイルは対応していない
	while(UnRar.ReadFileInfo()){
		LPTSTR lpszFileName=(LPTSTR)UnRar.GetFileName();
		for(int j=0;;j++){
			if(lpszFileName[j]==_T('/'))lpszFileName[j]=_T('\\');
			if(lpszFileName[j]==_T('\0'))break;
		}
		PathRemoveBackslash(lpszFileName);
		_tcscpy(lpszFileName,PathFindFileName(lpszFileName));
		vRetList.push_back(tstring(lpszFileName));
		UnRar.SkipFile();
	}
	return true;
}

//Zipファイル内のファイルリストを取得する
bool GetFileListInZip(std::vector<tstring>& vRetList,const TCHAR* pszFilePath){
	int iCount=0;
	int iOldBSlashCount=0,iBSlashCount=0;
	CUnZip UnZip;

	UnZip.OpenFile(pszFilePath);
	if((iCount=UnZip.GetFileCount())==0)return false;//書庫ファイルの中にファイルが見つからない

	for(int i=0;i<iCount;i++){
		if(!UnZip.GetFileInfo(i))return false;//書庫ファイル内の情報を取得出来ない
		LPTSTR lpszFileName=(LPTSTR)UnZip.GetFileName();
		for(int j=0;;j++){
			if(lpszFileName[j]==_T('/'))lpszFileName[j]=_T('\\');
			if(lpszFileName[j]==_T('\0'))break;
		}
		PathRemoveBackslash(lpszFileName);
		iBSlashCount=path::CountCharacter(lpszFileName,_T('\\'));
		//新しいディレクトリがHITした場合
		if(iBSlashCount!=iOldBSlashCount){
			path::GetParentDirectory(lpszFileName,lpszFileName);
			i--;
		}
		iOldBSlashCount=iBSlashCount;
		_tcscpy(lpszFileName,PathFindFileName(lpszFileName));
		dprintf(_T("lpszFileName=%s\n"),lpszFileName);
		vRetList.push_back(tstring(lpszFileName));
	}
	return true;
}

//統合アーカイバ系ファイル内のファイルリストを取得する
bool GetFileListInArc(std::vector<tstring>& vRetList,const TCHAR* pszFilePath){
	bool bResult=false;

	const int iMode=1;//CHECKARCHIVE_BASIC(1) 通常モード
	CArcDll ArcDll;
	INDIVIDUALINFO IndividualInfo;

	if(!path::FileExists(pszFilePath))return false;//書庫ファイルが見つからない
	bool bSupported=false;

	for(size_t iDllTypeCount=0;DllInfo[iDllTypeCount].lpszExtension!=NULL;++iDllTypeCount){
		if(DllInfo[iDllTypeCount].pbEnable){
			//DLLを読み込む
			if(!ArcDll.LoadDll(DllInfo[iDllTypeCount].lpszDll,DllInfo[iDllTypeCount].lpszPrefix))continue;
			//DLL独自のカーソルを表示しない
			ArcDll.SetCursorMode(false);
			if(ArcDll.CheckArchive(pszFilePath,iMode)){
				bSupported=true;//正しい書庫ファイルである
				break;
			}
			//DLLを解放する
			ArcDll.UnloadDll();
		}
	}
	if(!bSupported)return bResult;

	if(ArcDll.GetRunning())return bResult;//DLLが実行中

	if(ArcDll.OpenArchive(NULL,pszFilePath,0)==NULL)return bResult;//書庫ファイルを開くことが出来ない

	if(ArcDll.FindFirst(_T("*"),&IndividualInfo)==-1)return bResult;//書庫ファイル内の情報を取得出来ない

	TCHAR szFileName[MAX_PATH]={};
	TCHAR szTmp[MAX_PATH]={};
	int iOldBSlashCount=0,iBSlashCount=0;

	if(MultiByteToWideChar((ArcDll.IsUnicodeMode())?CP_UTF8:CP_ACP,0,IndividualInfo.szFileName,-1,szFileName,MAX_PATH)){
		for(int j=0;;j++){
			if(szFileName[j]==_T('/'))szFileName[j]=_T('\\');
			if(szFileName[j]==_T('\0'))break;
		}
		PathRemoveBackslash(szFileName);
		iBSlashCount=path::CountCharacter(szFileName,_T('\\'));
		_tcscpy(szFileName,PathFindFileName(szFileName));
		dprintf(_T("szFileName=%s\n"),szFileName);
		vRetList.push_back(tstring(szFileName));
		bResult=true;
	}

	while(ArcDll.FindNext(&IndividualInfo)!=-1){
		if(MultiByteToWideChar((ArcDll.IsUnicodeMode())?CP_UTF8:CP_ACP,0,IndividualInfo.szFileName,-1,szFileName,MAX_PATH)){
			for(int j=0;;j++){
				if(szFileName[j]==_T('/'))szFileName[j]=_T('\\');
				if(szFileName[j]==_T('\0'))break;
			}
			PathRemoveBackslash(szFileName);
			dprintf(_T("[rw]szFileName=%s\n"),szFileName);

			iBSlashCount=path::CountCharacter(szFileName,_T('\\'));
			//新しいディレクトリがHITした場合
			if(iBSlashCount!=iOldBSlashCount){
				path::GetParentDirectory(szTmp,szFileName);
				_tcscpy(szTmp,PathFindFileName(szTmp));
				dprintf(_T("[dir]szFileName=%s\n"),szFileName);
				vRetList.push_back(tstring(szTmp));
			}
			iOldBSlashCount=iBSlashCount;
			_tcscpy(szFileName,PathFindFileName(szFileName));
			dprintf(_T("szFileName=%s\n"),szFileName);
			vRetList.push_back(tstring(szFileName));
		}
	}

	return bResult;
}

//書庫ファイル内のリストを取得
int GetFileList(std::vector<tstring>& vRetList,const TCHAR* pszFilePath){
	LPTSTR lpszExtension=NULL;
	int iResult=0;

	lpszExtension=PathFindExtension(pszFilePath);
	if(_tcsicmp(lpszExtension,_T(".zip"))==0){
		if(g_Config.bUse7zip32){
			iResult=GetFileListInArc(vRetList,pszFilePath);
		}
		if(!iResult)iResult=GetFileListInZip(vRetList,pszFilePath);
	}else if(_tcsicmp(lpszExtension,_T(".rar"))==0){
		iResult=GetFileListInRar(vRetList,pszFilePath);
	}else{
		iResult=GetFileListInArc(vRetList,pszFilePath);
	}
	return iResult;
}
