﻿//ListView.h
//リストビューのカラム

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#ifndef LISTVIEW_H
#define LISTVIEW_H

#include"CommonSettings.h"


struct LISTVIEWCOLUMN_TABLE{
	int iListItem;
	int iMenuId;
	bool bVisible;
	int* piWidth;
	int iOldWidth;
	int iDefaultWidth;
};


#ifdef __cplusplus
extern "C"{
#endif

//カラムの位置を取得
int ListView_GetColumnIndex(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,int iListItem);

//全てのカラムの幅を取得
int ListView_GetAllColumnWidth(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table);

//カラムの数を取得
int ListView_GetColumnCount(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table);

//カラムを追加
bool ListView_AddColumn(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,HWND hListView,int iIndex,LVCOLUMN* plvColumn);

//カラムを削除
bool ListView_RemoveColumn(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,HWND hListView,int iIndex);

//カラムを再表示
bool ListView_RedisplayColumn(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,HWND hListView,int iIndex);

//カラムの情報を初期化
void LisView_InitColumn(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,struct CONFIG* pConfig,HWND hListView);

//カラムの並び順を変更
bool ListView_ChangeColumnOrder(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,HWND hListView);

//先頭を選択する
void ListView_SelectBeginningItem(HWND hListView);

//末尾を選択する
void ListView_SelectEndItem(HWND hListView);

//一つ上を選択する
void ListView_SelectPrevItem(HWND hListView);

//一つ下を選択する
void ListView_SelectNextItem(HWND hListView);

//指定したIndexのアイテムを選択する
void ListView_SelectItem(HWND hListView,int iIndex);

//全て選択する
void ListView_SelectAll(HWND hListView);

//選択を解除する
void ListView_SelectNone(HWND hListView);

//LVS_ICONの時のアイテムとアイテムの間隔(アイコンの幅を含む)を設定
DWORD ListView_SetItemSpacing(HWND hListView,int cx,int cy);

#ifdef __cplusplus
}
#endif

#endif //LISTVIEW_H
