﻿//Path.cpp
//パス操作関数

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"Path.h"

#ifdef __cplusplus
namespace path{
#endif

//文字列から文字を検索し、その最初の位置を返す
int LocateFirstCharacter(const TCHAR* pszStr,int iChar){
	int i=0,iResult=-1;

	for(i=0;pszStr[i]!=_T('\0');++i){
		#ifndef UNICODE
			if(IsDBCSLeadByte(pszStr[i])){
				++i;
				continue;
			}
		#endif
		if(pszStr[i]==iChar){iResult=i;break;}
	}
return iResult;
}

//文字列から文字を検索し、その最後の位置を返す
int LocateLastCharacter(const TCHAR* pszStr,int iChar){
	int i=0,iResult=-1;

	for(i=0;pszStr[i]!=_T('\0');++i){
		#ifndef UNICODE
			if(IsDBCSLeadByte(pszStr[i])){
				++i;
				continue;
			}
		#endif
		if(pszStr[i]==iChar)iResult=i;
	}
return iResult;
}

//文字列から文字を検索し、その個数を返す
int CountCharacter(const TCHAR* pszStr,int iChar){
	int i=0,iResult=0;

	for(i=0;pszStr[i]!=_T('\0');++i){
		#ifndef UNICODE
			if(IsDBCSLeadByte(pszStr[i])){
				++i;
				continue;
			}
		#endif
		if(pszStr[i]==iChar)iResult++;
	}
return iResult;
}

//ファイル名に使えない文字が含まれるかどうか
bool IsBadName(TCHAR* pszFileName){
	if(path::LocateLastCharacter(pszFileName,'\\')!=-1||
		path::LocateLastCharacter(pszFileName,'/')!=-1||
		path::LocateLastCharacter(pszFileName,':')!=-1||
//		path::LocateLastCharacter(pszFileName,',')!=-1||
//		path::LocateLastCharacter(pszFileName,';')!=-1||
		path::LocateLastCharacter(pszFileName,'*')!=-1||
		path::LocateLastCharacter(pszFileName,'?')!=-1||
		path::LocateLastCharacter(pszFileName,'\"')!=-1||
		path::LocateLastCharacter(pszFileName,'<')!=-1||
		path::LocateLastCharacter(pszFileName,'>')!=-1||
		path::LocateLastCharacter(pszFileName,'|')!=-1)return true;
	else return false;
}

//末尾にスラッシュ/バックスラッシュを追加
bool AddBackSlash(TCHAR* pszResult,const TCHAR* pszPath){
	int iPosition=-1;
	bool bResult=false,bSlash=false;

	iPosition=LocateLastCharacter(pszPath,_T('\\'));
	if(iPosition==-1){
		bSlash=true;
		iPosition=LocateLastCharacter(pszPath,_T('/'));
	}
	if(iPosition==2&&pszPath[2]==_T(':')&&pszPath[3]==_T('\0')){//pszPath==ルート
		_tcscpy(pszResult,pszPath);
	}else{
		int iBackSlashPosition=lstrlen(pszPath)-1;
		_tcscpy(pszResult,pszPath);
		if(iPosition!=iBackSlashPosition){
			if(bSlash)_tcscat(pszResult,_T("/"));
			else _tcscat(pszResult,_T("\\"));
			bResult=true;
		}
	}
	return bResult;
}

//親ディレクトリを取得
//foo\bar\baz->foo\bar
//C:\foo\bar\baz->C:\foo\bar
//foo\->foo
bool GetParentDirectory(TCHAR* pszResult,const TCHAR* pszPath){
	int iPosition=-1;
	bool bResult=false;

	iPosition=LocateLastCharacter(pszPath,_T('\\'));
	if(iPosition==-1)iPosition=LocateLastCharacter(pszPath,_T('/'));
	if(iPosition==-1){//区切り文字が含まれない
		_tcscpy(pszResult,pszPath);
	}else{
		if(iPosition==2&&pszPath[2]==_T(':')&&pszPath[3]!=_T('\0')){//C:\foo\bar
			++iPosition;
			_tcsncpy(pszResult,pszPath,iPosition);
		}else{
			_tcscpy(pszResult,pszPath);
			pszResult[iPosition]=_T('\0');
		}
		bResult=true;
	}
	return bResult;
}

//ルートディレクトリを取得
//foo\bar\baz->foo
/*C:\foo\bar->C:\*/
//foo\->foo
bool GetRootDirectory(TCHAR* pszResult,const TCHAR* pszPath){
	int iPosition=-1;
	bool bResult=false;

	iPosition=LocateLastCharacter(pszPath,_T('\\'));
	if(iPosition==-1)iPosition=LocateLastCharacter(pszPath,_T('/'));
	if(iPosition==-1){//区切り文字が含まれない
		_tcscpy(pszResult,pszPath);
	}else{
		iPosition=LocateFirstCharacter(pszPath,_T('\\'));
		if(iPosition==-1)iPosition=LocateFirstCharacter(pszPath,_T('/'));
		if(iPosition==2&&pszPath[2]==_T(':')&&pszPath[3]!=_T('\0')){//C:\foo\bar
			++iPosition;
			_tcsncpy(pszResult,pszPath,iPosition);
		}else{
			_tcscpy(pszResult,pszPath);
			pszResult[iPosition]=_T('\0');
		}
		bResult=true;
	}
	return bResult;
}

//実行ファイルのディレクトリを取得
//C:\foo\bar\baz.exe->C:\foo\bar
bool GetExeDirectory(TCHAR* pszResult,const int iSize){
	bool bResult=false;

	if(GetModuleFileName(NULL,pszResult,iSize)){
		if(GetParentDirectory(pszResult,pszResult))bResult=true;
	}
	return bResult;
}

//ワイルドカードを含む文字列を比較
bool MatchSpec(TCHAR* pszFile,const TCHAR* pszSpec){
	switch(*(pszSpec)){
		case _T('\0'):return *pszFile==_T('\0');
		case _T('*'):return MatchSpec(pszFile,pszSpec+1)||((*(pszFile)!=_T('\0'))&&MatchSpec(pszFile+1,pszSpec));
		case _T('?'):return (*(pszFile)!=_T('\0'))&&MatchSpec(pszFile+1,pszSpec+1);
		default:return (*(pszFile)==*(pszSpec))&&MatchSpec(pszFile+1,pszSpec+1);
	}
}

//ディレクトリであるか否か
bool IsDirectory(const TCHAR* pszPath){
	return (bool)(GetFileAttributes(pszPath)&FILE_ATTRIBUTE_DIRECTORY);
}

//ファイルが存在するか否か
bool FileExists(const TCHAR* pszPath){
	return (bool)(GetFileAttributes(pszPath)!=0xffffffff);
}

//ファイルの最終更新日時を取得
bool GetFileLastModified(const TCHAR* pszPath,LPFILETIME lpftLastModified){
	bool bResult=false;
	HANDLE hFile=NULL;

	hFile=CreateFile(pszPath,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
	if(hFile==INVALID_HANDLE_VALUE){
		lpftLastModified=NULL;
		return bResult;
	}

	bResult=GetFileTime(hFile,NULL,NULL,lpftLastModified);
	CloseHandle(hFile);
	return bResult;
}


#ifdef __cplusplus
}//namespace
#endif
