﻿//Settings.cpp
//設定ダイアログ

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"Settings.h"
#include"Function.h"
#include"Path.h"
#include"PrivateProfile.h"
#include"resources/resource.h"
#include<stdlib.h>
#include<objidl.h>
#include<shlobj.h>

HCURSOR g_hHandCursor=NULL;

//最初に表示するタブ
TAB g_tabStart;

//設定一時保存用
struct CONFIG g_ConfigTmp;


//Spin+Editコントロール
struct SPINEDIT_TABLE{
	UNIT uSpinId;
	UNIT uEditId;
	int* piValue;
};




//スポイトアイコンの座標
#define SPOIT_TEXTCOLOR_X 190
#define SPOIT_TEXTCOLOR_Y 154
#define SPOIT_TEXTBKCOLOR_X 415
#define SPOIT_TEXTBKCOLOR_Y 154

//Setting.hで宣言された以外の関数

//現在の設定をコントロールに適用
void SetCurrentSettings(HWND hDlg,struct CONFIG* pConfig,TAB tabTarget);
//設定ダイアログプロシージャ
bool CALLBACK SettingsDialogProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);
//「全般」タブプロシージャ
bool CALLBACK GeneralTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);
//「デザイン」タブプロシージャ
bool CALLBACK DesignTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);
//「高度な設定」タブプロシージャ
bool CALLBACK AdvancedTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);
//「バージョン情報」タブプロシージャ
bool CALLBACK VersionTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);
//プレビューリストのプロシージャ
LRESULT CALLBACK PreviewListViewProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
//ハイパーリンクのプロシージャ
LRESULT CALLBACK HyperLinkProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam);



int CALLBACK EnumFontsProc(ENUMLOGFONTEX *lplf,NEWTEXTMETRICEX *lptm,DWORD dwType,LPARAM lpData){
	//TruType以外は捨てる
	if(dwType!=TRUETYPE_FONTTYPE)return true;
	//縦書きは捨てる
	if(lplf->elfLogFont.lfFaceName[0]==_T('@')||lplf->elfLogFont.lfFaceName[0]==_T('$'))return true;
	//日本語でも欧文でもない
	if(lstrcmp(lplf->elfScript,_T("日本語"))&&lstrcmp(lplf->elfScript,_T("欧文")))return true;
	//追加されていない場合CB_ERRを返す(重複を防ぐため)
	if(SendMessage((HWND)lpData,CB_FINDSTRINGEXACT,(WPARAM)0,(LPARAM)lplf->elfLogFont.lfFaceName)==CB_ERR){
		SendMessage((HWND)lpData,CB_ADDSTRING,(WPARAM)0,(LPARAM)lplf->elfLogFont.lfFaceName);
	}
	return true;
}

//設定ウインドウを表示する
int ShowSettingsDialog(HWND hWnd,TAB tabStart){
	int iResult=IDCANCEL;
	g_bSettingsDialog=true;
	g_tabStart=tabStart;
	iResult=DialogBox(g_hInstance,MAKEINTRESOURCE(IDD_DIALOG_SETTINGS),hWnd,(DLGPROC)SettingsDialogProc);
	g_bSettingsDialog=false;
	return iResult;
}

//現在の設定をコントロールに適用
void SetCurrentSettings(HWND hDlg,struct CONFIG* pConfig,TAB tabTarget){
	switch(tabTarget){
		case TAB_GENERAL:
		default:{
			//「全般」タブ

			//対象書庫ファイル
			SendDlgItemMessage(hDlg,
							   IDC_CHECKBOX_ZIP,//zip
							   BM_SETCHECK,
							   (WPARAM)(pConfig->EnableFileType.bZip)?BST_CHECKED:BST_UNCHECKED,
							   (LPARAM)0
							  );

			SendDlgItemMessage(hDlg,
							   IDC_CHECKBOX_7Z,//7z
							   BM_SETCHECK,
							   (WPARAM)(pConfig->EnableFileType.b7z)?BST_CHECKED:BST_UNCHECKED,
							   (LPARAM)0
							  );

			SendDlgItemMessage(hDlg,
							   IDC_CHECKBOX_CAB,//cab
							   BM_SETCHECK,
							   (WPARAM)(pConfig->EnableFileType.bCab)?BST_CHECKED:BST_UNCHECKED,
							   (LPARAM)0
							  );

			SendDlgItemMessage(hDlg,
							   IDC_CHECKBOX_LZH,//lzh
							   BM_SETCHECK,
							   (WPARAM)(pConfig->EnableFileType.bLzh)?BST_CHECKED:BST_UNCHECKED,
							   (LPARAM)0
							  );

			SendDlgItemMessage(hDlg,
							   IDC_CHECKBOX_RAR,//rar
							   BM_SETCHECK,
							   (WPARAM)(pConfig->EnableFileType.bRar)?BST_CHECKED:BST_UNCHECKED,
							   (LPARAM)0
							  );


			//サムネイルサイズ
			InitializeSpinEditControl(GetDlgItem(hDlg,IDC_SPIN_SMALLTHUMB),
									  GetDlgItem(hDlg,IDC_EDIT_SMALLTHUMB),
									  MINIMUM_THUMB_SIZE,
									  MAXIMUM_THUMB_SIZE,
									  pConfig->Thumbnail.iSmall
									 );
			SetIntToEdit(GetDlgItem(hDlg,IDC_EDIT_SMALLTHUMB),pConfig->Thumbnail.iSmall);

			InitializeSpinEditControl(GetDlgItem(hDlg,IDC_SPIN_NORMALTHUMB),
									  GetDlgItem(hDlg,IDC_EDIT_NORMALTHUMB),
									  MINIMUM_THUMB_SIZE,
									  MAXIMUM_THUMB_SIZE,
									  pConfig->Thumbnail.iNormal
									 );
			SetIntToEdit(GetDlgItem(hDlg,IDC_EDIT_NORMALTHUMB),pConfig->Thumbnail.iNormal);

			InitializeSpinEditControl(GetDlgItem(hDlg,IDC_SPIN_LARGETHUMB),
									  GetDlgItem(hDlg,IDC_EDIT_LARGETHUMB),
									  MINIMUM_THUMB_SIZE,
									  MAXIMUM_THUMB_SIZE,
									  pConfig->Thumbnail.iLarge
									 );
			SetIntToEdit(GetDlgItem(hDlg,IDC_EDIT_LARGETHUMB),pConfig->Thumbnail.iLarge);


			//ビューア
			SetWindowText(GetDlgItem(hDlg,IDC_EDIT_VIEWER),pConfig->szViewerPath);


			//ショートカット
			SendDlgItemMessage(hDlg,
							   IDC_CHECKBOX_ADDSENDTO,
							   BM_SETCHECK,
							   (WPARAM)(pConfig->Shortcut.bSendTo)?BST_CHECKED:BST_UNCHECKED,
							   (LPARAM)0
							  );

			SendDlgItemMessage(hDlg,
							   IDC_CHECKBOX_DESKTOP,
							   BM_SETCHECK,
							   (WPARAM)(pConfig->Shortcut.bDesktop)?BST_CHECKED:BST_UNCHECKED,
							   (LPARAM)0
							  );

			SendDlgItemMessage(hDlg,
							   IDC_COMBO_ADDSENDTO,
							   CB_SETCURSEL,
							   (WPARAM)pConfig->Shortcut.iOptions,
							   (LPARAM)0
							  );


			//オプションを表示/非表示
			ShowWindow(GetDlgItem(hDlg,IDC_COMBO_ADDSENDTO),(pConfig->Shortcut.bSendTo||pConfig->Shortcut.bDesktop)?SW_SHOW:SW_HIDE);
			break;
		}//case TAB_GENERAL


		case TAB_DESIGN:{
			//「デザイン」タブ
			TCHAR szTmp[12]={};

			//文字色
			COLORREFToHex(szTmp,pConfig->DefaultItemDesign.clrText);
			SetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTCOLOR),szTmp);

			//背景色
			COLORREFToHex(szTmp,pConfig->DefaultItemDesign.clrTextBk);
			SetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTBKCOLOR),szTmp);

			//フォント名
			int iIndex=SendDlgItemMessage(hDlg,IDC_COMBO_FONT,CB_FINDSTRING,(WPARAM)0,(LPARAM)pConfig->DefaultItemDesign.szFont);
			if(iIndex==CB_ERR)iIndex=0;//<デフォルト>
			SendDlgItemMessage(hDlg,IDC_COMBO_FONT,CB_SETCURSEL,(WPARAM)iIndex,(LPARAM)0);

			//フォントサイズ
			wsprintf(szTmp,_T("%d"),pConfig->DefaultItemDesign.iFontSize);
			iIndex=SendDlgItemMessage(hDlg,IDC_COMBO_FONTSIZE,CB_FINDSTRING,(WPARAM)0,(LPARAM)szTmp);
			if(iIndex==CB_ERR)iIndex=0;//<デフォルト>
			SendDlgItemMessage(hDlg,IDC_COMBO_FONTSIZE,CB_SETCURSEL,(WPARAM)iIndex,(LPARAM)0);

			//フォントスタイル
			SendDlgItemMessage(hDlg,
							   IDC_CHECKBOX_BOLD,//太字
							   BM_SETCHECK,
							   (WPARAM)(pConfig->DefaultItemDesign.iFontStyle&SFONT_BOLD)?BST_CHECKED:BST_UNCHECKED,
							   (LPARAM)0
							  );

			SendDlgItemMessage(hDlg,
						   IDC_CHECKBOX_ITALIC,//斜体
						   BM_SETCHECK,
						   (WPARAM)(pConfig->DefaultItemDesign.iFontStyle&SFONT_ITALIC)?BST_CHECKED:BST_UNCHECKED,
						   (LPARAM)0
						  );

			SendDlgItemMessage(hDlg,
						   IDC_CHECKBOX_UNDERLINE,//下線
						   BM_SETCHECK,
						   (WPARAM)(pConfig->DefaultItemDesign.iFontStyle&SFONT_UNDERLINE)?BST_CHECKED:BST_UNCHECKED,
						   (LPARAM)0
						  );

			SendDlgItemMessage(hDlg,
						   IDC_CHECKBOX_STRIKEOUT,//打ち消し線
						   BM_SETCHECK,
						   (WPARAM)(pConfig->DefaultItemDesign.iFontStyle&SFONT_STRIKEOUT)?BST_CHECKED:BST_UNCHECKED,
						   (LPARAM)0
						  );
			break;
		}//case TAB_DESIGN

		case TAB_ADVANCED:
			//「高度な設定」タブ

			//ログの最大行数
			SetIntToEdit(GetDlgItem(hDlg,IDC_EDIT_MAXLINE),pConfig->Log.iMaxLine);

			SendDlgItemMessage(hDlg,
						   IDC_CHECKBOX_USE_7ZIP32,//zip書庫のファイル名取得に7-zip32.dllを使用する
						   BM_SETCHECK,
						   (WPARAM)(pConfig->bUse7zip32)?BST_CHECKED:BST_UNCHECKED,
						   (LPARAM)0
						  );

			SendDlgItemMessage(hDlg,
						   IDC_CHECKBOX_THUMBNAIL_FIRST_FILE,//サムネイルに先頭のファイルを採用する
						   BM_SETCHECK,
						   (WPARAM)(pConfig->Thumbnail.bFirstFile)?BST_CHECKED:BST_UNCHECKED,
						   (LPARAM)0
						  );

			SendDlgItemMessage(hDlg,
						   IDC_CHECKBOX_ALLOW_DUPLICATE,//追加するファイルの重複を許可する
						   BM_SETCHECK,
						   (WPARAM)(pConfig->bAllowDuplicate)?BST_CHECKED:BST_UNCHECKED,
						   (LPARAM)0
						  );

			SendDlgItemMessage(hDlg,
						   IDC_CHECKBOX_CONFIRM_EXIT,//終了確認ダイアログを表示する
						   BM_SETCHECK,
						   (WPARAM)(pConfig->bConfirmExit)?BST_CHECKED:BST_UNCHECKED,
						   (LPARAM)0
						  );

			//新しいファイル名のフォーマット
			SetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),pConfig->szFormat);

			//サムネイルの間隔
			InitializeSpinEditControl(GetDlgItem(hDlg,IDC_SPIN_SPACING_X),
									  GetDlgItem(hDlg,IDC_EDIT_SPACING_X),
									  MINIMUM_THUMBSPACING,
									  MAXIMUM_THUMBSPACING,
									  pConfig->Thumbnail.iSpacingX
									 );
			SetIntToEdit(GetDlgItem(hDlg,IDC_EDIT_SPACING_X),pConfig->Thumbnail.iSpacingX);

			InitializeSpinEditControl(GetDlgItem(hDlg,IDC_SPIN_SPACING_Y),
									  GetDlgItem(hDlg,IDC_EDIT_SPACING_Y),
									  MINIMUM_THUMBSPACING,
									  MAXIMUM_THUMBSPACING,
									  pConfig->Thumbnail.iSpacingY
									 );
			SetIntToEdit(GetDlgItem(hDlg,IDC_EDIT_SPACING_Y),pConfig->Thumbnail.iSpacingY);

			//起動時のサムネイル
			SendDlgItemMessage(hDlg,
							   IDC_COMBO_STARTUPTHUMBNAIL,
							   CB_SETCURSEL,
							   (WPARAM)pConfig->Thumbnail.iStartup,
							   (LPARAM)0
							  );

			//サムネイルの補間モード
			SendDlgItemMessage(hDlg,
							   IDC_COMBO_INTERPOLATIONMODE,
							   CB_SETCURSEL,
							   (WPARAM)pConfig->Thumbnail.iInterpolationMode,
							   (LPARAM)0
							  );
			break;
	}
	return;
}

//設定ダイアログのプロシージャ
bool CALLBACK SettingsDialogProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	static HWND hTab;
	static HWND hTabGeneral;//「全般」タブ
	static HWND hTabDesign;//「デザイン」タブ
	static HWND hTabAdvanced;//「高度な設定」タブ
	static HWND hTabVersion;//「バージョン情報」タブ

	switch (uMsg){
		case WM_INITDIALOG:{
			//設定一時保存
			g_ConfigTmp=g_Config;

			//画面中央に表示
			SetCenterWindow(hDlg);
			hTab=GetDlgItem(hDlg,IDC_TAB1);

			//タブ追加
			TC_ITEM TabItem;

			TabItem.mask=TCIF_TEXT;
			TabItem.pszText=_T("全般");
			TabCtrl_InsertItem(hTab,TAB_GENERAL,&TabItem);

			TabItem.mask=TCIF_TEXT;
			TabItem.pszText=_T("デザイン");
			TabCtrl_InsertItem(hTab,TAB_DESIGN,&TabItem);

			TabItem.mask=TCIF_TEXT;
			TabItem.pszText=_T("高度な設定");
			TabCtrl_InsertItem(hTab,TAB_ADVANCED,&TabItem);

			TabItem.mask=TCIF_TEXT;
			TabItem.pszText=_T("バージョン情報");
			TabCtrl_InsertItem(hTab,TAB_VERSION,&TabItem);

			//タブ(ダイアログ)作成
			hTabGeneral=CreateDialog(g_hInstance,MAKEINTRESOURCE(IDD_TAB_GENERAL),hDlg,(DLGPROC)GeneralTabProc);
			hTabDesign=CreateDialog(g_hInstance,MAKEINTRESOURCE(IDD_TAB_DESIGN),hDlg,(DLGPROC)DesignTabProc);
			hTabAdvanced=CreateDialog(g_hInstance,MAKEINTRESOURCE(IDD_TAB_ADVANCED),hDlg,(DLGPROC)AdvancedTabProc);
			hTabVersion=CreateDialog(g_hInstance,MAKEINTRESOURCE(IDD_TAB_VERSION),hDlg,(DLGPROC)VersionTabProc);

			//タブの座標取得
			RECT rc;
			LPPOINT lpt=(LPPOINT)&rc;

			GetClientRect(hTab,&rc);
			TabCtrl_AdjustRect(hTab,false,&rc);
			//座標変換
			MapWindowPoints(hTab,hDlg,lpt,2);

			//タブの位置とサイズの調整
			MoveWindow(hTabGeneral,
						rc.left,
						rc.top,
						rc.right-rc.left,
						rc.bottom-rc.top,
						false
			);
			MoveWindow(hTabDesign,
						rc.left,
						rc.top,
						rc.right-rc.left,
						rc.bottom-rc.top,
						false
			);
			MoveWindow(hTabAdvanced,
						rc.left,
						rc.top,
						rc.right-rc.left,
						rc.bottom-rc.top,
						false
			);
			MoveWindow(hTabVersion,
						rc.left,
						rc.top,
						rc.right-rc.left,
						rc.bottom-rc.top,
						false
			);

			//タブを表示
			if(g_tabStart==TAB_GENERAL){//全般
				ShowWindow(hTabGeneral,SW_SHOW);
				ShowWindow(hTabDesign,SW_HIDE);
				ShowWindow(hTabAdvanced,SW_HIDE);
				ShowWindow(hTabVersion,SW_HIDE);
				TabCtrl_SetCurFocus(hTab,TAB_GENERAL);
			}else if(g_tabStart==TAB_DESIGN){//デザイン
				ShowWindow(hTabGeneral,SW_HIDE);
				ShowWindow(hTabDesign,SW_SHOW);
				ShowWindow(hTabAdvanced,SW_HIDE);
				ShowWindow(hTabVersion,SW_HIDE);
				TabCtrl_SetCurFocus(hTab,TAB_DESIGN);
			}else if(g_tabStart==TAB_DESIGN){//高度な設定
				ShowWindow(hTabGeneral,SW_HIDE);
				ShowWindow(hTabDesign,SW_HIDE);
				ShowWindow(hTabAdvanced,SW_SHOW);
				ShowWindow(hTabVersion,SW_HIDE);
				TabCtrl_SetCurFocus(hTab,TAB_DESIGN);
			}else{//バージョン情報
				ShowWindow(hTabGeneral,SW_HIDE);
				ShowWindow(hTabDesign,SW_HIDE);
				ShowWindow(hTabAdvanced,SW_HIDE);
				ShowWindow(hTabVersion,SW_SHOW);
				TabCtrl_SetCurFocus(hTab,TAB_VERSION);
			}
			return true;
		}

		case WM_NOTIFY:{
			switch(((LPNMHDR)lParam)->idFrom){
				case IDC_TAB1:
					switch(((LPNMHDR)lParam)->code){
						case TCN_SELCHANGE:
							switch(TabCtrl_GetCurSel(hTab)){
								case TAB_GENERAL://全般
									ShowWindow(hTabGeneral,SW_SHOW);
									ShowWindow(hTabDesign,SW_HIDE);
									ShowWindow(hTabAdvanced,SW_HIDE);
									ShowWindow(hTabVersion,SW_HIDE);
									return true;

								case TAB_DESIGN://デザイン
									ShowWindow(hTabGeneral,SW_HIDE);
									ShowWindow(hTabDesign,SW_SHOW);
									ShowWindow(hTabAdvanced,SW_HIDE);
									ShowWindow(hTabVersion,SW_HIDE);
									return true;

								case TAB_ADVANCED://高度な設定
									ShowWindow(hTabGeneral,SW_HIDE);
									ShowWindow(hTabDesign,SW_HIDE);
									ShowWindow(hTabAdvanced,SW_SHOW);
									ShowWindow(hTabVersion,SW_HIDE);
									return true;

								case TAB_VERSION://バージョン情報
									ShowWindow(hTabGeneral,SW_HIDE);
									ShowWindow(hTabDesign,SW_HIDE);
									ShowWindow(hTabAdvanced,SW_HIDE);
									ShowWindow(hTabVersion,SW_SHOW);
									return true;

								default:
									break;
							}
							break;
						default:
							break;
					}
			}
			break;
		}

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					//新しいファイル名のフォーマットにファイル名に使えない文字が含まれないかチェック
					GetWindowText(GetDlgItem(hTabAdvanced,IDC_EDIT_FORMAT),g_ConfigTmp.szFormat,128);
					if(path::IsBadName(g_ConfigTmp.szFormat)){
						MessageBox(hDlg,_T("新しいファイル名には次の文字は使えません。\n\t\\ / : , ; * ? \" < > |"),_T("新しいファイル名のフォーマット"),MB_ICONSTOP);
						return false;
					}

					//「全般」タブ
					SendMessage(hTabGeneral,WM_CLOSETAB,(WPARAM)0,(LPARAM)0);
					//「デザイン」タブ
					SendMessage(hTabDesign,WM_CLOSETAB,(WPARAM)0,(LPARAM)0);
					//「高度な設定」タブ
					SendMessage(hTabAdvanced,WM_CLOSETAB,(WPARAM)0,(LPARAM)0);
					//「バージョン」情報タブ
					SendMessage(hTabVersion,WM_CLOSETAB,(WPARAM)0,(LPARAM)0);

					//設定を保存
					g_Config=g_ConfigTmp;

					//cfgファイルに書き込む
					WritePrivateProfile(GetParent(hDlg));

					EndDialog(hDlg,IDOK);
					break;

				case IDCANCEL:
				default:
					EndDialog(hDlg,IDCANCEL);
					break;
			}
			return true;

		case WM_CLOSE:
			PostMessage(hDlg,WM_COMMAND,(WPARAM)IDCANCEL,(LPARAM)0);
			return true;

		default:
			return false;
	}
	return false;
}

//「全般」ページ
bool CALLBACK GeneralTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	//CreateShortcut()用
	static TCHAR szExecute[MAX_PATH]={};
	static TCHAR szWorkingDirectory[MAX_PATH]={};
	static TCHAR szSendToLinkPath[MAX_PATH]={};
	static TCHAR szDesktopLinkPath[MAX_PATH]={};

	LPCTSTR lpszShortcutOptions[]={
		_T("ウインドウを表示する"),
		_T("進捗/報告ダイアログを表示する"),
		_T("進捗ダイアログを表示しない"),
		_T("進捗/報告ダイアログを表示しない")
	};

	struct SPINEDIT_TABLE ThumbSize_Table[]={
		{IDC_SPIN_SMALLTHUMB,IDC_EDIT_SMALLTHUMB,&g_ConfigTmp.Thumbnail.iSmall},//小さいサイズ
		{IDC_SPIN_NORMALTHUMB,IDC_EDIT_NORMALTHUMB,&g_ConfigTmp.Thumbnail.iNormal},//標準サイズ
		{IDC_SPIN_LARGETHUMB,IDC_EDIT_LARGETHUMB,&g_ConfigTmp.Thumbnail.iLarge},//大きいサイズ
	};

	switch(uMsg){
		case WM_INITDIALOG:{
			//「送る」メニューのコンボボックスにアイテムを追加
			for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(lpszShortcutOptions));i++){
				SendDlgItemMessage(hDlg,IDC_COMBO_ADDSENDTO,CB_ADDSTRING,(WPARAM)0,(LPARAM)lpszShortcutOptions[i]);
			}

			//「送る」メニュー内ファイルの存在を設定に合わせる
			GetModuleFileName(NULL,szExecute,MAX_PATH);

			_tcscpy(szWorkingDirectory,szExecute);
			//ファイル名を取り除く
			path::GetParentDirectory(szWorkingDirectory,szWorkingDirectory);

			//SendToパスを取得
			SHGetSpecialFolderPath(NULL,szSendToLinkPath,CSIDL_SENDTO,false);
			//Desktopパスを取得
			SHGetSpecialFolderPath(NULL,szDesktopLinkPath,CSIDL_DESKTOP,false);
			//ファイル名を結合
			TCHAR szBuffer[32]={};
			LoadString(g_hInstance,IDS_FILENAME,(LPTSTR)&szBuffer,sizeof(szBuffer)-1);
			_tcscat(szSendToLinkPath,_T("\\"));
			_tcscat(szSendToLinkPath,szBuffer);
			_tcscat(szSendToLinkPath,_T(".lnk"));

			_tcscat(szDesktopLinkPath,_T("\\"));
			_tcscat(szDesktopLinkPath,szBuffer);
			_tcscat(szDesktopLinkPath,_T(".lnk"));

			if(g_ConfigTmp.Shortcut.bSendTo){//送る
				//ショートカット作成
				switch(g_ConfigTmp.Shortcut.iOptions){
					case 0://ウインドウを表示する
						g_ConfigTmp.Shortcut.bSendTo=CreateShortcut(szSendToLinkPath,szExecute,_T("/showwindow"),NULL,szWorkingDirectory);
						break;

					case 2://進捗ダイアログを表示しない
						g_ConfigTmp.Shortcut.bSendTo=CreateShortcut(szSendToLinkPath,szExecute,_T("/silent"),NULL,szWorkingDirectory);
						break;

					case 3://進捗/報告ダイアログを表示しない
						g_ConfigTmp.Shortcut.bSendTo=CreateShortcut(szSendToLinkPath,szExecute,_T("/verysilent"),NULL,szWorkingDirectory);
						break;

					case 1://進捗/報告ダイアログを表示する
					default:
						g_ConfigTmp.Shortcut.bSendTo=CreateShortcut(szSendToLinkPath,szExecute,NULL,NULL,szWorkingDirectory);
						break;
				}
			}else{
				//無効な場合削除
				DeleteFile(szSendToLinkPath);
			}

			if(g_ConfigTmp.Shortcut.bDesktop){//デスクトップ
				//ショートカット作成
				switch(g_ConfigTmp.Shortcut.iOptions){
					case 0://ウインドウを表示する
						g_ConfigTmp.Shortcut.bDesktop=CreateShortcut(szDesktopLinkPath,szExecute,_T("/showwindow"),NULL,szWorkingDirectory);
						break;

					case 2://進捗ダイアログを表示しない
						g_ConfigTmp.Shortcut.bDesktop=CreateShortcut(szDesktopLinkPath,szExecute,_T("/silent"),NULL,szWorkingDirectory);
						break;

					case 3://進捗/報告ダイアログを表示しない
						g_ConfigTmp.Shortcut.bDesktop=CreateShortcut(szDesktopLinkPath,szExecute,_T("/verysilent"),NULL,szWorkingDirectory);
						break;

					case 1://進捗/報告ダイアログを表示する
					default:
						g_ConfigTmp.Shortcut.bDesktop=CreateShortcut(szDesktopLinkPath,szExecute,NULL,NULL,szWorkingDirectory);
						break;
				}
			}else{
				//無効な場合削除
				DeleteFile(szDesktopLinkPath);
			}

			//現在の設定をコントロールに適用
			SetCurrentSettings(hDlg,&g_Config,TAB_GENERAL);
			return true;
		}

		case WM_CTLCOLORSTATIC:{//テキストの背景色を透過させる
			HDC hDC=(HDC)wParam;
			SetBkMode(hDC,TRANSPARENT);
			break;
		}

		case WM_COMMAND:{
			switch(HIWORD(wParam)){
				case EN_CHANGE://エディットボックスの内容が変更される直前
					for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ThumbSize_Table));i++){
						if(LOWORD(wParam)==ThumbSize_Table[i].uEditId){
							*ThumbSize_Table[i].piValue=GetIntFromEdit(GetDlgItem(hDlg,ThumbSize_Table[i].uEditId),MINIMUM_THUMB_SIZE,MAXIMUM_THUMB_SIZE);
						}
					}
					break;

				default:
					break;
			}

			switch(LOWORD(wParam)){
				case IDC_BUTTON_ALL://全て選択[対象書庫ファイル]
					SendDlgItemMessage(hDlg,IDC_CHECKBOX_ZIP,BM_SETCHECK,(WPARAM)BST_CHECKED,(LPARAM)0);
					SendDlgItemMessage(hDlg,IDC_CHECKBOX_7Z,BM_SETCHECK,(WPARAM)BST_CHECKED,(LPARAM)0);
					SendDlgItemMessage(hDlg,IDC_CHECKBOX_CAB,BM_SETCHECK,(WPARAM)BST_CHECKED,(LPARAM)0);
					SendDlgItemMessage(hDlg,IDC_CHECKBOX_LZH,BM_SETCHECK,(WPARAM)BST_CHECKED,(LPARAM)0);
					SendDlgItemMessage(hDlg,IDC_CHECKBOX_RAR,BM_SETCHECK,(WPARAM)BST_CHECKED,(LPARAM)0);
					//fall through

				case IDC_CHECKBOX_ZIP://Zip[対象書庫ファイル]
					g_ConfigTmp.EnableFileType.bZip=SendDlgItemMessage(hDlg,IDC_CHECKBOX_ZIP,BM_GETCHECK,(WPARAM)0,(LPARAM)0)!=0;
					if(LOWORD(wParam)!=IDC_BUTTON_ALL)break;
					//fall through

				case IDC_CHECKBOX_7Z://7z[対象書庫ファイル]
					g_ConfigTmp.EnableFileType.b7z=SendDlgItemMessage(hDlg,IDC_CHECKBOX_7Z,BM_GETCHECK,(WPARAM)0,(LPARAM)0)!=0;
					if(LOWORD(wParam)!=IDC_BUTTON_ALL)break;
					//fall through

				case IDC_CHECKBOX_CAB://Cab[対象書庫ファイル]
					g_ConfigTmp.EnableFileType.bCab=SendDlgItemMessage(hDlg,IDC_CHECKBOX_CAB,BM_GETCHECK,(WPARAM)0,(LPARAM)0)!=0;
					if(LOWORD(wParam)!=IDC_BUTTON_ALL)break;
					//fall through

				case IDC_CHECKBOX_LZH://Lzh[対象書庫ファイル]
					g_ConfigTmp.EnableFileType.bLzh=SendDlgItemMessage(hDlg,IDC_CHECKBOX_LZH,BM_GETCHECK,(WPARAM)0,(LPARAM)0)!=0;
					if(LOWORD(wParam)!=IDC_BUTTON_ALL)break;
					//fall through

				case IDC_CHECKBOX_RAR://Rar[対象書庫ファイル]
					g_ConfigTmp.EnableFileType.bRar=SendDlgItemMessage(hDlg,IDC_CHECKBOX_RAR,BM_GETCHECK,(WPARAM)0,(LPARAM)0)!=0;
					break;

				case IDC_BUTTON_DEFAULTTHUMB://デフォルトに戻す[サムネイルサイズ]
					SetIntToEdit(GetDlgItem(hDlg,IDC_EDIT_SMALLTHUMB),DEFAULT_SMALLTHUMB_SIZE);
					SetIntToEdit(GetDlgItem(hDlg,IDC_EDIT_NORMALTHUMB),DEFAULT_NORMALTHUMB_SIZE);
					SetIntToEdit(GetDlgItem(hDlg,IDC_EDIT_LARGETHUMB),DEFAULT_LARGETHUMB_SIZE);
					break;

				case IDC_BUTTON_VIEWER:{//参照[ビューア]
					TCHAR szViewer[MAX_PATH]={};

					if(!OpenSingleFileDialog(hDlg,
											 szViewer,
											 ARRAY_SIZEOF(szViewer)+1,
											 _T("ビューア (*.exe)\0*.exe\0すべてのファイル (*.*)\0*.*\0\0"),
											 _T("ビューアを選択してください"))){
						break;
					}
					SetWindowText(GetDlgItem(hDlg,IDC_EDIT_VIEWER),szViewer);
					break;
				}

				case IDC_CHECKBOX_ADDSENDTO://送る[ショートカット]
				case IDC_CHECKBOX_DESKTOP://デスクトップ[ショートカット]
					if(LOWORD(wParam)==IDC_CHECKBOX_ADDSENDTO)g_ConfigTmp.Shortcut.bSendTo=SendDlgItemMessage(hDlg,LOWORD(wParam),BM_GETCHECK,(WPARAM)0,(LPARAM)0);
					if(LOWORD(wParam)==IDC_CHECKBOX_DESKTOP)g_ConfigTmp.Shortcut.bDesktop=SendDlgItemMessage(hDlg,LOWORD(wParam),BM_GETCHECK,(WPARAM)0,(LPARAM)0);
					//オプションを表示/非表示
					ShowWindow(GetDlgItem(hDlg,IDC_COMBO_ADDSENDTO),(g_ConfigTmp.Shortcut.bSendTo||g_ConfigTmp.Shortcut.bDesktop)?SW_SHOW:SW_HIDE);
					break;


				case IDC_COMBO_ADDSENDTO://オプション[ショートカット]
					if(HIWORD(wParam)==CBN_SELCHANGE){
						g_ConfigTmp.Shortcut.iOptions=SendDlgItemMessage(hDlg,LOWORD(wParam),CB_GETCURSEL,(WPARAM)0,(LPARAM)0);
					}
					break;

				default:
					break;
			}

			break;
		}

		case WM_NOTIFY:
			for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ThumbSize_Table));i++){
				if(wParam==ThumbSize_Table[i].uSpinId){
					LPNMUPDOWN lpNMUpDown=(LPNMUPDOWN)lParam;
					if(lpNMUpDown->hdr.code==UDN_DELTAPOS){
						*ThumbSize_Table[i].piValue=GetIntFromEdit(GetDlgItem(hDlg,ThumbSize_Table[i].uEditId),MINIMUM_THUMB_SIZE,MAXIMUM_THUMB_SIZE);
						if((lpNMUpDown->iDelta)>0&&*ThumbSize_Table[i].piValue<MAXIMUM_THUMB_SIZE){
							//上が押された
							*ThumbSize_Table[i].piValue+=1;
						}else if((lpNMUpDown->iDelta)<0&&*ThumbSize_Table[i].piValue>MINIMUM_THUMB_SIZE){
							//下が押された
							*ThumbSize_Table[i].piValue-=1;
						}
						SetIntToEdit(GetDlgItem(hDlg,ThumbSize_Table[i].uEditId),*ThumbSize_Table[i].piValue);
					}
				}
			}
			break;

		case WM_CLOSETAB:{
			if(g_ConfigTmp.Shortcut.bSendTo){//送る
				//ショートカット作成
				switch(g_ConfigTmp.Shortcut.iOptions){
					case 0://ウインドウを表示する
						g_ConfigTmp.Shortcut.bSendTo=CreateShortcut(szSendToLinkPath,szExecute,_T("/showwindow"),NULL,szWorkingDirectory);
						break;

					case 2://進捗ダイアログを表示しない
						g_ConfigTmp.Shortcut.bSendTo=CreateShortcut(szSendToLinkPath,szExecute,_T("/silent"),NULL,szWorkingDirectory);
						break;

					case 3://進捗/報告ダイアログを表示しない
						g_ConfigTmp.Shortcut.bSendTo=CreateShortcut(szSendToLinkPath,szExecute,_T("/verysilent"),NULL,szWorkingDirectory);
						break;

					case 1://進捗/報告ダイアログを表示する
					default:
						g_ConfigTmp.Shortcut.bSendTo=CreateShortcut(szSendToLinkPath,szExecute,NULL,NULL,szWorkingDirectory);
						break;
				}
			}else{
				//無効な場合削除
				DeleteFile(szSendToLinkPath);
			}
			if(g_ConfigTmp.Shortcut.bDesktop){//デスクトップ
				//ショートカット作成
				switch(g_ConfigTmp.Shortcut.iOptions){
					case 0://ウインドウを表示する
						g_ConfigTmp.Shortcut.bDesktop=CreateShortcut(szDesktopLinkPath,szExecute,_T("/showwindow"),NULL,szWorkingDirectory);
						break;

					case 2://進捗ダイアログを表示しない
						g_ConfigTmp.Shortcut.bDesktop=CreateShortcut(szDesktopLinkPath,szExecute,_T("/silent"),NULL,szWorkingDirectory);
						break;

					case 3://進捗/報告ダイアログを表示しない
						g_ConfigTmp.Shortcut.bDesktop=CreateShortcut(szDesktopLinkPath,szExecute,_T("/verysilent"),NULL,szWorkingDirectory);
						break;

					case 1://進捗/報告ダイアログを表示する
					default:
						g_ConfigTmp.Shortcut.bDesktop=CreateShortcut(szDesktopLinkPath,szExecute,NULL,NULL,szWorkingDirectory);
						break;
				}
			}else{
				//無効な場合削除
				DeleteFile(szDesktopLinkPath);
			}

			//ビューア
			GetWindowText(GetDlgItem(hDlg,IDC_EDIT_VIEWER),g_ConfigTmp.szViewerPath,MAX_PATH);
			break;
		}

		default:
			break;
	}
	return false;
}

//「デザイン」ページ
bool CALLBACK DesignTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	static HWND hPreviewList=NULL;

	TCHAR szColor[12]={};

	//色選択ダイアログ
	CHOOSECOLOR ccTextColor;
	COLORREF clrCustColors[16];
	memset(&ccTextColor,0,sizeof(CHOOSECOLOR));
	ccTextColor.lStructSize=sizeof(CHOOSECOLOR);
	ccTextColor.hwndOwner=hDlg;
	ccTextColor.lpCustColors=clrCustColors;
	ccTextColor.Flags=CC_FULLOPEN|CC_RGBINIT;

	//スポイトアイコン
	static HICON hiconSpoit=NULL;

	//スポイトドラッグ中
	static bool bTextSpoitDrag;
	static bool bTextBkSpoitDrag;

	typedef struct{
		UNIT uButtonId;
		HFONT hFont;
		TCHAR* pszFont;
		int* piFontStyle;
		COLORREF* pclrText;
		COLORREF* pclrTextBk;
	}ITEMDESIGN_TABLE,*LPITEMDESIGN_TABLE;

	static ITEMDESIGN_TABLE ItemDesign_Table[]={
		{IDC_BUTTON_DEFAULT,g_hDefaultItemFont,g_ConfigTmp.DefaultItemDesign.szFont,&g_ConfigTmp.DefaultItemDesign.iFontStyle,&g_ConfigTmp.DefaultItemDesign.clrText,&g_ConfigTmp.DefaultItemDesign.clrTextBk},//デフォルト
		{IDC_BUTTON_READY,g_hReadyItemFont,g_ConfigTmp.ReadyItemDesign.szFont,&g_ConfigTmp.ReadyItemDesign.iFontStyle,&g_ConfigTmp.ReadyItemDesign.clrText,&g_ConfigTmp.ReadyItemDesign.clrTextBk},//リネーム可能
		{IDC_BUTTON_RENAMED,g_hRenamedItemFont,g_ConfigTmp.RenamedItemDesign.szFont,&g_ConfigTmp.RenamedItemDesign.iFontStyle,&g_ConfigTmp.RenamedItemDesign.clrText,&g_ConfigTmp.RenamedItemDesign.clrTextBk},//リネーム済
		{IDC_BUTTON_FAILED,g_hFailedItemFont,g_ConfigTmp.FailedItemDesign.szFont,&g_ConfigTmp.FailedItemDesign.iFontStyle,&g_ConfigTmp.FailedItemDesign.clrText,&g_ConfigTmp.FailedItemDesign.clrTextBk},//エラー
	};

	static LPCTSTR lpszFontSize[]={
		_T("<デフォルト>"),
		_T("8"),
		_T("9"),
		_T("10"),
		_T("11"),
		_T("12"),
		_T("14"),
		_T("16"),
		_T("18"),
		_T("20"),
	};

	typedef struct{
		UNIT uCheckBoxId;
		int iStyle;
	}FONTSTYLE_TABLE,*LPFONTSTYLE_TABLE;

	static FONTSTYLE_TABLE FontStyle_Table[]={
		{IDC_CHECKBOX_BOLD,SFONT_BOLD},//太字
		{IDC_CHECKBOX_ITALIC,SFONT_ITALIC},//斜線
		{IDC_CHECKBOX_UNDERLINE,SFONT_UNDERLINE},//下線
		{IDC_CHECKBOX_STRIKEOUT,SFONT_STRIKEOUT},//打ち消し線
	};

	switch(uMsg){
		case WM_INITDIALOG:{
			//アイコン読み込み
			hiconSpoit=static_cast<HICON>(LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICON_SPOIT),IMAGE_ICON,16,16,LR_SHARED));

			//トグルボタンに変更
			SetWindowLong(GetDlgItem(hDlg,IDC_BUTTON_DEFAULT),
						  GWL_STYLE,
						  GetWindowLong(GetDlgItem(hDlg,IDC_BUTTON_DEFAULT),GWL_STYLE)|BS_AUTORADIOBUTTON|BS_PUSHLIKE
						 );

			SetWindowLong(GetDlgItem(hDlg,IDC_BUTTON_READY),
						  GWL_STYLE,
						  GetWindowLong(GetDlgItem(hDlg,IDC_BUTTON_READY),GWL_STYLE)|BS_AUTORADIOBUTTON|BS_PUSHLIKE
						 );

			SetWindowLong(GetDlgItem(hDlg,IDC_BUTTON_RENAMED),
						  GWL_STYLE,
						  GetWindowLong(GetDlgItem(hDlg,IDC_BUTTON_RENAMED),GWL_STYLE)|BS_AUTORADIOBUTTON|BS_PUSHLIKE
						 );

			SetWindowLong(GetDlgItem(hDlg,IDC_BUTTON_FAILED),
						  GWL_STYLE,
						  GetWindowLong(GetDlgItem(hDlg,IDC_BUTTON_FAILED),GWL_STYLE)|BS_AUTORADIOBUTTON|BS_PUSHLIKE
						 );

			//デフォルトボタンを押下する
			SendDlgItemMessage(hDlg,IDC_BUTTON_DEFAULT,BM_SETCHECK,(WPARAM)BM_SETCHECK,(LPARAM)0);

			//フォント名
			//フォントの列挙
			HDC hDC=GetDC(hDlg);
			LOGFONT lgFont;
			ZeroMemory(&lgFont,sizeof(LOGFONT));
			lgFont.lfCharSet=DEFAULT_CHARSET;//全文字セット全フォントを列挙する
			//「<デフォルト>」を追加
			SendDlgItemMessage(hDlg,IDC_COMBO_FONT,CB_ADDSTRING,(WPARAM)0,(LPARAM)_T("<デフォルト>"));
			EnumFontFamiliesEx(hDC,&lgFont,(FONTENUMPROC)EnumFontsProc,(LPARAM)GetDlgItem(hDlg,IDC_COMBO_FONT),0);
			ReleaseDC(hDlg,hDC);

			//フォントサイズ
			for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(lpszFontSize));i++){
				SendDlgItemMessage(hDlg,IDC_COMBO_FONTSIZE,CB_ADDSTRING,(WPARAM)0,(LPARAM)lpszFontSize[i]);
			}

			//エディットコントロールの最大文字数を設定
			Edit_LimitText(GetDlgItem(hDlg,IDC_EDIT_TEXTCOLOR),11);
			Edit_LimitText(GetDlgItem(hDlg,IDC_EDIT_TEXTBKCOLOR),11);

			//プレビューにアイテム追加
			hPreviewList=GetDlgItem(hDlg,IDC_LIST_PREVIEW);
			LVCOLUMN LVColumn;
			LVITEM LVItem;
			RECT rc;

			GetWindowRect(hPreviewList,&rc);
			//リストビューにカラムを追加
			LVColumn.mask=LVCF_FMT|LVCF_WIDTH|LVCF_TEXT;
			LVColumn.fmt=LVCFMT_LEFT;
			LVColumn.cx=rc.right-rc.left;
			LVColumn.pszText=NULL;
			ListView_InsertColumn(hPreviewList,0,&LVColumn);

			LVItem.mask=LVIF_TEXT|LVIF_IMAGE;
			LVItem.pszText=_T("デフォルト");
			LVItem.iItem=0;
			LVItem.iSubItem=0;
			ListView_InsertItem(hPreviewList,&LVItem);

			LVItem.mask=LVIF_TEXT;
			LVItem.pszText=_T("リネーム可能");
			LVItem.iItem=1;
			ListView_InsertItem(hPreviewList,&LVItem);

			LVItem.pszText=_T("リネーム済");
			LVItem.iItem=2;
			ListView_InsertItem(hPreviewList,&LVItem);

			LVItem.pszText=_T("エラー");
			LVItem.iItem=3;
			ListView_InsertItem(hPreviewList,&LVItem);

			//プレビューのフォントを設定
			for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ItemDesign_Table));i++){
				ItemDesign_Table[i].hFont=CreateGUIFont(ItemDesign_Table[i].pszFont,g_ConfigTmp.DefaultItemDesign.iFontSize,*(ItemDesign_Table[i].piFontStyle));
			}

			SendMessage(hPreviewList,WM_SETFONT,(WPARAM)ItemDesign_Table[0].hFont,MAKELPARAM(true,0));

			//サブクラス化
			SetWindowLongPtr(hPreviewList,GWL_USERDATA,GetWindowLong(hPreviewList,GWL_WNDPROC));
			SetWindowLongPtr(hPreviewList,GWL_WNDPROC,(DWORD)PreviewListViewProc);

			//現在の設定をコントロールに適用
			SetCurrentSettings(hDlg,&g_Config,TAB_DESIGN);

			return true;
		}

		case WM_CTLCOLORSTATIC:{//テキストの背景色を透過させる
			HWND hWnd=(HWND)lParam;
			if(hWnd==GetDlgItem(hDlg,IDC_COMBO_FONT)||hWnd==GetDlgItem(hDlg,IDC_COMBO_FONTSIZE))break;
			HDC hDC=(HDC)wParam;
			SetBkMode(hDC,TRANSPARENT);
			break;
		}


		case WM_PAINT:{
			PAINTSTRUCT ps;
			HDC hDC=BeginPaint(hDlg,&ps);

			//アイコン描画
			DrawIconEx(hDC,SPOIT_TEXTCOLOR_X,SPOIT_TEXTCOLOR_Y,hiconSpoit,16,16,0,NULL,DI_NORMAL);
			DrawIconEx(hDC,SPOIT_TEXTBKCOLOR_X,SPOIT_TEXTBKCOLOR_Y,hiconSpoit,16,16,0,NULL,DI_NORMAL);
			EndPaint(hDlg,&ps);
			break;
		}

		case WM_LBUTTONDOWN:{
			//DnD開始の位置
			POINT ptClient;

			ptClient.x=GET_X_LPARAM(lParam);
			ptClient.y=GET_Y_LPARAM(lParam);
			//スポイトアイコン上にあるかどうか
			//y座標は共通
			if(ptClient.y>=SPOIT_TEXTCOLOR_Y&&ptClient.y<=(SPOIT_TEXTCOLOR_Y+16)){
				//文字色のスポイト
				if(ptClient.x>=SPOIT_TEXTCOLOR_X&&ptClient.x<=(SPOIT_TEXTCOLOR_X+16)){
					bTextSpoitDrag=true;
					SetCapture(hDlg);
					SetCursor(LoadCursor(NULL,IDC_CROSS));
				}

				//背景色のスポイト
				if(ptClient.x>=SPOIT_TEXTBKCOLOR_X&&ptClient.x<=(SPOIT_TEXTBKCOLOR_X+16)){
					bTextBkSpoitDrag=true;
					SetCapture(hDlg);
					SetCursor(LoadCursor(NULL,IDC_CROSS));
				}
			}
			break;
		}

		case WM_LBUTTONUP:{
			if(!bTextSpoitDrag&&!bTextBkSpoitDrag)break;
			POINT ptScreen;
			POINT ptClient;
			HDC hScreenDC;
			COLORREF clrScreen;

//			ptScreen.x=GET_X_LPARAM(lParam);
//			ptScreen.y=GET_Y_LPARAM(lParam);
			//lParamから取得すると、ウインドウ外の色情報が拾えない
			GetCursorPos(&ptScreen);
			ptClient=ptScreen;
			ScreenToClient(hDlg,&ptClient);

			dprintf(_T("ptScreen.x=%d   ptScreen.y=%d\n"),ptClient.x,ptClient.y);

			//カーソルがスポイトアイコン上にある場合。スポイト動作をキャンセル
			if(ptClient.y>=SPOIT_TEXTCOLOR_Y&&ptClient.y<=(SPOIT_TEXTCOLOR_Y+16)){
				//文字色のスポイト
				if(ptClient.x>=SPOIT_TEXTCOLOR_X&&ptClient.x<=(SPOIT_TEXTCOLOR_X+16)){
					bTextSpoitDrag=false;
					ReleaseCapture();
					SetCursor(LoadCursor(NULL,IDC_ARROW));
					break;
				}

				//背景色のスポイト
				if(ptClient.x>=SPOIT_TEXTBKCOLOR_X&&ptClient.x<=(SPOIT_TEXTBKCOLOR_X+16)){
					bTextBkSpoitDrag=false;
					ReleaseCapture();
					SetCursor(LoadCursor(NULL,IDC_ARROW));
					break;
				}
			}

			//スクリーンのデバイスコンテキストを取得
			hScreenDC=GetDC(0);
			clrScreen=GetPixel(hScreenDC,ptScreen.x,ptScreen.y);
			ReleaseDC(hDlg,hScreenDC);
			for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ItemDesign_Table));i++){
				if(SendDlgItemMessage(hDlg,ItemDesign_Table[i].uButtonId,BM_GETCHECK,(WPARAM)0,(LPARAM)0)){
					if(bTextSpoitDrag){
						*(ItemDesign_Table[i].pclrText)=clrScreen;
						COLORREFToHex(szColor,*(ItemDesign_Table[i].pclrText));
						SetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTCOLOR),szColor);

						bTextSpoitDrag=false;
					}
					if(bTextBkSpoitDrag){
						*(ItemDesign_Table[i].pclrTextBk)=clrScreen;
						COLORREFToHex(szColor,*(ItemDesign_Table[i].pclrTextBk));
						SetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTBKCOLOR),szColor);

						bTextBkSpoitDrag=false;
					}
				}
			}
			ReleaseCapture();
			SetCursor(LoadCursor(NULL,IDC_ARROW));
			break;
		}


		case WM_COMMAND:{
			switch(HIWORD(wParam)){
				case EN_CHANGE:{//エディットボックスの内容が変更される直前
					switch(LOWORD(wParam)){
						case IDC_EDIT_TEXTCOLOR://文字色
							GetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTCOLOR),szColor,sizeof(szColor));
							if(lstrlen(szColor)==6||lstrlen(szColor)==7||path::CountCharacter(szColor,_T(','))==2){
								for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ItemDesign_Table));i++){
									if(SendDlgItemMessage(hDlg,ItemDesign_Table[i].uButtonId,BM_GETCHECK,(WPARAM)0,(LPARAM)0)){
										*ItemDesign_Table[i].pclrText=StringToCOLORREF(szColor);
									}
								}
								PostMessage(hDlg,WM_COMMAND,MAKEWPARAM(IDC_COMBO_FONT,CBN_SELCHANGE),(LPARAM)0);
							}
							break;

						case IDC_EDIT_TEXTBKCOLOR://背景色
							GetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTBKCOLOR),szColor,sizeof(szColor));
							if(lstrlen(szColor)==6||lstrlen(szColor)==7||path::CountCharacter(szColor,_T(','))==2){
								for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ItemDesign_Table));i++){
									if(SendDlgItemMessage(hDlg,ItemDesign_Table[i].uButtonId,BM_GETCHECK,(WPARAM)0,(LPARAM)0)){
										*ItemDesign_Table[i].pclrTextBk=StringToCOLORREF(szColor);
									}
								}
								PostMessage(hDlg,WM_COMMAND,MAKEWPARAM(IDC_COMBO_FONT,CBN_SELCHANGE),(LPARAM)0);
							}
							break;

						default:
							break;
					}
					break;
				}

				case CBN_SELCHANGE:{//コンボボックスの選択内容が変更された
					switch(LOWORD(wParam)){
						case IDC_COMBO_FONTSIZE:{//フォントサイズ
							TCHAR szSize[12]={};
							int iResult=0;

							//選択されたフォントサイズを取得
							int iIndex=SendDlgItemMessage(hDlg,IDC_COMBO_FONTSIZE,CB_GETCURSEL,(WPARAM)0,(LPARAM)0);
							SendDlgItemMessage(hDlg,IDC_COMBO_FONTSIZE,CB_GETLBTEXT,(WPARAM)iIndex,(LPARAM)szSize);
							if(_tcscmp(szSize,_T("<デフォルト>"))==0)iResult=0;
							else iResult=_ttoi(szSize);
							g_ConfigTmp.DefaultItemDesign.iFontSize=(INRANGE(MINIMUM_FONT_SIZE,iResult,MAXIMUM_FONT_SIZE))?iResult:MINIMUM_FONT_SIZE;
							dprintf(_T("g_ConfigTmp.DefaultItemDesign.iFontSize=%d\n"),g_ConfigTmp.DefaultItemDesign.iFontSize);

							for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ItemDesign_Table));i++){
								if(ItemDesign_Table[i].hFont)DeleteObject(ItemDesign_Table[i].hFont);
								ItemDesign_Table[i].hFont=CreateGUIFont(ItemDesign_Table[i].pszFont,g_ConfigTmp.DefaultItemDesign.iFontSize,*(ItemDesign_Table[i].piFontStyle));
							}

							SendMessage(hPreviewList,WM_SETFONT,(WPARAM)ItemDesign_Table[0].hFont,MAKELPARAM(true,0));

							ListView_RedrawItems(hPreviewList,0,ARRAY_SIZEOF(ItemDesign_Table));
							break;
						}

						case IDC_COMBO_FONT:{
							TCHAR szFont[128]={};

							//選択されたフォントを取得
							int iIndex=SendDlgItemMessage(hDlg,IDC_COMBO_FONT,CB_GETCURSEL,(WPARAM)0,(LPARAM)0);
							SendDlgItemMessage(hDlg,IDC_COMBO_FONT,CB_GETLBTEXT,(WPARAM)iIndex,(LPARAM)szFont);

							for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ItemDesign_Table));i++){
								if(SendDlgItemMessage(hDlg,ItemDesign_Table[i].uButtonId,BM_GETCHECK,(WPARAM)0,(LPARAM)0)){
									if(_tcscmp(szFont,_T("<デフォルト>"))==0)_tcscpy((ItemDesign_Table[i].pszFont),_T(""));
									else _tcscpy(ItemDesign_Table[i].pszFont,szFont);

									if(ItemDesign_Table[i].hFont)DeleteObject(ItemDesign_Table[i].hFont);
									ItemDesign_Table[i].hFont=CreateGUIFont(ItemDesign_Table[i].pszFont,g_ConfigTmp.DefaultItemDesign.iFontSize,*(ItemDesign_Table[i].piFontStyle));
									break;
								}
							}

							ListView_RedrawItems(hPreviewList,0,ARRAY_SIZEOF(ItemDesign_Table));
							break;
						}
					}
				}

				default:
					break;
			}

			switch(LOWORD(wParam)){
				case IDC_CHECKBOX_BOLD://太字
				case IDC_CHECKBOX_ITALIC://斜体
				case IDC_CHECKBOX_UNDERLINE://下線
				case IDC_CHECKBOX_STRIKEOUT://打ち消し線
					for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ItemDesign_Table));i++){
						if(SendDlgItemMessage(hDlg,ItemDesign_Table[i].uButtonId,BM_GETCHECK,(WPARAM)0,(LPARAM)0)){
							for(int ii=0;ii<static_cast<int>(ARRAY_SIZEOF(FontStyle_Table));ii++){
								if(SendDlgItemMessage(hDlg,FontStyle_Table[ii].uCheckBoxId,BM_GETCHECK,(WPARAM)0,(LPARAM)0)){
									*(ItemDesign_Table[i].piFontStyle)|=FontStyle_Table[ii].iStyle;
								}else{
									*(ItemDesign_Table[i].piFontStyle)&=~FontStyle_Table[ii].iStyle;
								}
							}
							break;
						}
					}
					PostMessage(hDlg,WM_COMMAND,MAKEWPARAM(IDC_COMBO_FONT,CBN_SELCHANGE),(LPARAM)0);
					break;

				case IDC_BUTTON_DEFAULT://デフォルト
				case IDC_BUTTON_READY://リネーム可能
				case IDC_BUTTON_RENAMED://リネーム済
				case IDC_BUTTON_FAILED://エラー
					//ボタン処理
					for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ItemDesign_Table));i++){
						if(LOWORD(wParam)==ItemDesign_Table[i].uButtonId){
							//フォント名
							int iIndex=SendDlgItemMessage(hDlg,IDC_COMBO_FONT,CB_FINDSTRING,(WPARAM)0,(LPARAM)ItemDesign_Table[i].pszFont);
							if(iIndex==CB_ERR)iIndex=0;//<デフォルト>
							SendDlgItemMessage(hDlg,IDC_COMBO_FONT,CB_SETCURSEL,(WPARAM)iIndex,(LPARAM)0);

							//フォントスタイル
							for(int ii=0;ii<static_cast<int>(ARRAY_SIZEOF(FontStyle_Table));ii++){
								SendDlgItemMessage(hDlg,
												   FontStyle_Table[ii].uCheckBoxId,
												   BM_SETCHECK,
												   (WPARAM)(*(ItemDesign_Table[i].piFontStyle)&FontStyle_Table[ii].iStyle)?BST_CHECKED:BST_UNCHECKED,
												   (LPARAM)0
												  );
							}

							//文字色
							COLORREFToHex(szColor,*(ItemDesign_Table[i].pclrText));
							SetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTCOLOR),szColor);

							//背景色
							COLORREFToHex(szColor,*(ItemDesign_Table[i].pclrTextBk));
							SetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTBKCOLOR),szColor);

							break;
						}
					}
					break;

				case IDC_BUTTON_TEXTCOLOR://文字色選択ボタン
				case IDC_BUTTON_TEXTBKCOLOR://背景色選択ボタン
					for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ItemDesign_Table));i++){
						if(SendDlgItemMessage(hDlg,ItemDesign_Table[i].uButtonId,BM_GETCHECK,(WPARAM)0,(LPARAM)0)){
							if(LOWORD(wParam)==IDC_BUTTON_TEXTCOLOR){
								ccTextColor.rgbResult=*(ItemDesign_Table[i].pclrText);
							}else if(LOWORD(wParam)==IDC_BUTTON_TEXTBKCOLOR){
								ccTextColor.rgbResult=*(ItemDesign_Table[i].pclrTextBk);
							}

							if(ChooseColor(&ccTextColor)){
								if(LOWORD(wParam)==IDC_BUTTON_TEXTCOLOR){
									*(ItemDesign_Table[i].pclrText)=ccTextColor.rgbResult;
									COLORREFToHex(szColor,*(ItemDesign_Table[i].pclrText));
									SetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTCOLOR),szColor);
								}else if(LOWORD(wParam)==IDC_BUTTON_TEXTBKCOLOR){
									*(ItemDesign_Table[i].pclrTextBk)=ccTextColor.rgbResult;
									COLORREFToHex(szColor,*(ItemDesign_Table[i].pclrTextBk));
									SetWindowText(GetDlgItem(hDlg,IDC_EDIT_TEXTBKCOLOR),szColor);
								}
							}
						}
					}
					break;

				default:
					break;
			}

			break;
		}

		case WM_NOTIFY:{
			switch(((LPNMHDR)lParam)->idFrom){
				case IDC_LIST_PREVIEW:{//プレビュー
					LPNMLISTVIEW lpNMLV;
					lpNMLV=(LPNMLISTVIEW)lParam;
					switch(((LPNMHDR)lParam)->code){
						case NM_CUSTOMDRAW:{
							LPNMLVCUSTOMDRAW lpNMLVCD=(LPNMLVCUSTOMDRAW)lParam;

							if(lpNMLVCD->nmcd.dwDrawStage==CDDS_PREPAINT){
								SetWindowLong(hDlg,DWL_MSGRESULT,CDRF_NOTIFYITEMDRAW);
								return true;
							}
							if(lpNMLVCD->nmcd.dwDrawStage==CDDS_ITEMPREPAINT){
								if(static_cast<int>(lpNMLVCD->nmcd.dwItemSpec)>=ListView_GetItemCount(((LPNMHDR)lParam)->hwndFrom)||lpNMLVCD->nmcd.dwItemSpec<0)break;

								lpNMLVCD->clrText=*(ItemDesign_Table[lpNMLVCD->nmcd.dwItemSpec].pclrText);
								lpNMLVCD->clrTextBk=*(ItemDesign_Table[lpNMLVCD->nmcd.dwItemSpec].pclrTextBk);
								SelectObject(lpNMLVCD->nmcd.hdc,ItemDesign_Table[lpNMLVCD->nmcd.dwItemSpec].hFont);

								SetWindowLong(hDlg,DWL_MSGRESULT,CDRF_NEWFONT);
								return true;
							}else{
								SetWindowLong(hDlg,DWL_MSGRESULT,CDRF_DODEFAULT);
								return true;
							}
							break;
						}
					}
				}//case IDC_LIST_PREVIEW

				default:
					break;
			}//switch(((LPNMHDR)lParam)->idFrom)
			break;
		}//case WM_NOTIFY

		case WM_CLOSETAB:{
			//設定を保存
			g_hDefaultItemFont=ItemDesign_Table[0].hFont;
			g_hReadyItemFont=ItemDesign_Table[1].hFont;
			g_hRenamedItemFont=ItemDesign_Table[2].hFont;
			g_hFailedItemFont=ItemDesign_Table[3].hFont;
			break;
		}

		default:
			break;
	}
	return false;
}

//「高度な設定」ページ
bool CALLBACK AdvancedTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	static HMENU hSelectFormatMenu,hSelectFormatSubMenu;//「一覧から選択」メニュー

	LPCTSTR lpszStartupThumbnail[]={
		_T("表示しない"),
		_T("小さいサイズ"),
		_T("標準サイズ"),
		_T("大きいサイズ"),
		_T("前回終了時の設定")
	};

	LPCTSTR lpszInterpolationMode[]={
		_T("Default"),
		_T("LowQuality"),
		_T("HighQuality"),
		_T("Bilinear"),
		_T("Bicubic"),
		_T("NearestNeighbor"),
		_T("HighQualityBilinear"),
		_T("HighQualityBicubic")
	};

	struct SPINEDIT_TABLE ThumbSpacing_Table[]={
		{IDC_SPIN_SPACING_X,IDC_EDIT_SPACING_X,&g_ConfigTmp.Thumbnail.iSpacingX},//幅
		{IDC_SPIN_SPACING_Y,IDC_EDIT_SPACING_Y,&g_ConfigTmp.Thumbnail.iSpacingY},//高さ
	};

	switch(uMsg){
		case WM_INITDIALOG:{
			//「起動時のサムネイル」のコンボボックスにアイテムを追加
			for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(lpszStartupThumbnail));i++){
				SendDlgItemMessage(hDlg,IDC_COMBO_STARTUPTHUMBNAIL,CB_ADDSTRING,(WPARAM)0,(LPARAM)lpszStartupThumbnail[i]);
			}

			//「サムネイルの補間モード」のコンボボックスにアイテムを追加
			for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(lpszInterpolationMode));i++){
				SendDlgItemMessage(hDlg,IDC_COMBO_INTERPOLATIONMODE,CB_ADDSTRING,(WPARAM)0,(LPARAM)lpszInterpolationMode[i]);
			}

			//「一覧から選択」メニューを読み込む
			hSelectFormatMenu=LoadMenu(g_hInstance,MAKEINTRESOURCE(IDR_MENU_SELECTFORMAT));
			hSelectFormatSubMenu=GetSubMenu(hSelectFormatMenu,0);

			//エディットコントロールの最大文字数を設定
			Edit_LimitText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),128);

			//現在の設定をコントロールに適用
			SetCurrentSettings(hDlg,&g_Config,TAB_ADVANCED);
			return true;
		}

		case WM_CTLCOLORSTATIC:{//テキストの背景色を透過させる
			HDC hDC=(HDC)wParam;
			SetBkMode(hDC,TRANSPARENT);
			break;
		}

		case WM_COMMAND:{
			TCHAR szFormat[128]={};

			switch(HIWORD(wParam)){
				case EN_CHANGE://エディットボックスの内容が変更される直前
					for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ThumbSpacing_Table));i++){
						if(LOWORD(wParam)==ThumbSpacing_Table[i].uEditId){
							*ThumbSpacing_Table[i].piValue=GetIntFromEdit(GetDlgItem(hDlg,ThumbSpacing_Table[i].uEditId),MINIMUM_THUMBSPACING,MAXIMUM_THUMBSPACING);
						}
					}
					break;

				default:
					break;
			}

			switch(LOWORD(wParam)){
				case IDC_CHECKBOX_USE_7ZIP32://zip書庫のファイル名取得に7-zip32.dllを使用する
					g_ConfigTmp.bUse7zip32=SendDlgItemMessage(hDlg,LOWORD(wParam),BM_GETCHECK,(WPARAM)0,(LPARAM)0);
					break;

				case IDC_CHECKBOX_THUMBNAIL_FIRST_FILE://サムネイルに先頭のファイルを採用する
					g_ConfigTmp.Thumbnail.bFirstFile=SendDlgItemMessage(hDlg,LOWORD(wParam),BM_GETCHECK,(WPARAM)0,(LPARAM)0);
					break;

				case IDC_COMBO_STARTUPTHUMBNAIL://起動時のサムネイル
					if(HIWORD(wParam)==CBN_SELCHANGE){
						g_ConfigTmp.Thumbnail.iStartup=SendDlgItemMessage(hDlg,LOWORD(wParam),CB_GETCURSEL,(WPARAM)0,(LPARAM)0);
					}
					break;

				case IDC_COMBO_INTERPOLATIONMODE://サムネイルの補間モード
					if(HIWORD(wParam)==CBN_SELCHANGE){
						g_ConfigTmp.Thumbnail.iInterpolationMode=SendDlgItemMessage(hDlg,LOWORD(wParam),CB_GETCURSEL,(WPARAM)0,(LPARAM)0);
					}
					break;

				case IDC_CHECKBOX_ALLOW_DUPLICATE://追加するファイルの重複を許可する
					g_ConfigTmp.bAllowDuplicate=SendDlgItemMessage(hDlg,LOWORD(wParam),BM_GETCHECK,(WPARAM)0,(LPARAM)0);
					break;

				case IDC_CHECKBOX_CONFIRM_EXIT://終了時確認ダイアログを表示する
					g_ConfigTmp.bConfirmExit=SendDlgItemMessage(hDlg,LOWORD(wParam),BM_GETCHECK,(WPARAM)0,(LPARAM)0);
					break;

				case IDC_BUTTON_VIEWER:{//参照[ビューア]
					TCHAR szViewer[MAX_PATH]={};

					if(!OpenSingleFileDialog(hDlg,
											 szViewer,
											 ARRAY_SIZEOF(szViewer)+1,
											 _T("ビューア (*.exe)\0*.exe\0すべてのファイル (*.*)\0*.*\0\0"),
											 _T("ビューアを選択してください"))){
						break;
					}
					SetWindowText(GetDlgItem(hDlg,IDC_EDIT_VIEWER),szViewer);
					break;
				}

				case IDC_BUTTON_SELECTFORMAT://一覧から選択
					RECT rc;

					GetWindowRect(GetDlgItem(hDlg,IDC_BUTTON_SELECTFORMAT),&rc);
					TrackPopupMenu(hSelectFormatSubMenu,TPM_LEFTALIGN|TPM_LEFTBUTTON|TPM_VERTICAL,rc.left,rc.bottom,0,hDlg,NULL);
					break;

				case IDM_FORMAT_ORIGINAL://現在のファイル名
					GetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat,120);
					_tcscat(szFormat,_T("%orig"));
					SetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat);
					break;

				case IDM_FORMAT_NEW://ファイル内のディレクトリ名
					GetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat,120);
					_tcscat(szFormat,_T("%new"));
					SetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat);
					break;

				case IDM_FORMAT_DIRECTORY://ファイルがあるディレクトリ名
					GetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat,120);
					_tcscat(szFormat,_T("%dir"));
					SetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat);
					break;

				case IDM_FORMAT_DATE://ファイルの更新日付 (yyyymmdd)
					GetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat,120);
					_tcscat(szFormat,_T("%date"));
					SetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat);
					break;

				case IDM_FORMAT_TIME://ファイルの更新時刻 (hhmmss)
					GetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat,120);
					_tcscat(szFormat,_T("%time"));
					SetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),szFormat);
					break;

				case IDC_BUTTON_DEFAULTFORMAT://デフォルトに戻す
					SetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),_T("%new"));
					break;

				default:
					break;
			}

			break;
		}

		case WM_NOTIFY:
			for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(ThumbSpacing_Table));i++){
				if(wParam==ThumbSpacing_Table[i].uSpinId){
					LPNMUPDOWN lpNMUpDown=(LPNMUPDOWN)lParam;
					if(lpNMUpDown->hdr.code==UDN_DELTAPOS){
						*ThumbSpacing_Table[i].piValue=GetIntFromEdit(GetDlgItem(hDlg,ThumbSpacing_Table[i].uEditId),MINIMUM_THUMBSPACING,MAXIMUM_THUMBSPACING);
						if((lpNMUpDown->iDelta)>0&&*ThumbSpacing_Table[i].piValue<MAXIMUM_THUMBSPACING){
							//上が押された
							*ThumbSpacing_Table[i].piValue+=1;
						}else if((lpNMUpDown->iDelta)<0&&*ThumbSpacing_Table[i].piValue>MINIMUM_THUMBSPACING){
							//下が押された
							*ThumbSpacing_Table[i].piValue-=1;
						}
						SetIntToEdit(GetDlgItem(hDlg,ThumbSpacing_Table[i].uEditId),*ThumbSpacing_Table[i].piValue);
					}
				}
			}
			break;

		case WM_CLOSETAB:{
			//ログの最大行数
			g_ConfigTmp.Log.iMaxLine=GetIntFromEdit(GetDlgItem(hDlg,IDC_EDIT_MAXLINE),0,32767);

			//新しいファイル名のフォーマット
			//BadNameチェックはSettingsDialogProc()にて
			GetWindowText(GetDlgItem(hDlg,IDC_EDIT_FORMAT),g_ConfigTmp.szFormat,128);
			if(lstrlen(g_ConfigTmp.szFormat)<=0)_tcscpy(g_ConfigTmp.szFormat,_T("%new"));

			DestroyMenu(hSelectFormatMenu);
			hSelectFormatMenu=NULL;
			break;
		}

		default:
			break;
	}
	return false;
}

//「バージョン情報」ページ
bool CALLBACK VersionTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	static HFONT hFont;//URL用フォント
	static HBRUSH hBrush;
	static HICON hIcon;

	switch(uMsg){
		case WM_INITDIALOG:{
			//バージョン情報入力
			SetDlgItemText(hDlg,IDC_STATIC_VERSION,ASHLEY_VERSION);
			//フォントを作成
			LOGFONT lfFont;
			GetObject(GetWindowFont(hDlg),sizeof(LOGFONT),&lfFont);
			lfFont.lfUnderline=true;
			hFont=CreateFontIndirect(&lfFont);
			//フォントを設定
			HWND hURL=GetDlgItem(hDlg,IDC_STATIC_URL);
			SetWindowFont(hURL,hFont,false);

			//アーカイバDLLのバージョン情報を表示。
			LPCTSTR lpszArcDll[]={
				_T("7-zip32.dll"),
				_T("cab32.dll"),
				_T("unlha32.dll"),
				_T("unrar.dll")
			};
			for(int i=0;i<static_cast<int>(ARRAY_SIZEOF(lpszArcDll));i++){
				HWND hEdit=GetDlgItem(hDlg,IDC_EDIT_ARCDLL);
				TCHAR szVersion[16]={};
				TCHAR szText[64]={};

				SetFocus(hEdit);
				GetFileVersion(szVersion,lpszArcDll[i]);
				wsprintf(szText,_T("%-16s\t%-12s\r\n"),lpszArcDll[i],szVersion);
				SendMessage(hEdit,EM_SETSEL,(WPARAM)GetWindowTextLength(hEdit),(LPARAM)GetWindowTextLength(hEdit));
				SendMessage(hEdit,EM_REPLACESEL,(WPARAM)0,(LPARAM)szText);
			}

			//アイコン読み込み
			hIcon=static_cast<HICON>(LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICON1),IMAGE_ICON,48,48,LR_SHARED));

			//サブクラス化
			SetWindowLongPtr(hURL,GWL_USERDATA,GetWindowLong(hURL,GWL_WNDPROC));
			SetWindowLongPtr(hURL,GWL_WNDPROC,(DWORD)HyperLinkProc);

			//カーソル読み込み
			g_hHandCursor=LoadCursor(NULL,IDC_HAND);
			return true;
		}

		case WM_PAINT:{
			PAINTSTRUCT ps;
			HDC hDC=BeginPaint(hDlg,&ps);

			//アイコン描画
			DrawIconEx(hDC,100,120,hIcon,48,48,0,NULL,DI_NORMAL);
			return true;
		}

		case WM_CTLCOLORSTATIC:{//テキストの背景色を透過させる
			HDC hDC=(HDC)wParam;

			SetBkMode(hDC,TRANSPARENT);
			break;
		}

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_STATIC_URL:
					if(HIWORD(wParam)==STN_CLICKED){
						//ホームページへ
						TCHAR szURL[256]={};
						GetWindowText(GetDlgItem(hDlg,IDC_STATIC_URL),szURL,ARRAY_SIZEOF(szURL));
						ShellExecute(NULL,_T("open"),szURL,NULL,NULL,SW_SHOWNORMAL);
						return true;
					}
					break;
				default:
					break;
			}
			break;

		case WM_CLOSETAB:
			//フォント削除
			DeleteFont(hFont);
			return true;

		default:
			break;
	}
	return false;
}

//プレビューリストのプロシージャ
LRESULT CALLBACK PreviewListViewProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam){
	switch(uMsg){
		case WM_LBUTTONDOWN:
		case WM_RBUTTONDOWN:
			SetFocus(hWnd);
			return false;

		default:
			break;
	}
	return CallWindowProc((WNDPROC)GetWindowLongPtr(hWnd,GWL_USERDATA),hWnd,uMsg,wParam,lParam);
}

//ハイパーリンクのプロシージャ
LRESULT CALLBACK HyperLinkProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam){
	switch(uMsg){
		case WM_SETCURSOR:
			if(g_hHandCursor!=NULL){
				SetCursor(g_hHandCursor);
				return true;
			}
			break;

		default:
			break;
	}
	return CallWindowProc((WNDPROC)GetWindowLongPtr(hWnd,GWL_USERDATA),hWnd,uMsg,wParam,lParam);
}
