﻿//UnRarFile.cpp
//unrar.dllのラッパー

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"UnRarFile.h"

//コンストラクタ
CUnRar::CUnRar(){
	//if(RAR_DLL_VERSION>RARGetDllVersion())throw RAR_DLL_VERSION;
	Initialize();
	LoadDll();
}

//デストラクタ
CUnRar::~CUnRar(){
	CloseFile();
	UnloadDll();
}

//初期化
void CUnRar::Initialize(){
	m_iDllVer=0;
	m_hArc=NULL;
	m_pIStream=NULL;
	m_iResult=0;
	ZeroMemory(&m_rOpenArchiveDataEx,sizeof(RAROpenArchiveDataEx));
	ZeroMemory(&m_rHeaderDataEx,sizeof(RARHeaderDataEx));
}

//DLLをロード
void CUnRar::LoadDll(){
#ifndef _WIN64
	m_hDll=LoadLibrary(_T("unrar.dll"));
#else
	m_hDll=LoadLibrary(_T("unrar64.dll"));
#endif
	if(m_hDll){
		pRAROpenArchiveEx=(PRAROPENARCHIVEEX)GetProcAddress(m_hDll,"RAROpenArchiveEx");
		pRARCloseArchive=(PRARCLOSEARCHIVE)GetProcAddress(m_hDll,"RARCloseArchive");
		pRARReadHeaderEx=(PRARREADHEADEREX)GetProcAddress(m_hDll,"RARReadHeaderEx");
		pRARProcessFile=(PRARPROCESSFILE)GetProcAddress(m_hDll,"RARProcessFile");
		pRARProcessFileW=(PRARPROCESSFILEW)GetProcAddress(m_hDll,"RARProcessFileW");
		pRARSetCallback=(PRARSETCALLBACK)GetProcAddress(m_hDll,"RARSetCallback");
		pRARSetPassword=(PRARSETPASSWORD)GetProcAddress(m_hDll,"RARSetPassword");
		pRARGetDllVersion=(PRARGETDLLVERSION)GetProcAddress(m_hDll,"RARGetDllVersion");
	}
	if(pRAROpenArchiveEx&&pRARCloseArchive&&pRARReadHeaderEx&&pRARProcessFile&&pRARProcessFileW&&pRARSetCallback&&pRARSetPassword&&pRARGetDllVersion){
		m_bDllReady=true;
		m_iDllVer=pRARGetDllVersion();
	}
}

//DLLをアンロード
void CUnRar::UnloadDll(){
	if(m_hDll)FreeLibrary(m_hDll);
	m_hDll=NULL;
	m_bDllReady=false;
}

//rarファイルを開く
bool CUnRar::OpenFile(LPCTSTR lpFile,bool bListingOnly,char* cmtBuf,UINT cmtBufSize,char* szPassword){
	if(m_hArc)return false;
	ZeroMemory(&m_rOpenArchiveDataEx,sizeof(RAROpenArchiveDataEx));
	//ファイル名をOpenArchiveDataEx構造体に格納
	//UNICODE以外でビルドされる事を想定していないのでコメントアウト
	//#ifndef UNICODE
	//	m_rOpenArchiveDataEx.ArcName=(PTCHAR)lpFile;
	//#else
		m_rOpenArchiveDataEx.ArcNameW=(PTCHAR)lpFile;
	//#endif
	//RAR_OM_LIST 読み取り専用として開く
	//RAR_OM_EXTRACT 書庫テストや解凍する為に開く
	m_rOpenArchiveDataEx.OpenMode=bListingOnly?RAR_OM_LIST:RAR_OM_EXTRACT;
	//コメント用バッファ
	m_rOpenArchiveDataEx.CmtBuf=cmtBuf;
	m_rOpenArchiveDataEx.CmtBufSize=cmtBufSize;
	//書庫を開く
	m_hArc=pRAROpenArchiveEx(&m_rOpenArchiveDataEx);
	if(m_hArc==NULL||m_rOpenArchiveDataEx.OpenResult!=0)return false;
	//パスワード
	if(szPassword)pRARSetPassword(m_hArc,szPassword);
	//コールバック関数を設定
	pRARSetCallback(m_hArc,RarCallbackProc,(LPARAM)this);
	return true;
}

//rarファイルを閉じる
bool CUnRar::CloseFile(){
	if(m_hArc)m_iResult=pRARCloseArchive(m_hArc);
	Initialize();
	return (m_iResult!=0);
}

//rarファイル内のファイルの情報を読み込む
bool CUnRar::ReadFileInfo(){
	ZeroMemory(&m_rHeaderDataEx,sizeof(RARHeaderDataEx));
	m_iResult=pRARReadHeaderEx(m_hArc,&m_rHeaderDataEx);
	return (m_iResult==0);
}

//RAR_OM_LISTの場合、次のファイル位置までスキップ
//RAR_OM_EXTRACTの場合、書庫テストを行う
bool CUnRar::ProcessFile(){
	m_iResult=pRARProcessFileW(m_hArc,RAR_TEST,NULL,NULL);
	if (m_iResult!=0)return false;
	return true;
}

//次のファイル位置までスキップ
bool CUnRar::SkipFile(){
	m_iResult=pRARProcessFile(m_hArc,RAR_SKIP,NULL,NULL);
	return (m_iResult==0);
}

bool CUnRar::SkipFiles(UINT64 ui64){
	UINT64 i;
	for (i=0;i<ui64;i++)if(!ReadFileInfo()||!SkipFile())return false;
	return true;
}

//コールバック関数
int CUnRar::CallbackProc(UINT uMsg,LPARAM UserData,LPARAM lParam1,LPARAM lParam2){
	if(uMsg==UCM_PROCESSDATA)return ProcessFileData((LPBYTE)lParam1,(ULONG)lParam2);
	return -1;
}

//ストリームに出力
int CUnRar::ProcessFileData(LPBYTE lpBuffer,ULONG uiBufferSize){
	if(m_pIStream){
		ULONG ul=0;
		if(S_OK==m_pIStream->Write(lpBuffer,uiBufferSize,&ul))
			if(ul==uiBufferSize)return 1;
	}
	return -1;
}

//メンバ変数に代入
void CUnRar::SetIStream(IStream* pIs){m_pIStream=pIs;}

//コールバック関数
int PASCAL CUnRar::RarCallbackProc(UINT uMsg,LPARAM UserData,LPARAM lParam1,LPARAM lParam2){
	CUnRar* _pCUnRar=(CUnRar*)UserData;
	return _pCUnRar->CallbackProc(uMsg,UserData,lParam1,lParam2);
}
