﻿//UnRarFile.h

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#ifndef UNRARFILE_H
#define UNRARFILE_H
#include"third-party/unrar/unrar.h"

typedef const RARHeaderDataEx* LPCRARHeaderDataEx;
typedef const RAROpenArchiveDataEx* LPCRAROpenArchiveDataEx;

typedef HANDLE(WINAPI*PRAROPENARCHIVEEX)(struct RAROpenArchiveDataEx *ArchiveData);
typedef int(WINAPI*PRARCLOSEARCHIVE)(HANDLE hArcData);
typedef int(WINAPI*PRARREADHEADEREX)(HANDLE hArcData,struct RARHeaderDataEx *HeaderData);
typedef int(WINAPI*PRARPROCESSFILE)(HANDLE hArcData,int Operation,char *DestPath,char *DestName);
typedef int(WINAPI*PRARPROCESSFILEW)(HANDLE hArcData,int Operation,wchar_t *DestPath,wchar_t *DestName);
typedef void(WINAPI*PRARSETCALLBACK)(HANDLE hArcData,UNRARCALLBACK Callback,LPARAM UserData);
typedef void(WINAPI*PRARSETPASSWORD)(HANDLE hArcData,char *Password);
typedef int(WINAPI*PRARGETDLLVERSION)();

class CUnRar{
public:
	CUnRar();
	virtual ~CUnRar();

public:
	//初期化
	void Initialize();
	//DLLをロード
	void LoadDll();
	//DLLをアンロード
	void UnloadDll();
	//rarファイルを開く
	bool OpenFile(LPCTSTR lpFile,bool bListingOnly=true,char* cmtBuf=NULL,UINT cmtBufSize=0,char* szPassword=NULL);
	//rarファイルを閉じる
	bool CloseFile();
	//rarファイル内のファイルの情報を読み込む
	bool ReadFileInfo();
	//RAR_OM_LISTの場合、次のファイル位置までスキップ
	//RAR_OM_EXTRACTの場合、書庫テストを行う
	virtual bool ProcessFile();
	//次のファイル位置までスキップ
	virtual bool SkipFile();
	virtual bool SkipFiles(UINT64 ui64);
	//コールバック関数
	virtual int CallbackProc(UINT uMsg,LPARAM UserData,LPARAM lParam1,LPARAM lParam2);
	//ストリームに出力
	virtual int ProcessFileData(LPBYTE lpBuffer,ULONG uiBufferSize);
	//メンバ変数に代入
	void SetIStream(IStream* pIs);
	//DLLが使用可能な状況であるか否か
	inline bool CheckReady(){return m_bDllReady;}
	//rarファイルの情報を取得
	inline LPCRAROpenArchiveDataEx GetArchiveInfo(){return &m_rOpenArchiveDataEx;}
	//rarファイル内のファイルの情報を取得
	inline LPCRARHeaderDataEx GetFileInfo(){return &m_rHeaderDataEx;}
	//パスワードを設定
	inline void SetPassword(char* szPassword){RARSetPassword(m_hArc,szPassword);}
	//エラーを取得
	inline int GetLastError(){return m_iResult;}
	//ファイル名を取得
	//UNICODE以外でビルドされる事を想定していないのでコメントアウト
	inline LPCTSTR GetFileName(){
	//#ifdef UNICODE
		return GetFileInfo()->FileNameW;
	//#else
	//	return (LPCTSTR)CUnRar::GetItemInfo()->FileName;
	//#endif
	}
	//Volume attribute (archive volume)
	inline bool IsArchiveVolume(){return (bool)(m_rOpenArchiveDataEx.Flags&0x0001);}
	//Archive lock attribute
	//inline bool IsArchiveComment(){return (bool)(m_rOpenArchiveDataEx.Flags&0x0002);}
	//Archive comment present
	//inline bool IsArchiveLocked(){return (bool)(m_rOpenArchiveDataEx.Flags&0x0004);}
	//Solid attribute
	inline bool IsArchiveSolid(){return (bool)(m_rOpenArchiveDataEx.Flags&0x0008);}
	//New volume naming scheme ('volname.partN.rar')
	//inline bool IsArchivePartN(){return (bool)(m_rOpenArchiveDataEx.Flags&0x0010);}
	//Authenticity information present
	//inline bool IsArchiveAuthenticityInfo(){return (bool)(m_rOpenArchiveDataEx.Flags&0x0020);}
	//Recovery record present
	//inline bool IsArchiveRecoveryRecord(){return (bool)(m_rOpenArchiveDataEx.Flags&0x0040);}
	//Block headers are encrypted
	inline bool IsArchiveEncryptedHeaders(){return (bool)(m_rOpenArchiveDataEx.Flags&0x0080);}
	//First volume (set only by RAR 3.0 and later)
	//inline bool IsArchiveFirstVolume(){return (bool)(m_rOpenArchiveDataEx.Flags&0x0100);}
	//ディレクトリであるか否か
	inline bool IsDirectory(){
		return (m_iDllVer<6)?(m_rHeaderDataEx.Flags&0xE0)==0xE0:
							(m_rHeaderDataEx.Flags&0x20)==0x20;
	}
	//64bit用圧縮/解凍されたファイルサイズを取得
	inline UINT64 GetFilePackedSize64(){return ((((UINT64)m_rHeaderDataEx.PackSizeHigh)<<32)|m_rHeaderDataEx.PackSize);}
	inline UINT64 GetFileUnpackedSize64(){return ((((UINT64)m_rHeaderDataEx.UnpSizeHigh)<<32)|m_rHeaderDataEx.UnpSize);}

private:
	bool m_bDllReady;//DLLが使用可能な状況であるか否か
	int m_iDllVer;//DLLのバージョン
	HMODULE m_hDll;//DLLのハンドル
	HANDLE m_hArc;//rarファイルのハンドル
	RARHeaderDataEx m_rHeaderDataEx;
	RAROpenArchiveDataEx m_rOpenArchiveDataEx;
	int m_iResult;
	IStream* m_pIStream;

	PRAROPENARCHIVEEX pRAROpenArchiveEx;
	PRARCLOSEARCHIVE pRARCloseArchive;
	PRARREADHEADEREX pRARReadHeaderEx;
	PRARPROCESSFILE pRARProcessFile;
	PRARPROCESSFILEW pRARProcessFileW;
	PRARSETCALLBACK pRARSetCallback;
	PRARSETPASSWORD pRARSetPassword;
	PRARGETDLLVERSION pRARGetDllVersion;

private:
	//コールバック関数
	static int PASCAL RarCallbackProc(UINT uMsg,LPARAM UserData,LPARAM lParam1,LPARAM lParam2);
};
#endif //UNRARFILE_H
