﻿//UnZipFile.cpp
//unzip.cppのラッパー

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"UnZipFile.h"

//コンストラクタ
CUnZip::CUnZip():m_ZipEntry(),m_FileEntry(),m_hZip(),m_zResult(){}

//デストラクタ
CUnZip::~CUnZip(){::CloseZip(m_hZip);}

//zipファイルを開く
bool CUnZip::OpenFile(LPCTSTR lpFile){
	if(lpFile==NULL)return false;
	HZIP hZipTmp=::OpenZip(lpFile,NULL);
	if(hZipTmp==NULL)return false;
	CloseFile();
	m_hZip=hZipTmp;
	if(ZR_OK!=::GetZipItem(m_hZip,-1,&m_ZipEntry))return false;
	return true;
}

//zipファイルを閉じる
void CUnZip::CloseFile(){
	CloseZip(m_hZip);
	m_hZip=NULL;
}

//iIndex番目のファイルの情報を取得
bool CUnZip::GetFileInfo(int iIndex){
	m_zResult=::GetZipItem(m_hZip,iIndex,&m_FileEntry);
	return (ZR_OK==m_zResult);
}

//ファイルをメモリに読み込む
bool CUnZip::ExtractMem(int iIndex, void *pBuffer,unsigned int uiLen){
	m_zResult=::UnzipItem(m_hZip,iIndex,pBuffer,uiLen);
	return (ZR_OK==m_zResult);
}
