﻿//UnZipFile.h

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#ifndef UNZIPFILE_H
#define UNZIPFILE_H
#include"third-party/zip_utils/unzip.h"

class CUnZip{
public:
	CUnZip();
	virtual ~CUnZip();

public:
	//zipファイルを開く
	bool OpenFile(LPCTSTR lpFile);
	//zipファイルを閉じる
	void CloseFile();
	//ファイル数を取得
	int GetFileCount()const{return m_ZipEntry.index;}
	//iIndex番目のファイルの情報を取得
	bool GetFileInfo(int iIndex);
	//ファイルをメモリに読み込む
	bool ExtractMem(int iIndex, void *pBuffer,unsigned int uiLen);
	//ファイル名を取得
	LPCTSTR GetFileName(){return m_FileEntry.name;}
	//圧縮されたファイルサイズを取得
	long GetCompressedSize()const{return m_FileEntry.comp_size;}
	//解凍されたファイルサイズを取得
	long GetUncompressedSize()const{return m_FileEntry.unc_size;}
	//ファイルの属性を取得
	DWORD GetAttributes()const{return m_FileEntry.attr;}
	//ディレクトリであるか否か
	inline bool IsDirectory(){return CUnZip::GetAttributes()&FILE_ATTRIBUTE_DIRECTORY;}//0x00000010);}

private:
	ZIPENTRY m_ZipEntry, m_FileEntry;
	HZIP m_hZip;
	ZRESULT m_zResult;
};
#endif //UNZIPFILE_H
