﻿//ArcDll.cpp
//統合アーカイバDll操作クラス
//一部の関数のみに対応

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"ArcDll.h"

//コンストラクタ
CArcDll::CArcDll():m_hDll(NULL),m_hArc(NULL),m_bUnicodeMode(false){
}

//デストラクタ
CArcDll::~CArcDll(){
	if(m_hArc)CloseArchive();
	UnloadDll();
}

//DLLをロードします
bool CArcDll::LoadDll(LPCTSTR lpszDllName,LPCTSTR lpszDllPrefix){
	UnloadDll();
	m_lpszDllName=lpszDllName;
	m_hArc=NULL;
	m_bUnicodeMode=false;
	m_lpszDllPrefix=lpszDllPrefix;
	if(m_hDll==NULL){
		m_hDll=::LoadLibrary(m_lpszDllName);
		if(m_hDll==NULL)return false;
#ifdef UNICODE
		SetUnicodeMode(true);
#endif
	}
	return true;
}

//DLLを開放します
bool CArcDll::UnloadDll(){
	if (m_hDll!=NULL){
		::FreeLibrary(m_hDll);
		m_hArc=NULL;
		m_hDll=NULL;
		m_bUnicodeMode=false;
		return true;
	}
	return false;
}

//関数名を投げるだけで良いGetProcAddress
FARPROC CArcDll::GetProcAddress(LPCTSTR lpszProcName){
	if(m_hDll==NULL||lpszProcName==NULL){
		::SetLastError(ERROR_INVALID_PARAMETER);
		return NULL;
	}
	bool bSuccess=false;
	const int iBuffer=MAX_PATH*2;//適当...
	std::vector<char> szProcName(iBuffer);
	//UNICODE以外でビルドされる事を想定していないので#ifndef UNICODEは未実装
	LPWSTR lpszProcNameW=(LPWSTR)malloc(iBuffer);
	::wsprintf(lpszProcNameW,_T("%s%s"),m_lpszDllPrefix,lpszProcName);
	DWORD dwLen=WideCharToMultiByte(CP_ACP,0,(LPCWSTR)lpszProcNameW,-1,NULL,0,NULL,NULL);
	if(!::WideCharToMultiByte(CP_ACP,0,(LPCWSTR)lpszProcNameW,-1,&szProcName[0],dwLen,NULL,NULL)){
		::SetLastError(ERROR_INVALID_PARAMETER);
	}else{
		bSuccess=true;
	}
	free(lpszProcNameW);
	return ::GetProcAddress(m_hDll,&szProcName[0]);
}

//DLLの動作中にカーソルを表示するモードか否かを設定します
bool CArcDll::SetCursorMode(const bool _CursorMode){
	typedef bool(WINAPI*PSETCURSORMODE)(const bool);
	PSETCURSORMODE pSetCursorMode;
	bool bResult=false;
	if(QueryFunctionList(ISARC_SET_CURSOR_MODE)){
		if((pSetCursorMode=(PSETCURSORMODE)GetProcAddress(_T("SetCursorMode")))!=NULL){
			bResult=pSetCursorMode(_CursorMode);
		}
	}
	return bResult;
}

//現在DLLが動作中か否かを得ます
bool CArcDll::GetRunning(){
	typedef bool(WINAPI*PGETRUNNING)(void);
	PGETRUNNING pGetRunning;
	bool bResult=false;
	if(QueryFunctionList(ISARC_GET_RUNNING)){
		if((pGetRunning=(PGETRUNNING)GetProcAddress(_T("GetRunning")))!=NULL){
			bResult=pGetRunning();
		}
	}
	return bResult;
}

//指定ファイルがサポートしている書庫ファイルとして
//正しいかどうかを返します。
bool CArcDll::CheckArchive(LPCTSTR _szFileName,const int _iMode){
	typedef bool(WINAPI*PCHECKARCHIVE)(LPCSTR,const int);
	PCHECKARCHIVE pCheckArchive;
	bool bResult=false;
	if(QueryFunctionList(ISARC_CHECK_ARCHIVE)){
		if((pCheckArchive=(PCHECKARCHIVE)GetProcAddress(_T("CheckArchive")))!=NULL){
			int iLength=WideCharToMultiByte((m_bUnicodeMode)?CP_UTF8:CP_ACP,0,_szFileName,-1,NULL,0,NULL,NULL);
			char* pszFileNameA=(char*)malloc(iLength);
			WideCharToMultiByte((m_bUnicodeMode)?CP_UTF8:CP_ACP, 0,_szFileName,-1,pszFileNameA,iLength,NULL,NULL);

			bResult=pCheckArchive(pszFileNameA,_iMode);

			free(pszFileNameA);
		}
	}
	return bResult;
}

//指定したアーカイブファイルの形式を得ます。
int CArcDll::GetArchiveType(LPCSTR _szFileName){
	typedef int(WINAPI*PGETARCHIVETYPE)(LPCSTR);
	PGETARCHIVETYPE pGetArchiveType;
	int iResult=-1;
	if((pGetArchiveType=(PGETARCHIVETYPE)GetProcAddress(_T("GetArchiveType")))!=NULL){
		iResult=pGetArchiveType(_szFileName);
	}
	return iResult;
}

//指定されたAPIが使用可能かどうかを得ます
bool CArcDll::QueryFunctionList(const int _iFunction){
	typedef bool(WINAPI*PQUERYFUNCTIONLIST)(const int);
	PQUERYFUNCTIONLIST pQueryFunctionList;
	bool bResult=false;
	if((pQueryFunctionList=(PQUERYFUNCTIONLIST)GetProcAddress(_T("QueryFunctionList")))!=NULL){
		bResult=pQueryFunctionList(_iFunction);
	}
	return bResult;
}

//指定ファイルが有効な書庫ファイルかどうか調べ、
//有効であればオープンし、一意の数値(ハンドル)を返します。
HARC CArcDll::OpenArchive(const HWND _hwnd, LPCTSTR _szFileName,const DWORD _dwMode){
	typedef HARC(WINAPI*POPENARCHIVE)(const HWND, LPCSTR,const DWORD);
	POPENARCHIVE pOpenArchive;
	m_hArc=NULL;
	if(QueryFunctionList(ISARC_OPEN_ARCHIVE)){
		if((pOpenArchive=(POPENARCHIVE)GetProcAddress(_T("OpenArchive")))!=NULL){
			int iLength=WideCharToMultiByte((m_bUnicodeMode)?CP_UTF8:CP_ACP,0,_szFileName,-1,NULL,0,NULL,NULL);
			char* pszFileNameA=(char*)malloc(iLength);
			WideCharToMultiByte((m_bUnicodeMode)?CP_UTF8:CP_ACP, 0,_szFileName,-1,pszFileNameA,iLength,NULL,NULL);

			m_hArc=pOpenArchive(_hwnd,pszFileNameA,_dwMode);

			free(pszFileNameA);
		}
	}
	return m_hArc;
}

//OpenArchive()で割り付けたハンドルを解放する
int CArcDll::CloseArchive(){
	typedef int(WINAPI*PCLOSEARCHIVE)(HARC);
	PCLOSEARCHIVE pCloseArchive;
	int iResult=-1;
	if(QueryFunctionList(ISARC_CLOSE_ARCHIVE)){
		if((pCloseArchive=(PCLOSEARCHIVE)GetProcAddress(_T("CloseArchive")))!=NULL){
			iResult=pCloseArchive(m_hArc);
		}
	}
	m_hArc=NULL;
	return iResult;
}


//最初の格納ファイルの情報を得ます
int CArcDll::FindFirst(LPCTSTR _szWildName,INDIVIDUALINFO FAR *lpSubInfo){
	typedef int(WINAPI*PFINDFIRST)(HARC,LPCSTR,INDIVIDUALINFO FAR *);
	PFINDFIRST pFindFirst;
	int iResult=-1;
	if(QueryFunctionList(ISARC_FIND_FIRST)){
		if((pFindFirst=(PFINDFIRST)GetProcAddress(_T("FindFirst")))!=NULL){
			char szWildNameA[MAX_PATH]={};

			if(m_bUnicodeMode){
				WideCharToMultiByte(CP_UTF8,0,_szWildName,-1,szWildNameA,MAX_PATH,NULL,NULL);
			}else{
				WideCharToMultiByte(CP_ACP,0,_szWildName,-1,szWildNameA,MAX_PATH,NULL,NULL);
			}

			iResult=pFindFirst(m_hArc,szWildNameA,lpSubInfo);
		}
	}
	return iResult;
}

//次の格納ファイルの情報を得ます
int CArcDll::FindNext(INDIVIDUALINFO FAR *_lpSubInfo){
	typedef int(WINAPI*PFINDNEXT)(HARC,INDIVIDUALINFO FAR *);
	PFINDNEXT pFindNext;
	int iResult=2;
	if(QueryFunctionList(ISARC_FIND_NEXT)){
		if((pFindNext=(PFINDNEXT)GetProcAddress(_T("FindNext")))!=NULL){
			iResult=pFindNext(m_hArc,_lpSubInfo);
		}
	}
	return iResult;
}

//格納ファイルのファイル名を得ます
int CArcDll::GetFileName(LPTSTR _lpBuffer,const int _nSize){
	typedef int(WINAPI*PGETFILENAME)(HARC,LPSTR,const int);
	PGETFILENAME pGetFileName;
	int iResult=-1;
	if(QueryFunctionList(ISARC_GET_FILE_NAME)){
		if((pGetFileName=(PGETFILENAME)GetProcAddress(_T("GetFileName")))!=NULL){
			std::vector<char> vBuffer(_nSize);

			iResult=pGetFileName(m_hArc,&vBuffer[0],_nSize);

			if(m_bUnicodeMode){
				MultiByteToWideChar(CP_UTF8,0,&vBuffer[0],-1,_lpBuffer,_nSize);
			}else{
				MultiByteToWideChar(CP_ACP,0,&vBuffer[0],-1,_lpBuffer,_nSize);
			}
		}
	}
	return iResult;
}

//格納ファイルのサイズを64ビット整数で得ます
bool CArcDll::GetOriginalSizeEx(__int64* lpllSize){
	typedef bool(WINAPI*PGETORIGINALSIZEEX)(HARC,__int64*);
	PGETORIGINALSIZEEX pGetOriginalSizeEx;
	bool bResult=false;
	if(QueryFunctionList(ISARC_GET_ARC_ORIGINAL_SIZE_EX)){
		if((pGetOriginalSizeEx=(PGETORIGINALSIZEEX)GetProcAddress(_T("GetOriginalSizeEx")))!=NULL){
			bResult=pGetOriginalSizeEx(m_hArc,lpllSize);
		}
	}
	return bResult;
}

//格納ファイルの圧縮サイズを得ます
bool CArcDll::GetCompressedSizeEx(__int64* lpllSize){
	typedef bool(WINAPI*PGETCOMPRESSEDSIZEEX)(HARC,__int64*);
	PGETCOMPRESSEDSIZEEX pGetCompressedSizeEx;
	bool bResult=false;
	if(QueryFunctionList(ISARC_GET_ARC_COMPRESSED_SIZE_EX)){
		if((pGetCompressedSizeEx=(PGETCOMPRESSEDSIZEEX)GetProcAddress(_T("GetCompressedSizeEx")))!=NULL){
			bResult=pGetCompressedSizeEx(m_hArc,lpllSize);
		}
	}
	return bResult;
}

//格納ファイルの属性を得ます
int CArcDll::GetAttribute(){
	typedef int(WINAPI*PGETATTRIBUTE)(HARC);
	PGETATTRIBUTE pGetAttribute;
	int iResult=-1;
	if(QueryFunctionList(ISARC_GET_ATTRIBUTE)){
		if((pGetAttribute=(PGETATTRIBUTE)GetProcAddress(_T("GetAttribute")))!=NULL){
			iResult=pGetAttribute(m_hArc);
		}
	}
	return iResult;
}

//メモリーバッファへ展開します
int CArcDll::ExtractMem(HWND hwnd,LPCTSTR szCmdLine,LPBYTE szBuffer,const DWORD dwSize,time_t* lpTime,LPWORD lpwAttr,LPDWORD lpdwWriteSize){
	typedef int(WINAPI*PEXTRACTMEM)(HWND,LPCSTR,LPBYTE,const DWORD,time_t*,LPWORD,LPDWORD);
	PEXTRACTMEM pExtractMem;
	int iResult=-1;
	if((pExtractMem=(PEXTRACTMEM)GetProcAddress(_T("ExtractMem")))!=NULL){
		int iLength=WideCharToMultiByte((m_bUnicodeMode)?CP_UTF8:CP_ACP,0,szCmdLine,-1,NULL,0,NULL,NULL);
		char* pszCmdLineA=(char*)malloc(iLength);
		WideCharToMultiByte((m_bUnicodeMode)?CP_UTF8:CP_ACP,0,szCmdLine,-1,pszCmdLineA,iLength,NULL,NULL);

		iResult=pExtractMem(hwnd,pszCmdLineA,szBuffer,dwSize,lpTime,lpwAttr,lpdwWriteSize);
		free(pszCmdLineA);
	}
	return iResult;
}

//使用する文字コードをUTF-8に設定、及び解除を行います。(7-zip32)
//ANSI 版 API を UTF-8 の文字コードで使用するかどうかを指定します。(UNLHA32.DLL)
bool CArcDll::SetUnicodeMode(bool _bUnicode){
	typedef BOOL(WINAPI*PSETUNICODEMODE)(BOOL);
	PSETUNICODEMODE pSetUnicodeMode;
	bool bResult=false;

	if(QueryFunctionList(ISARC_SET_UNICODE_MODE)){
		if((pSetUnicodeMode=(PSETUNICODEMODE)GetProcAddress(_T("SetUnicodeMode")))!=NULL){
			bResult=pSetUnicodeMode(_bUnicode)!=0;
		}
	}
	m_bUnicodeMode=bResult;
	return bResult;
}
