﻿//ListView.cpp
//リストビュー操作

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"ListView.h"
#include<commctrl.h>



//カラムの位置を取得
int ListView_GetColumnIndex(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,int iListItem){
	if(iListItem>=LISTITEM_NUM||!pListViewColumn_Table[iListItem].bVisible)return -1;
	for(int i=iListItem;i>=0;i--){
		if(!pListViewColumn_Table[i].bVisible)iListItem--;
	}
	return iListItem;
}

//全てのカラムの幅を取得
int ListView_GetAllColumnWidth(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table){
	int iWidth=0;

	for(int i=0;i<LISTITEM_NUM;i++){
		if(pListViewColumn_Table[i].bVisible)iWidth+=*(pListViewColumn_Table[i].piWidth);
	}
	return iWidth;
}

//カラムの数を取得
int ListView_GetColumnCount(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table){
	int iCount=0;

	for(int i=0;i<LISTITEM_NUM;i++){
		if(pListViewColumn_Table[i].bVisible)iCount++;
	}
	return iCount;
}

//カラムを追加
bool ListView_AddColumn(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,HWND hListView,int iIndex,LVCOLUMN* plvColumn){
	bool bResult=false;

	if(iIndex>=LISTITEM_NUM)return false;
	if(!pListViewColumn_Table[iIndex].bVisible){
		if((bResult=ListView_InsertColumn(hListView,iIndex,plvColumn))){
			pListViewColumn_Table[iIndex].bVisible=*(pListViewColumn_Table[iIndex].piWidth)!=0;
		}
	}
	return bResult;
}

//カラムを削除
bool ListView_RemoveColumn(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,HWND hListView,int iIndex){
	bool bResult=false;

	if(iIndex>=LISTITEM_NUM)return false;
	if(pListViewColumn_Table[iIndex].bVisible){
		//実際に削除するとややこしくなるので、カラム幅を0にする
		//0にしてもカーソルが変化してしまうため、リストビューヘッダーのWM_MOUSEMOVEでSetCursor()する
/*		if((bResult=ListView_DeleteColumn(hListView))){
			pListViewColumn_Table[iIndex].bVisible=false;
		}
*/
		pListViewColumn_Table[iIndex].iOldWidth=ListView_GetColumnWidth(hListView,pListViewColumn_Table[iIndex].iListItem);
		*(pListViewColumn_Table[iIndex].piWidth)=0;
		pListViewColumn_Table[iIndex].bVisible=false;
		ListView_SetColumnWidth(hListView,pListViewColumn_Table[iIndex].iListItem,*(pListViewColumn_Table[iIndex].piWidth));
	}
	return bResult;
}

//カラムを再表示
bool ListView_RedisplayColumn(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,HWND hListView,int iIndex){
	bool bResult=false;

	if(iIndex>=LISTITEM_NUM)return false;
	if(!pListViewColumn_Table[iIndex].bVisible){
		if(pListViewColumn_Table[iIndex].iOldWidth==0){
			pListViewColumn_Table[iIndex].iOldWidth=pListViewColumn_Table[iIndex].iDefaultWidth;
		}
		*(pListViewColumn_Table[iIndex].piWidth)=pListViewColumn_Table[iIndex].iOldWidth;
		pListViewColumn_Table[iIndex].bVisible=true;
		ListView_SetColumnWidth(hListView,pListViewColumn_Table[iIndex].iListItem,*(pListViewColumn_Table[iIndex].piWidth));
	}
	return bResult;
}

//カラムの情報を初期化
void LisView_InitColumn(struct LISTVIEWCOLUMN_TABLE* pListViewColumn_Table,struct CONFIG* pConfig,HWND hListView){
	pListViewColumn_Table[LISTITEM_CURRENTFILENAME].iListItem=LISTITEM_CURRENTFILENAME;
	pListViewColumn_Table[LISTITEM_CURRENTFILENAME].iMenuId=IDM_CURRENTFILENAME_HEADER;
	pListViewColumn_Table[LISTITEM_CURRENTFILENAME].bVisible=false;//pConfig->ListViewColumn.iCurrentFileNameWidth!=0;
	pListViewColumn_Table[LISTITEM_CURRENTFILENAME].piWidth=&pConfig->ListViewColumn.iCurrentFileNameWidth;
	pListViewColumn_Table[LISTITEM_CURRENTFILENAME].iOldWidth=pConfig->ListViewColumn.iCurrentFileNameWidth;
	pListViewColumn_Table[LISTITEM_CURRENTFILENAME].iDefaultWidth=DEFAULT_CURRENTFILENAME_WIDTH;

	pListViewColumn_Table[LISTITEM_NEWFILENAME].iListItem=LISTITEM_NEWFILENAME;
	pListViewColumn_Table[LISTITEM_NEWFILENAME].iMenuId=IDM_NEWFILENAME_HEADER;
	pListViewColumn_Table[LISTITEM_NEWFILENAME].bVisible=false;//pConfig->ListViewColumn.iNewFileNameWidth!=0;
	pListViewColumn_Table[LISTITEM_NEWFILENAME].piWidth=&pConfig->ListViewColumn.iNewFileNameWidth;
	pListViewColumn_Table[LISTITEM_NEWFILENAME].iOldWidth=pConfig->ListViewColumn.iNewFileNameWidth;
	pListViewColumn_Table[LISTITEM_NEWFILENAME].iDefaultWidth=DEFAULT_NEWFILENAME_WIDTH;

	pListViewColumn_Table[LISTITEM_STATUS].iListItem=LISTITEM_STATUS;
	pListViewColumn_Table[LISTITEM_STATUS].iMenuId=IDM_STATUS_HEADER;
	pListViewColumn_Table[LISTITEM_STATUS].bVisible=false;//pConfig->ListViewColumn.iStatusWidth!=0;
	pListViewColumn_Table[LISTITEM_STATUS].piWidth=&pConfig->ListViewColumn.iStatusWidth;
	pListViewColumn_Table[LISTITEM_STATUS].iOldWidth=pConfig->ListViewColumn.iStatusWidth;
	pListViewColumn_Table[LISTITEM_STATUS].iDefaultWidth=DEFAULT_STATUS_WIDTH;

	pListViewColumn_Table[LISTITEM_DIRECTORY].iListItem=LISTITEM_DIRECTORY;
	pListViewColumn_Table[LISTITEM_DIRECTORY].iMenuId=IDM_DIRECTORY_HEADER;
	pListViewColumn_Table[LISTITEM_DIRECTORY].bVisible=false;//pConfig->ListViewColumn.iDirectoryWidth!=0;
	pListViewColumn_Table[LISTITEM_DIRECTORY].piWidth=&pConfig->ListViewColumn.iDirectoryWidth;
	pListViewColumn_Table[LISTITEM_DIRECTORY].iOldWidth=pConfig->ListViewColumn.iDirectoryWidth;
	pListViewColumn_Table[LISTITEM_DIRECTORY].iDefaultWidth=DEFAULT_DIRECTORY_WIDTH;

	pListViewColumn_Table[LISTITEM_SIZE].iListItem=LISTITEM_SIZE;
	pListViewColumn_Table[LISTITEM_SIZE].iMenuId=IDM_SIZE_HEADER;
	pListViewColumn_Table[LISTITEM_SIZE].bVisible=false;//pConfig->ListViewColumn.iSizeWidth!=0;
	pListViewColumn_Table[LISTITEM_SIZE].piWidth=&pConfig->ListViewColumn.iSizeWidth;
	pListViewColumn_Table[LISTITEM_SIZE].iOldWidth=pConfig->ListViewColumn.iSizeWidth;
	pListViewColumn_Table[LISTITEM_SIZE].iDefaultWidth=DEFAULT_SIZE_WIDTH;

	pListViewColumn_Table[LISTITEM_TYPE].iListItem=LISTITEM_TYPE;
	pListViewColumn_Table[LISTITEM_TYPE].iMenuId=IDM_TYPE_HEADER;
	pListViewColumn_Table[LISTITEM_TYPE].bVisible=false;//pConfig->ListViewColumn.iTypeWidth!=0;
	pListViewColumn_Table[LISTITEM_TYPE].piWidth=&pConfig->ListViewColumn.iTypeWidth;
	pListViewColumn_Table[LISTITEM_TYPE].iOldWidth=pConfig->ListViewColumn.iTypeWidth;
	pListViewColumn_Table[LISTITEM_TYPE].iDefaultWidth=DEFAULT_TYPE_WIDTH;

	pListViewColumn_Table[LISTITEM_LASTMODIFIED].iListItem=LISTITEM_LASTMODIFIED;
	pListViewColumn_Table[LISTITEM_LASTMODIFIED].iMenuId=IDM_LASTMODIFIED_HEADER;
	pListViewColumn_Table[LISTITEM_LASTMODIFIED].bVisible=false;//pConfig->ListViewColumn.iLastModifiedWidth!=0;
	pListViewColumn_Table[LISTITEM_LASTMODIFIED].piWidth=&pConfig->ListViewColumn.iLastModifiedWidth;
	pListViewColumn_Table[LISTITEM_LASTMODIFIED].iOldWidth=pConfig->ListViewColumn.iLastModifiedWidth;
	pListViewColumn_Table[LISTITEM_LASTMODIFIED].iDefaultWidth=DEFAULT_LASTMODIFIED_WIDTH;

	for(int i=0;i<LISTITEM_NUM;i++){
		ListView_SetColumnWidth(hListView,i,*(pListViewColumn_Table[i].piWidth));
	}
	return;
}

//先頭を選択する
void ListView_SelectBeginningItem(HWND hListView){
	ListView_EnsureVisible(hListView,0,false);
	ListView_SetItemState(hListView,0,LVIS_FOCUSED|LVIS_SELECTED,LVIS_FOCUSED|LVIS_SELECTED);
	return;
}

//末尾を選択する
void ListView_SelectEndItem(HWND hListView){
	ListView_EnsureVisible(hListView,ListView_GetItemCount(hListView)-1,false);
	ListView_SetItemState(hListView,ListView_GetItemCount(hListView)-1,LVIS_FOCUSED|LVIS_SELECTED,LVIS_FOCUSED|LVIS_SELECTED);
	return;
}

//一つ上を選択する
void ListView_SelectPrevItem(HWND hListView){
	int iIndex=ListView_GetNextItem(hListView,-1,LVNI_SELECTED);

	if(!iIndex){
		ListView_SelectEndItem(hListView);
	}else{
		iIndex--;
		ListView_EnsureVisible(hListView,iIndex,false);
		ListView_SetItemState(hListView,iIndex,LVIS_FOCUSED|LVIS_SELECTED,LVIS_FOCUSED|LVIS_SELECTED);
	}
	return;
}

//一つ下を選択する
void ListView_SelectNextItem(HWND hListView){
	int iIndex=ListView_GetNextItem(hListView,-1,LVNI_SELECTED);

	if(iIndex==ListView_GetItemCount(hListView)-1){
		ListView_SelectBeginningItem(hListView);
	}else{
		iIndex++;
		ListView_EnsureVisible(hListView,iIndex,false);
		ListView_SetItemState(hListView,iIndex,LVIS_FOCUSED|LVIS_SELECTED,LVIS_FOCUSED|LVIS_SELECTED);
	}
	return;
}


//指定したIndexのアイテムを選択する
void ListView_SelectItem(HWND hListView,int iIndex){
	ListView_EnsureVisible(hListView,iIndex,false);
	ListView_SetItemState(hListView,iIndex,LVIS_FOCUSED|LVIS_SELECTED,LVIS_FOCUSED|LVIS_SELECTED);
	return;
}

//全て選択する
void ListView_SelectAll(HWND hListView){
	ListView_SetItemState(hListView,-1,LVIS_SELECTED,LVIS_SELECTED);
	return;
}

//選択を解除する
void ListView_SelectNone(HWND hListView){
	ListView_SetItemState(hListView,-1,0,LVIS_SELECTED);
	return;
}

//LVS_ICONの時のアイテムとアイテムの間隔(アイコンの幅を含む)を設定
DWORD ListView_SetItemSpacing(HWND hListView,int cx,int cy){
	//間隔をデフォルトの値にする場合、ListView_SetIconSpacing()でどちらも-1を指定しなければいけない
	//(片方だけ-1を指定することは出来ない)
	if((cx==-1&&cy!=-1)||(cx!=-1&&cy==-1)){
		//片方が-1だった場合
		ListView_SetIconSpacing(hListView,-1,-1);

		int _cx=0,_cy=0;

		DWORD dwResult=ListView_GetItemSpacing(hListView,false);
		_cx=LOWORD(dwResult);
		_cy=HIWORD(dwResult);

		return ListView_SetIconSpacing(hListView,(cx==-1)?_cx:cx,(cy==-1)?_cy:cy);
	}else{
		return ListView_SetIconSpacing(hListView,cx,cy);
	}
}
