﻿#ifndef PATH_H
#define PATH_H

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#ifdef __cplusplus
namespace path{
extern "C"{
#endif

//文字列から文字を検索し、その最初の位置を返す
int LocateFirstCharacter(const TCHAR* pszStr,int iChar);
//文字列から文字を検索し、その最後の位置を返す
int LocateLastCharacter(const TCHAR* pszStr,int iChar);
//文字列から文字を検索し、その個数を返す
int CountCharacter(const TCHAR* pszStr,int iChar);
//ファイル名に使えない文字が含まれるかどうか
bool IsBadName(TCHAR* pszFileName);
//末尾にスラッシュ/バックスラッシュを追加
bool AddBackSlash(TCHAR* pszResult,const TCHAR* pszPath);
//親ディレクトリを取得
bool GetParentDirectory(TCHAR* pszResult,const TCHAR* pszPath);
//ルートディレクトリを取得
bool GetRootDirectory(TCHAR* pszResult,const TCHAR* pszPath);
//実行ファイルのディレクトリを取得
bool GetExeDirectory(TCHAR* pszResult,const int iSize);
//ワイルドカードを含む文字列を比較
bool MatchSpec(const TCHAR* pszFile,const TCHAR* pszSpec);
//ディレクトリであるかどうか
bool IsDirectory(const TCHAR* pszPath);
//ファイルが存在するか否か
bool FileExists(const TCHAR* pszPath);
//ファイルの最終更新日時を取得
bool GetFileLastModified(const TCHAR* pszPath,LPFILETIME lpftLastModified);

#ifdef __cplusplus
}//extern
}//namespace
#endif

#endif //PATH_H
