﻿//PrivateProfile.cpp
//cfgファイル操作

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"PrivateProfile.h"
#include"Function.h"
#include"Path.h"
#include<gdiplus.h>

TCHAR g_szPrivateProfile[MAX_PATH]={};

//cfgファイルパスを取得
void GetPrivateProfilePath(){
	path::GetExeDirectory(g_szPrivateProfile,MAX_PATH);
	_tcscat(g_szPrivateProfile,_T("\\Ashley.cfg"));
	return;
}

//整数を文字列に変換してPrivateProfileファイルに書き込む
bool WINAPI WritePrivateProfileInt(LPCTSTR lpAppName,LPCTSTR lpKeyName,LONG_PTR lData,LPCTSTR lpFileName){
	TCHAR szValue[100];
	wsprintf(szValue,_T("%d"),lData);
	return WritePrivateProfileString(lpAppName,lpKeyName,szValue,lpFileName);
}

//PrivateProfileファイルへ書き込む
void WritePrivateProfile(HWND hWnd){
	WINDOWPLACEMENT wpl;

	//現在のウインドウの状態を取得
	GetWindowPlacement(hWnd,&wpl);
	//ウインドウの状態
	WritePrivateProfileInt(_T("WindowState"),_T("Maximized"),(wpl.showCmd==SW_SHOWMAXIMIZED||wpl.flags&WPF_RESTORETOMAXIMIZED),g_szPrivateProfile);
	WritePrivateProfileInt(_T("WindowState"),_T("Left"),wpl.rcNormalPosition.left,g_szPrivateProfile);
	WritePrivateProfileInt(_T("WindowState"),_T("top"),wpl.rcNormalPosition.top,g_szPrivateProfile);
	WritePrivateProfileInt(_T("WindowState"),_T("Height"),wpl.rcNormalPosition.bottom-wpl.rcNormalPosition.top,g_szPrivateProfile);
	WritePrivateProfileInt(_T("WindowState"),_T("Width"),wpl.rcNormalPosition.right-wpl.rcNormalPosition.left,g_szPrivateProfile);


	//リストビューカラム
	//並び順
	TCHAR szColumnOrder[12]={};

	for(int i=0;i<LISTITEM_NUM;i++){
		TCHAR sz[3]={};

		wsprintf(sz,_T("%d"),g_Config.ListViewColumn.iOrder[i]);
		_tcscat(szColumnOrder,sz);
	}
	WritePrivateProfileString(_T("ListViewColumn"),_T("Order"),szColumnOrder,g_szPrivateProfile);

	//カラムの幅
	WritePrivateProfileInt(_T("ListViewColumn"),_T("CurrentFileNameWidth"),g_Config.ListViewColumn.iCurrentFileNameWidth,g_szPrivateProfile);
	WritePrivateProfileInt(_T("ListViewColumn"),_T("NewFileNameWidth"),g_Config.ListViewColumn.iNewFileNameWidth,g_szPrivateProfile);
	WritePrivateProfileInt(_T("ListViewColumn"),_T("StatusWidth"),g_Config.ListViewColumn.iStatusWidth,g_szPrivateProfile);
	WritePrivateProfileInt(_T("ListViewColumn"),_T("DirectoryWidth"),g_Config.ListViewColumn.iDirectoryWidth,g_szPrivateProfile);
	WritePrivateProfileInt(_T("ListViewColumn"),_T("SizeWidth"),g_Config.ListViewColumn.iSizeWidth,g_szPrivateProfile);
	WritePrivateProfileInt(_T("ListViewColumn"),_T("TypeWidth"),g_Config.ListViewColumn.iTypeWidth,g_szPrivateProfile);
	WritePrivateProfileInt(_T("ListViewColumn"),_T("LastModifiedWidth"),g_Config.ListViewColumn.iLastModifiedWidth,g_szPrivateProfile);


	//対象書庫ファイル
	WritePrivateProfileInt(_T("EnableFileType"),_T("Zip"),g_Config.EnableFileType.bZip,g_szPrivateProfile);
	WritePrivateProfileInt(_T("EnableFileType"),_T("7z"),g_Config.EnableFileType.b7z,g_szPrivateProfile);
	WritePrivateProfileInt(_T("EnableFileType"),_T("Cab"),g_Config.EnableFileType.bCab,g_szPrivateProfile);
	WritePrivateProfileInt(_T("EnableFileType"),_T("Lzh"),g_Config.EnableFileType.bLzh,g_szPrivateProfile);
	WritePrivateProfileInt(_T("EnableFileType"),_T("Rar"),g_Config.EnableFileType.bRar,g_szPrivateProfile);


	//サムネイルサイズ
	WritePrivateProfileInt(_T("Thumbnail"),_T("SmallSize"),g_Config.Thumbnail.iSmall,g_szPrivateProfile);
	WritePrivateProfileInt(_T("Thumbnail"),_T("NormalSize"),g_Config.Thumbnail.iNormal,g_szPrivateProfile);
	WritePrivateProfileInt(_T("Thumbnail"),_T("LargeSize"),g_Config.Thumbnail.iLarge,g_szPrivateProfile);

	WritePrivateProfileInt(_T("Thumbnail"),_T("SpacingX"),g_Config.Thumbnail.iSpacingX,g_szPrivateProfile);
	WritePrivateProfileInt(_T("Thumbnail"),_T("SpacingY"),g_Config.Thumbnail.iSpacingY,g_szPrivateProfile);

	//起動時のサムネイル
	WritePrivateProfileInt(_T("Thumbnail"),_T("Startup"),g_Config.Thumbnail.iStartup,g_szPrivateProfile);

	//サムネイルに先頭のファイルを採用する
	WritePrivateProfileInt(_T("Thumbnail"),_T("FirstFile"),g_Config.Thumbnail.bFirstFile,g_szPrivateProfile);

	//サムネイルの補間モード
	WritePrivateProfileInt(_T("Thumbnail"),_T("InterpolationMode"),g_Config.Thumbnail.iInterpolationMode,g_szPrivateProfile);


	//リストビューアイテムのデザイン
	TCHAR szTmp[12]={};

	//デフォルト(未処理ファイル)
	WritePrivateProfileString(_T("DefaultItemDesign"),_T("Font"),g_Config.DefaultItemDesign.szFont,g_szPrivateProfile);
	//リストビューの仕様上、iFontSizeはDefaultItemDesignでのみ有効にすること
	WritePrivateProfileInt(_T("DefaultItemDesign"),_T("FontSize"),g_Config.DefaultItemDesign.iFontSize,g_szPrivateProfile);
	WritePrivateProfileInt(_T("DefaultItemDesign"),_T("FontStyle"),g_Config.DefaultItemDesign.iFontStyle,g_szPrivateProfile);

	COLORREFToHex(szTmp,g_Config.DefaultItemDesign.clrText);
	WritePrivateProfileString(_T("DefaultItemDesign"),_T("TextColor"),szTmp,g_szPrivateProfile);

	COLORREFToHex(szTmp,g_Config.DefaultItemDesign.clrTextBk);
	WritePrivateProfileString(_T("DefaultItemDesign"),_T("BackColor"),szTmp,g_szPrivateProfile);

	//リストビューの仕様上、clrOutlineはDefaultItemDesignでのみ有効にすること
	COLORREFToHex(szTmp,g_Config.DefaultItemDesign.clrOutline);
	WritePrivateProfileString(_T("DefaultItemDesign"),_T("OutlineColor"),szTmp,g_szPrivateProfile);

	//リネームできるファイル
	WritePrivateProfileString(_T("ReadyItemDesign"),_T("Font"),g_Config.ReadyItemDesign.szFont,g_szPrivateProfile);
	WritePrivateProfileInt(_T("ReadyItemDesign"),_T("FontStyle"),g_Config.ReadyItemDesign.iFontStyle,g_szPrivateProfile);

	COLORREFToHex(szTmp,g_Config.ReadyItemDesign.clrText);
	WritePrivateProfileString(_T("ReadyItemDesign"),_T("TextColor"),szTmp,g_szPrivateProfile);

	COLORREFToHex(szTmp,g_Config.ReadyItemDesign.clrTextBk);
	WritePrivateProfileString(_T("ReadyItemDesign"),_T("BackColor"),szTmp,g_szPrivateProfile);

	//リネームしたファイル
	WritePrivateProfileString(_T("RenamedItemDesign"),_T("Font"),g_Config.RenamedItemDesign.szFont,g_szPrivateProfile);
	WritePrivateProfileInt(_T("RenamedItemDesign"),_T("FontStyle"),g_Config.RenamedItemDesign.iFontStyle,g_szPrivateProfile);

	COLORREFToHex(szTmp,g_Config.RenamedItemDesign.clrText);
	WritePrivateProfileString(_T("RenamedItemDesign"),_T("TextColor"),szTmp,g_szPrivateProfile);

	COLORREFToHex(szTmp,g_Config.RenamedItemDesign.clrTextBk);
	WritePrivateProfileString(_T("RenamedItemDesign"),_T("BackColor"),szTmp,g_szPrivateProfile);

	//エラーのファイル
	WritePrivateProfileString(_T("FailedItemDesign"),_T("Font"),g_Config.FailedItemDesign.szFont,g_szPrivateProfile);
	WritePrivateProfileInt(_T("FailedItemDesign"),_T("FontStyle"),g_Config.FailedItemDesign.iFontStyle,g_szPrivateProfile);

	COLORREFToHex(szTmp,g_Config.FailedItemDesign.clrText);
	WritePrivateProfileString(_T("FailedItemDesign"),_T("TextColor"),szTmp,g_szPrivateProfile);

	COLORREFToHex(szTmp,g_Config.FailedItemDesign.clrTextBk);
	WritePrivateProfileString(_T("FailedItemDesign"),_T("BackColor"),szTmp,g_szPrivateProfile);


	//外部ビューアのパス
	WritePrivateProfileString(_T("Viewer"),_T("Path"),g_Config.szViewerPath,g_szPrivateProfile);


	//ショートカット
	WritePrivateProfileInt(_T("Shortcut"),_T("SendTo"),g_Config.Shortcut.bSendTo,g_szPrivateProfile);
	WritePrivateProfileInt(_T("Shortcut"),_T("Desktop"),g_Config.Shortcut.bDesktop,g_szPrivateProfile);
	WritePrivateProfileInt(_T("Shortcut"),_T("Options"),g_Config.Shortcut.iOptions,g_szPrivateProfile);


	//ログファイルの最大行数
	WritePrivateProfileInt(_T("Log"),_T("MaxLine"),g_Config.Log.iMaxLine,g_szPrivateProfile);


	//zip書庫のファイル名取得に7-zip32.dllを使用する
	WritePrivateProfileInt(_T("GetFileName"),_T("Use7zip32"),g_Config.bUse7zip32,g_szPrivateProfile);


	//リストに追加するファイルの重複を認める
	WritePrivateProfileInt(_T("Other"),_T("AllowDuplicate"),g_Config.bAllowDuplicate,g_szPrivateProfile);


	//終了時に確認する
	WritePrivateProfileInt(_T("Other"),_T("ConfirmExit"),g_Config.bConfirmExit,g_szPrivateProfile);


	//新しいファイル名のフォーマット
	WritePrivateProfileString(_T("Other"),_T("Format"),g_Config.szFormat,g_szPrivateProfile);
	return;
}

//PrivateProfileファイルから読み込む
void ReadPrivateProfile(void){
	//cfgファイルパス取得
	GetPrivateProfilePath();


	//ウインドウ状態
	g_Config.WindowState.bMaximized=static_cast<bool>(GetPrivateProfileInt(_T("WindowState"),_T("Maximized"),0,g_szPrivateProfile));
	g_Config.WindowState.sizeWindow.cx=static_cast<int>(GetPrivateProfileInt(_T("WindowState"),_T("Width"),DEFAULT_WIDTH,g_szPrivateProfile));
	g_Config.WindowState.sizeWindow.cy=static_cast<int>(GetPrivateProfileInt(_T("WindowState"),_T("Height"),DEFAULT_HEIGHT,g_szPrivateProfile));
	g_Config.WindowState.rcWindow.left=static_cast<int>(GetPrivateProfileInt(_T("WindowState"),_T("Left"),(GetSystemMetrics(SM_CXSCREEN)-g_Config.WindowState.sizeWindow.cx)>>1,g_szPrivateProfile));
	g_Config.WindowState.rcWindow.top=static_cast<int>(GetPrivateProfileInt(_T("WindowState"),_T("Top"),(GetSystemMetrics(SM_CYSCREEN)-g_Config.WindowState.sizeWindow.cy)>>1,g_szPrivateProfile));


	//リストビューカラム
	//並び順
	TCHAR szColumnOrder[12]={};

	GetPrivateProfileString(_T("ListViewColumn"),_T("Order"),_T("0123456"),szColumnOrder,ARRAY_SIZEOF(szColumnOrder),g_szPrivateProfile);

	//Orderが正しいが確認
	TCHAR* pszColumnOrder=szColumnOrder;
	TCHAR szCheck[7]={};//1234567の場合8に、2345678の場合9に[桁数+最小数値]
	int iCount=7;

	while(*(pszColumnOrder)){
		if((*(pszColumnOrder)<(LISTITEM_CURRENTFILENAME+_T('0')))||
		   (*(pszColumnOrder)>(LISTITEM_LASTMODIFIED+_T('0')))||
		   (szCheck[*(pszColumnOrder)-_T('0')]++)){
			break;
		}
		pszColumnOrder++;
		iCount--;
	}

	if(iCount||*pszColumnOrder){
		_tcscpy(szColumnOrder,_T("0123456"));
	}

	for(int i=0;i<LISTITEM_NUM;i++){
		g_Config.ListViewColumn.iOrder[i]=szColumnOrder[i]-_T('0');
	}

	//カラムの幅
	g_Config.ListViewColumn.iCurrentFileNameWidth=GetPrivateProfileInt(_T("ListViewColumn"),_T("CurrentFileNameWidth"),DEFAULT_CURRENTFILENAME_WIDTH,g_szPrivateProfile);
	g_Config.ListViewColumn.iNewFileNameWidth=GetPrivateProfileInt(_T("ListViewColumn"),_T("NewFileNameWidth"),DEFAULT_NEWFILENAME_WIDTH,g_szPrivateProfile);
	g_Config.ListViewColumn.iStatusWidth=GetPrivateProfileInt(_T("ListViewColumn"),_T("StatusWidth"),DEFAULT_STATUS_WIDTH,g_szPrivateProfile);
	g_Config.ListViewColumn.iDirectoryWidth=GetPrivateProfileInt(_T("ListViewColumn"),_T("DirectoryWidth"),0/*DEFAULT_DIRECTORY_WIDTH*/,g_szPrivateProfile);
	g_Config.ListViewColumn.iSizeWidth=GetPrivateProfileInt(_T("ListViewColumn"),_T("SizeWidth"),DEFAULT_SIZE_WIDTH,g_szPrivateProfile);
	g_Config.ListViewColumn.iTypeWidth=GetPrivateProfileInt(_T("ListViewColumn"),_T("TypeWidth"),0/*DEFAULT_TYPE_WIDTH*/,g_szPrivateProfile);
	g_Config.ListViewColumn.iLastModifiedWidth=GetPrivateProfileInt(_T("ListViewColumn"),_T("LastModifiedWidth"),DEFAULT_LASTMODIFIED_WIDTH,g_szPrivateProfile);

	//絶対値を取る
	g_Config.ListViewColumn.iCurrentFileNameWidth=abs(g_Config.ListViewColumn.iCurrentFileNameWidth);
	g_Config.ListViewColumn.iNewFileNameWidth=abs(g_Config.ListViewColumn.iNewFileNameWidth);
	g_Config.ListViewColumn.iStatusWidth=abs(g_Config.ListViewColumn.iStatusWidth);
	g_Config.ListViewColumn.iStatusWidth=abs(g_Config.ListViewColumn.iStatusWidth);
	g_Config.ListViewColumn.iDirectoryWidth=abs(g_Config.ListViewColumn.iDirectoryWidth);
	g_Config.ListViewColumn.iSizeWidth=abs(g_Config.ListViewColumn.iSizeWidth);
	g_Config.ListViewColumn.iTypeWidth=abs(g_Config.ListViewColumn.iTypeWidth);

	//現在のファイル名の幅は0以下であってはいけない
	if(!g_Config.ListViewColumn.iCurrentFileNameWidth)g_Config.ListViewColumn.iCurrentFileNameWidth=DEFAULT_CURRENTFILENAME_WIDTH;


	//対象書庫ファイル
	g_Config.EnableFileType.bZip=static_cast<bool>(GetPrivateProfileInt(_T("EnableFileType"),_T("Zip"),1,g_szPrivateProfile));
	g_Config.EnableFileType.b7z=static_cast<bool>(GetPrivateProfileInt(_T("EnableFileType"),_T("7z"),1,g_szPrivateProfile));
	g_Config.EnableFileType.bCab=static_cast<bool>(GetPrivateProfileInt(_T("EnableFileType"),_T("Cab"),0,g_szPrivateProfile));
	g_Config.EnableFileType.bLzh=static_cast<bool>(GetPrivateProfileInt(_T("EnableFileType"),_T("Lzh"),0,g_szPrivateProfile));
	g_Config.EnableFileType.bRar=static_cast<bool>(GetPrivateProfileInt(_T("EnableFileType"),_T("Rar"),1,g_szPrivateProfile));


	//サムネイルサイズ
	g_Config.Thumbnail.iSmall=GetPrivateProfileInt(_T("Thumbnail"),_T("SmallSize"),DEFAULT_SMALLTHUMB_SIZE,g_szPrivateProfile);
	g_Config.Thumbnail.iNormal=GetPrivateProfileInt(_T("Thumbnail"),_T("NormalSize"),DEFAULT_NORMALTHUMB_SIZE,g_szPrivateProfile);
	g_Config.Thumbnail.iLarge=GetPrivateProfileInt(_T("Thumbnail"),_T("LargeSize"),DEFAULT_LARGETHUMB_SIZE,g_szPrivateProfile);

	//サムネイルサイズを範囲内に収める
	g_Config.Thumbnail.iSmall=(INRANGE(MINIMUM_THUMB_SIZE,g_Config.Thumbnail.iSmall,MAXIMUM_THUMB_SIZE))?g_Config.Thumbnail.iSmall:DEFAULT_SMALLTHUMB_SIZE;
	g_Config.Thumbnail.iNormal=(INRANGE(MINIMUM_THUMB_SIZE,g_Config.Thumbnail.iNormal,MAXIMUM_THUMB_SIZE))?g_Config.Thumbnail.iNormal:DEFAULT_NORMALTHUMB_SIZE;
	g_Config.Thumbnail.iLarge=(INRANGE(MINIMUM_THUMB_SIZE,g_Config.Thumbnail.iLarge,MAXIMUM_THUMB_SIZE))?g_Config.Thumbnail.iLarge:DEFAULT_LARGETHUMB_SIZE;

	//サムネイルの間隔
	g_Config.Thumbnail.iSpacingX=GetPrivateProfileInt(_T("Thumbnail"),_T("SpacingX"),DEFAULT_THUMBSPACING_X,g_szPrivateProfile);
	g_Config.Thumbnail.iSpacingY=GetPrivateProfileInt(_T("Thumbnail"),_T("SpacingY"),DEFAULT_THUMBSPACING_Y,g_szPrivateProfile);

	//サムネイルの間隔を範囲内の収める
	g_Config.Thumbnail.iSpacingX=(INRANGE(MINIMUM_THUMBSPACING,g_Config.Thumbnail.iSpacingX,MAXIMUM_THUMBSPACING))?g_Config.Thumbnail.iSpacingX:DEFAULT_THUMBSPACING_X;
	g_Config.Thumbnail.iSpacingY=(INRANGE(MINIMUM_THUMBSPACING,g_Config.Thumbnail.iSpacingY,MAXIMUM_THUMBSPACING))?g_Config.Thumbnail.iSpacingY:DEFAULT_THUMBSPACING_Y;

	//起動時のサムネイル
	g_Config.Thumbnail.iStartup=GetPrivateProfileInt(_T("Thumbnail"),_T("Startup"),STARTUP_NORMAL_THUMBNAIL,g_szPrivateProfile);

	g_Config.Thumbnail.iStartup=(INRANGE(STARTUP_NO_THUMBNAIL,g_Config.Thumbnail.iStartup,STARTUP_LASTTIME+STARTUP_LARGE_THUMBNAIL))?g_Config.Thumbnail.iStartup:STARTUP_NORMAL_THUMBNAIL;
	if(g_Config.Thumbnail.iStartup==4)g_Config.Thumbnail.iStartup=STARTUP_NORMAL_THUMBNAIL;

	//サムネイルに先頭のファイルを採用する
	g_Config.Thumbnail.bFirstFile=static_cast<bool>(GetPrivateProfileInt(_T("Thumbnail"),_T("FirstFile"),1,g_szPrivateProfile));

	//サムネイルの補間モード
	g_Config.Thumbnail.iInterpolationMode=GetPrivateProfileInt(_T("Thumbnail"),_T("InterpolationMode"),Gdiplus::InterpolationModeLowQuality,g_szPrivateProfile);


	//リストビューアイテムのデザイン
	TCHAR szTmp[12]={};

	//デフォルト(未処理ファイル)
	GetPrivateProfileString(_T("DefaultItemDesign"),_T("Font"),NULL,g_Config.DefaultItemDesign.szFont,ARRAY_SIZEOF(g_Config.DefaultItemDesign.szFont),g_szPrivateProfile);
	//リストビューの仕様上、iFontSizeはDefaultItemDesignでのみ有効にすること
	g_Config.DefaultItemDesign.iFontSize=GetPrivateProfileInt(_T("DefaultItemDesign"),_T("FontSize"),0,g_szPrivateProfile);
	g_Config.DefaultItemDesign.iFontStyle=GetPrivateProfileInt(_T("DefaultItemDesign"),_T("FontStyle"),0,g_szPrivateProfile);

	GetPrivateProfileString(_T("DefaultItemDesign"),_T("TextColor"),_T("#000000"),szTmp,ARRAY_SIZEOF(szTmp),g_szPrivateProfile);
	g_Config.DefaultItemDesign.clrText=StringToCOLORREF(szTmp);

	GetPrivateProfileString(_T("DefaultItemDesign"),_T("BackColor"),_T("#FFFFFF"),szTmp,ARRAY_SIZEOF(szTmp),g_szPrivateProfile);
	g_Config.DefaultItemDesign.clrTextBk=StringToCOLORREF(szTmp);

	//リストビューの仕様上、clrOutlineはDefaultItemDesignでのみ有効にすること
	GetPrivateProfileString(_T("DefaultItemDesign"),_T("OutlineColor"),_T("#EFEFF3"),szTmp,ARRAY_SIZEOF(szTmp),g_szPrivateProfile);
	g_Config.DefaultItemDesign.clrOutline=StringToCOLORREF(szTmp);

	//フォントサイズを範囲内に収める
	//範囲外であればMINIMUM_THUMB_SIZE(==0、フォントサイズ変更なし)
	g_Config.DefaultItemDesign.iFontSize=(INRANGE(MINIMUM_FONT_SIZE,g_Config.DefaultItemDesign.iFontSize,MAXIMUM_FONT_SIZE))?g_Config.DefaultItemDesign.iFontSize:MINIMUM_FONT_SIZE;

	//リネームできるファイル
	GetPrivateProfileString(_T("ReadyItemDesign"),_T("Font"),NULL,g_Config.ReadyItemDesign.szFont,ARRAY_SIZEOF(g_Config.ReadyItemDesign.szFont),g_szPrivateProfile);
	g_Config.ReadyItemDesign.iFontStyle=GetPrivateProfileInt(_T("ReadyItemDesign"),_T("FontStyle"),0,g_szPrivateProfile);

	GetPrivateProfileString(_T("ReadyItemDesign"),_T("TextColor"),_T("#000000"),szTmp,ARRAY_SIZEOF(szTmp),g_szPrivateProfile);
	g_Config.ReadyItemDesign.clrText=StringToCOLORREF(szTmp);

	GetPrivateProfileString(_T("ReadyItemDesign"),_T("BackColor"),_T("#CBCBFF"),szTmp,ARRAY_SIZEOF(szTmp),g_szPrivateProfile);
	g_Config.ReadyItemDesign.clrTextBk=StringToCOLORREF(szTmp);

	//リネームしたファイル
	GetPrivateProfileString(_T("RenamedItemDesign"),_T("Font"),NULL,g_Config.RenamedItemDesign.szFont,ARRAY_SIZEOF(g_Config.RenamedItemDesign.szFont),g_szPrivateProfile);
	g_Config.RenamedItemDesign.iFontStyle=GetPrivateProfileInt(_T("RenamedItemDesign"),_T("FontStyle"),0,g_szPrivateProfile);

	GetPrivateProfileString(_T("RenamedItemDesign"),_T("TextColor"),_T("#000000"),szTmp,ARRAY_SIZEOF(szTmp),g_szPrivateProfile);
	g_Config.RenamedItemDesign.clrText=StringToCOLORREF(szTmp);

	GetPrivateProfileString(_T("RenamedItemDesign"),_T("BackColor"),_T("#CBFFCB"),szTmp,ARRAY_SIZEOF(szTmp),g_szPrivateProfile);
	g_Config.RenamedItemDesign.clrTextBk=StringToCOLORREF(szTmp);

	//エラーのファイル
	GetPrivateProfileString(_T("FailedItemDesign"),_T("Font"),NULL,g_Config.FailedItemDesign.szFont,ARRAY_SIZEOF(g_Config.FailedItemDesign.szFont),g_szPrivateProfile);
	g_Config.FailedItemDesign.iFontStyle=GetPrivateProfileInt(_T("FailedItemDesign"),_T("FontStyle"),0,g_szPrivateProfile);

	GetPrivateProfileString(_T("FailedItemDesign"),_T("TextColor"),_T("#000000"),szTmp,ARRAY_SIZEOF(szTmp),g_szPrivateProfile);
	g_Config.FailedItemDesign.clrText=StringToCOLORREF(szTmp);

	GetPrivateProfileString(_T("FailedItemDesign"),_T("BackColor"),_T("#FFCBCB"),szTmp,ARRAY_SIZEOF(szTmp),g_szPrivateProfile);
	g_Config.FailedItemDesign.clrTextBk=StringToCOLORREF(szTmp);


	//外部ビューアのパス
	GetPrivateProfileString(_T("Viewer"),_T("Path"),NULL,g_Config.szViewerPath,ARRAY_SIZEOF(g_Config.szViewerPath),g_szPrivateProfile);


	//ショートカット
	g_Config.Shortcut.bSendTo=static_cast<bool>(GetPrivateProfileInt(_T("Shortcut"),_T("SendTo"),0,g_szPrivateProfile));
	g_Config.Shortcut.bDesktop=static_cast<bool>(GetPrivateProfileInt(_T("Shortcut"),_T("Desktop"),0,g_szPrivateProfile));
	g_Config.Shortcut.iOptions=GetPrivateProfileInt(_T("Shortcut"),_T("Options"),0,g_szPrivateProfile);


	//ログファイルの最大行数
	g_Config.Log.iMaxLine=GetPrivateProfileInt(_T("Log"),_T("MaxLine"),0,g_szPrivateProfile);


	//zip書庫のファイル名取得に7-zip32.dllを使用する
	g_Config.bUse7zip32=static_cast<bool>(GetPrivateProfileInt(_T("GetFileName"),_T("Use7zip32"),1,g_szPrivateProfile));


	//最大行数の最小値を-1(bNoLog)にする。
	if(g_Config.Log.iMaxLine<0)g_Config.Log.iMaxLine=-1;


	//リストに追加するファイルの重複を認める
	g_Config.bAllowDuplicate=static_cast<bool>(GetPrivateProfileInt(_T("Other"),_T("AllowDuplicate"),0,g_szPrivateProfile));


	//終了時に確認する
	g_Config.bConfirmExit=static_cast<bool>(GetPrivateProfileInt(_T("Other"),_T("ConfirmExit"),1,g_szPrivateProfile));


	//新しいファイル名のフォーマット
	GetPrivateProfileString(_T("Other"),_T("Format"),_T("%new"),g_Config.szFormat,ARRAY_SIZEOF(g_Config.szFormat),g_szPrivateProfile);
	if(lstrlen(g_Config.szFormat)<=0)_tcscpy(g_Config.szFormat,_T("%new"));
	return;
}
