﻿//Thumbnail.cpp
//書庫ファイル内の画像のサムネイルをHBITMAPで取得

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Ashley Ver.1.39
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Ashleyは、アップローダからダウンロードしたZIPやRAR等のファイル名を元に戻すソフトです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"Thumbnail.h"
#include"CommonSettings.h"
#include"UnZipFile.h"
#include"UnRarFile.h"
#include"ArcDll.h"
#include"Path.h"
#include"Function.h"
#include"resources/resource.h"
#include<olectl.h>
#include<shlwapi.h>
#include<gdiplus.h>

//サムネイル最大バッファ(128MB)
#define THUMBNAIL_MAX_BUFFERSIZE 1048576*128

using namespace std;

TCHAR* ToLower(TCHAR*s){
	for(TCHAR*p=s;*p;p++)
		*p=tolower(*p);
	return s;
}

//対応している画像の拡張子かどうか
bool IsSupportedImage(const TCHAR* pszPath){
	TCHAR szExtension[_MAX_EXT]={};
	const TCHAR szExtensionList[]=_T(".bmp.gif.ico.jpe.jpeg.jpg.jif.jfi.jfif.png.tif.tiff.");

	_tcscpy(szExtension,PathFindExtension(pszPath));
	_tcscat(szExtension,_T("."));
	return _tcsstr(szExtensionList,ToLower(szExtension))!=NULL;
}

//16x16のダミーアイコンを描写したHBITMAPを作成
HBITMAP CreateDummyBitmap(int iWidth,int iHeight){
	HICON hIcon=NULL;

	hIcon=static_cast<HICON>(LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICON_DUMMY),IMAGE_ICON,0,0,0));
	HDC hDC=GetDC(NULL);
	HDC hWorkDC=CreateCompatibleDC(hDC);

	HBITMAP hBitmap=CreateCompatibleBitmap(hDC,iWidth,iHeight);
	HBITMAP hOldBitmap=(HBITMAP)SelectObject(hWorkDC,hBitmap);
	DrawIcon(hWorkDC,0,0,hIcon);
	SelectObject(hWorkDC,hOldBitmap);
	DeleteDC(hWorkDC);
	DestroyIcon(hIcon);
	ReleaseDC(NULL,hDC);
	return hBitmap;
}

//16x16のダミーアイコンを描写したHBITMAPを作成
HBITMAP CreateDummyBitmap2(HDC hdc, int iWidth,int iHeight){
	HICON hIcon=NULL;

	hIcon=static_cast<HICON>(LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICON_DUMMY),IMAGE_ICON,0,0,0));
	HDC hWorkDC=CreateCompatibleDC(hdc);

	HBITMAP hBitmap=CreateCompatibleBitmap(hdc,iWidth,iHeight);
	HBITMAP hOldBitmap=(HBITMAP)SelectObject(hWorkDC,hBitmap);
	DrawIcon(hWorkDC,0,0,hIcon);
	SelectObject(hWorkDC,hOldBitmap);
	DeleteDC(hWorkDC);
	DestroyIcon(hIcon);
	return hBitmap;
}

//ファイルパスからアイコンを取得しBitmapに変換
HBITMAP CreateBitmapFromPath(LPCTSTR lpszPath,int iWidth,int iHeight){
	SHFILEINFO shFileInfo;
	HICON hIcon=NULL;
	HIMAGELIST hImageList=NULL;

	hImageList=(HIMAGELIST)SHGetFileInfo(lpszPath,0,&shFileInfo,sizeof(shFileInfo),SHGFI_ICON|SHGFI_LARGEICON|SHGFI_USEFILEATTRIBUTES|SHGFI_SYSICONINDEX);
	hIcon=ImageList_GetIcon(hImageList,shFileInfo.iIcon,ILD_NORMAL);//ILD_IMAGE
	ICONINFO IconInfo;
	IconInfo.fIcon=true;//アイコンである
	GetIconInfo(hIcon,&IconInfo);
	BITMAP Bitmap;
	GetObject(IconInfo.hbmColor,sizeof(Bitmap),&Bitmap);
	HDC hDC=GetDC(NULL);
	HDC hWorkDC=CreateCompatibleDC(hDC);
	SetStretchBltMode(hWorkDC,HALFTONE);
	//After setting the HALFTONE stretching mode, an application must call the SetBrushOrgEx function to set the brush origin. If it fails to do so, brush misalignment occurs.
	//(http://msdn.microsoft.com/en-us/library/dd145089(v=vs.85).aspx)
	SetBrushOrgEx(hWorkDC,0,0,NULL);
	HBITMAP hBitmap=CreateCompatibleBitmap(hDC,iWidth,iHeight);
	HBITMAP hOldBitmap=(HBITMAP)SelectObject(hWorkDC,hBitmap);
	POINT pt={(iWidth-Bitmap.bmWidth)>>1,(iHeight-Bitmap.bmHeight)>>1};//中央表示座標
	DrawIcon(hWorkDC,pt.x,pt.y,hIcon);
	SelectObject(hWorkDC,hOldBitmap);
	DeleteDC(hWorkDC);
	DestroyIcon(shFileInfo.hIcon);
	DestroyIcon(hIcon);
	ReleaseDC(NULL,hDC);
	return hBitmap;
}

//IStreamからHBITMAPを取得
HBITMAP CreateBitmapFromIStream(IStream* pIStream,const LPSIZE psizeThumbnail){
	Gdiplus::Bitmap* pBitmap=Gdiplus::Bitmap::FromStream(pIStream);
	if(pBitmap==NULL)return NULL;
	if(pBitmap->GetLastStatus()!=Gdiplus::Ok)return NULL;
	if(pBitmap->GetWidth()<=0||pBitmap->GetHeight()<=0)return NULL;

	int iSrcWidth=0,iSrcHeight=0;
	int iDestWidth=0,iDestHeight=0;
	iSrcWidth=pBitmap->GetWidth();
	iSrcHeight=pBitmap->GetHeight();

	if(psizeThumbnail->cx<iSrcWidth||psizeThumbnail->cy<iSrcHeight){
		//サムネイルのキャンバスサイズより大きい
		float rX=(float)psizeThumbnail->cx/iSrcWidth;
		float rY=(float)psizeThumbnail->cy/iSrcHeight;
		iDestWidth=(int)(min(rX,rY)*iSrcWidth);//縮小後のサイズ
		iDestHeight=(int)(min(rX,rY)*iSrcHeight);
	}else{
		//サムネイルのキャンバスサイズより小さい
		iDestWidth=iSrcWidth;
		iDestHeight=iSrcHeight;
	}

	HDC hdcScreen=GetDC(NULL);
	HBITMAP hbmpResult=CreateCompatibleBitmap(hdcScreen,psizeThumbnail->cx,psizeThumbnail->cy);
	HDC hdcMemory=CreateCompatibleDC(hdcScreen);
	SetBkMode(hdcMemory,TRANSPARENT);
	ReleaseDC(NULL,hdcScreen);
	HGDIOBJ hobjOld=SelectObject(hdcMemory,hbmpResult);

	const POINT ptDest={(psizeThumbnail->cx-iDestWidth)>>1,(psizeThumbnail->cy-iDestHeight)>>1};//中央表示座標

#if 1

	Gdiplus::Graphics* pGraphics=Gdiplus::Graphics::FromHDC(hdcMemory);

	//補間モードを設定
	pGraphics->SetInterpolationMode((Gdiplus::InterpolationMode)g_Config.Thumbnail.iInterpolationMode);

	pGraphics->DrawImage(pBitmap,ptDest.x,ptDest.y,iDestWidth,iDestHeight);

	delete pGraphics;

#else

	//TODO:7環境でCOLORONCOLORであれば必要なし
	//HALFTONEの場合、有効にすると真っ白け
/*	HICON hIcon=static_cast<HICON>(LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICON_DUMMY),IMAGE_ICON,0,0,LR_SHARED));
	DrawIcon(hdcMemory,0,0,hIcon);
	DestroyIcon(hIcon);
*/
	SetStretchBltMode(hdcMemory,HALFTONE);//COLORONCOLOR);

	Gdiplus::BitmapData bitmapData;
	pBitmap->LockBits(NULL,Gdiplus::ImageLockModeRead,PixelFormat32bppARGB,&bitmapData);

	BITMAPINFOHEADER BitmapInfoHeader;
	memset(&BitmapInfoHeader,0,sizeof(BITMAPINFOHEADER));
	BitmapInfoHeader.biSize=sizeof(BITMAPINFOHEADER);
	BitmapInfoHeader.biWidth=bitmapData.Width;
	BitmapInfoHeader.biHeight=bitmapData.Height;
	BitmapInfoHeader.biPlanes=1;
	BitmapInfoHeader.biBitCount=32;
	BitmapInfoHeader.biCompression=BI_RGB;
	BitmapInfoHeader.biClrUsed=0;
	BitmapInfoHeader.biClrImportant=0;

	StretchDIBits(hdcMemory,
				  ptDest.x,ptDest.y+iDestHeight,iDestWidth,-iDestHeight,
				  0, 0,BitmapInfoHeader.biWidth,BitmapInfoHeader.biHeight,
				  bitmapData.Scan0,(BITMAPINFO*)&BitmapInfoHeader,
				  DIB_RGB_COLORS,SRCCOPY);

	pBitmap->UnlockBits(&bitmapData);

#endif

	SelectObject(hdcMemory,hobjOld);
	DeleteDC(hdcMemory);
	return hbmpResult;
}

HBITMAP CreateBitmapFromMemory(LPCVOID lpcBuffer,const ULONG ulBufferSize,const LPSIZE psizeThumbnail){
	HBITMAP hRetBitmap=NULL;
	HANDLE hBuffer=NULL;
	LPVOID lpBuffer=NULL;
	IStream* pIStream=NULL;

	//lpBuffer=(LPVOID)GlobalAlloc(GMEM_MOVEABLE|GMEM_ZEROINIT,ulBufferSize);
	hBuffer=GlobalAlloc(GMEM_MOVEABLE|GMEM_ZEROINIT,ulBufferSize);
	if(hBuffer){
		lpBuffer=GlobalLock(hBuffer);
		if(lpBuffer){
			CopyMemory(lpBuffer,lpcBuffer,ulBufferSize);
			if(CreateStreamOnHGlobal(hBuffer,false,&pIStream)==S_OK){
				hRetBitmap=CreateBitmapFromIStream(pIStream,psizeThumbnail);//IStreamからHBITMAP取得
				pIStream->Release();
			}
		}
	}
	GlobalUnlock(hBuffer);
	GlobalFree(hBuffer);//解放
	hBuffer=NULL;
	return hRetBitmap;
}

//zipファイル内の画像のサムネイルをHBITMAPで取得
HBITMAP GetThumbnailBitmapFromZipFile(const TCHAR* pszFilePath,const int iWidth,const int iHeight){
	bool bSuccess=false;
	int iCount=0;//格納ファイル数
	int iThumbIndex=-1;//サムネイルとして利用する画像のIndex
	HBITMAP hRetBitmap=NULL;
	LPBYTE lpBuffer=NULL;
	SIZE sizeThumbnail;
	CUnZip UnZip;

	if(!UnZip.OpenFile(pszFilePath))return NULL;//書庫ファイルを開くことが出来ない
	iCount=UnZip.GetFileCount();
	if(iCount==0)return NULL;//書庫内にファイルがない
	tstring strFileName;
	for(int i=0;i<iCount;i++){
		if(!UnZip.GetFileInfo(i))break;//書庫ファイル内の情報を取得出来ない
		if(UnZip.IsDirectory())continue;//ディレクトリである
		if(UnZip.GetUncompressedSize()>THUMBNAIL_MAX_BUFFERSIZE)continue;//サムネイル最大バッファより大きい
		if(UnZip.GetUncompressedSize()==0)continue;//ファイルサイズが0
		if(IsSupportedImage(UnZip.GetFileName())){//対応している画像ファイルである
			if(iThumbIndex<0)iThumbIndex=i;
			if(strFileName.empty())strFileName=UnZip.GetFileName();
			if(_StrCmpLogicalW(UnZip.GetFileName(),(PCWSTR)strFileName.c_str())==-1){//GetZipFileItemName()<strFileName
				iThumbIndex=i;
				strFileName=UnZip.GetFileName();
			}
			if(g_Config.Thumbnail.bFirstFile)break;
		}
	}
	if(iThumbIndex<0)return NULL;
	if(!UnZip.GetFileInfo(iThumbIndex))return NULL;//書庫ファイル内の情報を取得出来ない
	lpBuffer=(LPBYTE)HeapAlloc(GetProcessHeap(),0,UnZip.GetUncompressedSize()*sizeof(BYTE));//ファイルのバッファ確保
	if(lpBuffer){
		ZeroMemory(lpBuffer,UnZip.GetUncompressedSize()*sizeof(BYTE));
		if(!UnZip.ExtractMem(iThumbIndex,lpBuffer,UnZip.GetUncompressedSize()))return NULL;
		//サムネイルサイズ設定
		sizeThumbnail.cx=iWidth;
		sizeThumbnail.cy=iHeight;
		//HBITMAP取得
		hRetBitmap=CreateBitmapFromMemory(lpBuffer,UnZip.GetUncompressedSize(),&sizeThumbnail);
		bSuccess=hRetBitmap!=NULL;
		HeapFree(GetProcessHeap(),0,lpBuffer);
		lpBuffer=NULL;
	}
	return (bSuccess)?hRetBitmap:NULL;
}

//rarファイル内の画像のサムネイルをHBITMAPで取得
HBITMAP GetThumbnailBitmapFromRarFile(const TCHAR* pszFilePath,const int iWidth,const int iHeight){
	HBITMAP hRetBitmap=NULL;
	SIZE sizeThumbnail;
	IStream* pIStream=NULL;
	CUnRar UnRar;

	if(!UnRar.CheckReady())return NULL;//DLLは使用可能な状況ではない

	if(!UnRar.OpenFile(pszFilePath))return NULL;//書庫ファイルを開くことが出来ない
	//ソリッド、マルチボリューム、ヘッダ暗号化書庫は無視する
	if(UnRar.IsArchiveSolid()||UnRar.IsArchiveVolume()||UnRar.IsArchiveEncryptedHeaders())return NULL;
	UINT64 iPackedSize,iUnpackedSize;
	__int64 iThumbIndex=-1;
	tstring strFileName;
	for(__int64 i=0;UnRar.ReadFileInfo();++i){
		iPackedSize=UnRar.GetFilePackedSize64();
		iUnpackedSize=UnRar.GetFileUnpackedSize64();
		if(UnRar.IsDirectory()||iUnpackedSize>THUMBNAIL_MAX_BUFFERSIZE||iPackedSize==0||iUnpackedSize==0){
			UnRar.SkipFile();
			continue;
		}
		if(IsSupportedImage(UnRar.GetFileName())){
			if(iThumbIndex<0)iThumbIndex=i;
			if(strFileName.empty())strFileName=UnRar.GetFileName();
			if(_StrCmpLogicalW(UnRar.GetFileName(),(PCWSTR)strFileName.c_str())==-1){//GetFileName()<strFileName
				iThumbIndex=i;
				strFileName=UnRar.GetFileName();
			}
			if(g_Config.Thumbnail.bFirstFile)break;
		}
		UnRar.SkipFile();
	}

	if(iThumbIndex<0)return NULL;

	//再度開く
	UnRar.CloseFile();
	if(!UnRar.CheckReady())return NULL;//DLLは使用可能な状況ではない
	if(!UnRar.OpenFile(pszFilePath,false))return NULL;//書庫ファイルを開くことが出来ない
	if(!UnRar.SkipFiles(iThumbIndex))return NULL;
	//ファイルの情報を読み込む
	if(!UnRar.ReadFileInfo())return NULL;

	//サムネイルサイズ設定
	sizeThumbnail.cx=iWidth;
	sizeThumbnail.cy=iHeight;
	HGLOBAL hGlobal=GlobalAlloc(GMEM_MOVEABLE|GMEM_ZEROINIT,(SIZE_T)UnRar.GetFileUnpackedSize64());
	if(hGlobal){
		if(CreateStreamOnHGlobal(hGlobal,TRUE,(LPSTREAM*)&pIStream)==S_OK){
			UnRar.SetIStream(pIStream);
			//HBITMAP取得
			if(UnRar.ProcessFile())hRetBitmap=CreateBitmapFromIStream(pIStream,&sizeThumbnail);
		}
	}
	GlobalFree(hGlobal);
	pIStream->Release();
	return (hRetBitmap!=NULL)?hRetBitmap:NULL;
}

//lzhファイル内の画像のサムネイルをHBITMAPで取得
HBITMAP GetThumbnailBitmapFromLHAFile(const TCHAR* pszFilePath,const int iWidth,const int iHeight){
	LONGLONG llOriginalSize=0,llCompressedSize=0,llTargetOriginalSize=0;
	TCHAR szRetPath[MAX_PATH]={};
	HBITMAP hRetBitmap=NULL;
	TCHAR* pszCmdLine=NULL;//DLLに渡すコマンド
	LPBYTE lpBuffer=NULL;
	SIZE sizeThumbnail;
	CArcDll ArcDll;

	if(!ArcDll.LoadDll(_T("UNLHA32.DLL"),_T("Unlha")))return NULL;//DLLを読み込むことが出来ない
	if(ArcDll.GetRunning())return NULL;//DLLは動作中である
	ArcDll.SetCursorMode(false);//DLL独自のカーソルを表示しない
	if(!ArcDll.CheckArchive(pszFilePath,1))return NULL;//正しい書庫ファイルではない
	if(ArcDll.OpenArchive(NULL,pszFilePath,0)==NULL)return NULL;//書庫ファイルを開くことが出来ない

	if(ArcDll.FindFirst(_T("*.*"),NULL)==-1)return NULL;//書庫ファイル内の情報を取得出来ない
	bool bSuccess=false;
	tstring strFileName;
	do{
		if(ArcDll.GetFileName(szRetPath,MAX_PATH)!=0){
			continue;//書庫ファイル内のファイル名を取得出来ない
		}

		if(ArcDll.IsDirectory())continue;//ディレクトリである
		ArcDll.GetOriginalSizeEx(&llOriginalSize);
		ArcDll.GetCompressedSizeEx(&llCompressedSize);
		if(llOriginalSize>THUMBNAIL_MAX_BUFFERSIZE)continue;//サムネイル最大バッファより大きい
		if(llOriginalSize==0)continue;//ファイルサイズが0
		if(IsSupportedImage(szRetPath)){//対応している画像ファイルである
			if(strFileName.empty()){
				strFileName=szRetPath;
				llTargetOriginalSize=llOriginalSize;
			}else if(_StrCmpLogicalW(szRetPath,(PCWSTR)strFileName.c_str())==-1){//szRetPath<strFileName
				strFileName=szRetPath;
				llTargetOriginalSize=llOriginalSize;
			}
			bSuccess=true;
			if(g_Config.Thumbnail.bFirstFile)break;
		}
	}while(ArcDll.FindNext(NULL)!=-1);//検索終了まで回す

	if(!bSuccess)return NULL;//対応している画像が格納されていなかった

	ArcDll.CloseArchive();

	//n(展開状況ダイアログ表示の抑止)
	//gm(エラーメッセージ表示の抑止)
	const TCHAR* szOptions=_T("-n -gm");
	pszCmdLine=(TCHAR*)malloc((lstrlen(szOptions)+lstrlen(pszFilePath)+strFileName.length()+12)*sizeof(TCHAR));
	wsprintf(pszCmdLine,_T("%s \"%s\" \"%s\""),szOptions,pszFilePath,strFileName.c_str());
	lpBuffer=(LPBYTE)malloc(llTargetOriginalSize*sizeof(BYTE));
	if(lpBuffer){
		if(ArcDll.ExtractMem(NULL,pszCmdLine,lpBuffer,llTargetOriginalSize,NULL,NULL,NULL)==0){
			//サムネイルサイズ設定
			sizeThumbnail.cx=iWidth;
			sizeThumbnail.cy=iHeight;
			//HBITMAP取得
			hRetBitmap=CreateBitmapFromMemory(lpBuffer,llTargetOriginalSize,&sizeThumbnail);
		}
		free(lpBuffer);
		lpBuffer=NULL;
	}
	free(pszCmdLine);
	pszCmdLine=NULL;
	return hRetBitmap;
}

//7zファイル内の画像のサムネイルをHBITMAPで取得
HBITMAP GetThumbnailBitmapFrom7ZFile(const TCHAR* pszFilePath,const int iWidth,const int iHeight){
	LONGLONG llOriginalSize=0,llTargetOriginalSize=0;
	TCHAR szRetPath[MAX_PATH]={};
	HBITMAP hRetBitmap=NULL;
	TCHAR* pszCmdLine=NULL;//DLLに渡すコマンド
	LPBYTE lpBuffer=NULL;
	SIZE sizeThumbnail;
	CArcDll ArcDll;

	if(!ArcDll.LoadDll(_T("7-zip32.dll"),_T("SevenZip")))return NULL;//DLLを読み込むことが出来ない
	if(ArcDll.GetRunning())return NULL;//DLLは動作中である
	ArcDll.SetCursorMode(false);//DLL独自のカーソルを表示しない
	if(!ArcDll.CheckArchive(pszFilePath,1))return NULL;//正しい書庫ファイルではない
	if(ArcDll.OpenArchive(NULL,pszFilePath,0)==NULL)return NULL;//書庫ファイルを開くことが出来ない

	if(ArcDll.FindFirst(_T("*.*"),NULL)==-1)return NULL;//書庫ファイル内の情報を取得出来ない
	bool bSuccess=false;
	tstring strFileName;
	do{
		if(ArcDll.GetFileName(szRetPath,MAX_PATH)!=0){
			continue;//書庫ファイル内のファイル名を取得出来ない
		}

		if(ArcDll.IsDirectory())continue;//ディレクトリである
		ArcDll.GetOriginalSizeEx(&llOriginalSize);
		if(llOriginalSize>THUMBNAIL_MAX_BUFFERSIZE)continue;//サムネイル最大バッファより大きい
		if(llOriginalSize==0)continue;//ファイルサイズが0
		if(IsSupportedImage(szRetPath)){//対応している画像ファイルである
			if(strFileName.empty()){
				strFileName=szRetPath;
				llTargetOriginalSize=llOriginalSize;
			}else if(_StrCmpLogicalW(szRetPath,(PCWSTR)strFileName.c_str())==-1){//szRetPath<strFileName
				strFileName=szRetPath;
				llTargetOriginalSize=llOriginalSize;
			}
			bSuccess=true;
			if(g_Config.Thumbnail.bFirstFile)break;
		}
	}while(ArcDll.FindNext(NULL)!=-1);//検索終了まで回す

	if(!bSuccess)return NULL;//対応している画像が格納されていなかった

	ArcDll.CloseArchive();

	//hide(処理状況ダイアログ表示の抑止)
	//y(全ての質問に yes を仮定)
	const TCHAR* szOptions=_T("x -hide -y");
	pszCmdLine=(TCHAR*)malloc((lstrlen(szOptions)+lstrlen(pszFilePath)+strFileName.length()+12)*sizeof(TCHAR));
	wsprintf(pszCmdLine,_T("%s \"%s\" \"%s\""),szOptions,pszFilePath,strFileName.c_str());
	lpBuffer=(LPBYTE)malloc(llTargetOriginalSize*sizeof(BYTE));

	if(lpBuffer){
		if(ArcDll.ExtractMem(NULL,pszCmdLine,lpBuffer,llTargetOriginalSize,NULL,NULL,NULL)==0){
			//サムネイルサイズ設定
			sizeThumbnail.cx=iWidth;
			sizeThumbnail.cy=iHeight;
			//HBITMAP取得
			hRetBitmap=CreateBitmapFromMemory(lpBuffer,llTargetOriginalSize,&sizeThumbnail);
		}
		free(lpBuffer);
		lpBuffer=NULL;
	}
	free(pszCmdLine);
	pszCmdLine=NULL;
	return hRetBitmap;
}

HBITMAP GetThumbnailBitmapFromArchiveFile(const TCHAR* pszFilePath,const int iWidth,const int iHeight){
	LPTSTR lpszExtension=NULL;
	HBITMAP hBitmap=NULL;

	lpszExtension=PathFindExtension(pszFilePath);
	if(_tcsicmp(lpszExtension,_T(".zip"))==0){
		hBitmap=GetThumbnailBitmapFromZipFile(pszFilePath,iWidth,iHeight);
	}else if(_tcsicmp(lpszExtension,_T(".rar"))==0){
		hBitmap=GetThumbnailBitmapFromRarFile(pszFilePath,iWidth,iHeight);
	}else if(_tcsicmp(lpszExtension,_T(".lzh"))==0){
		hBitmap=GetThumbnailBitmapFromLHAFile(pszFilePath,iWidth,iHeight);
	}else if(_tcsicmp(lpszExtension,_T(".7z"))==0){
		hBitmap=GetThumbnailBitmapFrom7ZFile(pszFilePath,iWidth,iHeight);
	}
	return hBitmap;
}
