﻿//Function.cpp
//様々な便利関数

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Nelumbo Ver.1.72
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Nelumboはクリックひとつでパスワード「*****」を表示&コピーするソフトウェアです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"StdAfx.h"
#include"Function.h"


//現在のカーソルの位置からコントロールのハンドルを取得
HWND ControlFromPoint(){
	POINT pt;

	GetCursorPos(&pt);
	HWND hResult=WindowFromPoint(pt);

	if(hResult!=NULL){
		POINT ptClient=pt;

		ScreenToClient(hResult,&ptClient);
		{
			HWND hChild=ChildWindowFromPoint(hResult,ptClient);
			if(hChild!=NULL&&IsWindowVisible(hChild)){
				hResult=hChild;
			}
		}
	}

	DWORD dwWnd=MAXWORD;

	HWND hParent=GetParent(hResult);
	if(hParent!=NULL){
		//ポップアップウインドウではない
		if((GetWindowLongPtr(hResult,GWL_STYLE)&WS_POPUP)==0){
			//子ウインドウ取得
			HWND hChild=GetWindow(hParent,GW_CHILD);

			while(hChild!=NULL){
				//非表示の子ウインドウを無視
				if(IsWindowVisible(hChild)){
					RECT rc;

					GetWindowRect(hChild,&rc);
					if(PtInRect(&rc,pt)!=0){
						DWORD dwWndChild=(rc.right-rc.left)*(rc.bottom-rc.top);

						if(dwWndChild<dwWnd){
							dwWnd=dwWndChild;
							hResult=hChild;
						}
					}
				}
				hChild=GetWindow(hChild,GW_HWNDNEXT);
			}
		}
	}
	return hResult;
}

//エディットコントロールであるか否か
bool IsEditControl(HWND hWnd){
	TCHAR szClass[32]={};

	//クラス名取得
	GetClassName(hWnd,szClass,ARRAY_SIZEOF(szClass));
	return lstrcmp(szClass,WC_EDIT)==0||(SendMessage(hWnd,WM_GETDLGCODE,0,0)&(DLGC_WANTCHARS|DLGC_HASSETSEL|DLGC_WANTARROWS))!=0;
}

//パスワードマスクが有効なエディットコントロールかどうか
bool IsPasswordmaskEditControl(HWND hWnd){
	return IsEditControl(hWnd)&&
		SendMessage(hWnd,EM_GETPASSWORDCHAR,0,0)!=0;
}

//文字列をクリップボードにコピー
bool SetClipboardText(HWND hWnd,const TCHAR* pszText,int iLength){
	bool bResult=false;
	int iBufferSize=0;

	if(!OpenClipboard(hWnd))return bResult;

	iBufferSize=(iLength+sizeof(TCHAR))*sizeof(TCHAR);
	HGLOBAL hGlobal=GlobalAlloc(GMEM_MOVEABLE,iBufferSize);
	if(hGlobal!=NULL){
		LPVOID lpMemory=(LPVOID)GlobalLock(hGlobal);
		lstrcpy((LPTSTR)lpMemory,pszText);
		GlobalUnlock(hGlobal);
		EmptyClipboard();
#ifdef UNICODE
		bResult=SetClipboardData(CF_UNICODETEXT,hGlobal)!=NULL;
#else
		bResult=SetClipboardData(CF_TEXT,hGlobal)!=NULL;
#endif
	}
	CloseClipboard();
	return bResult;
}

//ウインドウをフォアグラウンドに持ってくる
bool SetForegroundWindowEx(HWND hWnd){
	bool bResult=false;
	bool bHung=IsHungAppWindow(hWnd)!=0;
	DWORD dwCurrentThreadId=0,dwTargetThreadId=0;
	DWORD dwTimeout=0;

	//最小化されていたらもとに戻す
	if(IsIconic(hWnd)){
		ShowWindow(hWnd,SW_RESTORE);
	}

	dwCurrentThreadId=GetCurrentThreadId();
	dwTargetThreadId=GetWindowThreadProcessId(hWnd,NULL);

	if(IsIconic(hWnd)){
		//最小化されている場合まず元に戻す
		ShowWindow(hWnd,SW_RESTORE);
	}

	if(!bHung){
		for(int i=0;i<10&&hWnd!=GetForegroundWindow();i++){
			//あの手この手
			dwCurrentThreadId=GetCurrentThreadId();
			dwTargetThreadId=GetWindowThreadProcessId(GetForegroundWindow(),NULL);
			AttachThreadInput(dwCurrentThreadId,dwTargetThreadId,true);
			SetWindowPos(hWnd,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
			BringWindowToTop(hWnd);
			AllowSetForegroundWindow(ASFW_ANY);
			bResult=SetForegroundWindow(hWnd)!=0;
			AttachThreadInput(dwCurrentThreadId,dwTargetThreadId,false);
			Sleep(10);
		}
	}else{
		//対象のウインドウが応答なしの場合、AttachThreadInput()とSetWindowPos()を実行すると巻き添えに
		BringWindowToTop(hWnd);
		bResult=SetForegroundWindow(hWnd)!=0;
	}
	return bResult;
}
