﻿//Nelumbo64.c
//64bitソフトウェア対象プロセス

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Nelumbo Ver.1.72
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Nelumboはクリックひとつでパスワード「*****」を表示&コピーするソフトウェアです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/

#include"StdAfx.h"
#include<shlwapi.h>


#ifndef _DEBUG
#ifdef _MSC_VER
#pragma comment(linker,"/merge:.data=.text")
#pragma comment(linker,"/section:.text,erw")
#endif
#endif

HWND g_hwndMain;

//マウスフック用DLL
HMODULE g_hHookDll;
typedef BOOL(*INSTALLMSGHOOK_PTR)(const DWORD);
typedef BOOL(*CALLGETPASSWORD_PTR)(const HWND,const HWND);
typedef BOOL(*CALLSHOWPASSWORD_PTR)(const HWND,const HWND);
typedef BOOL(*UNINSTALLMSGHOOK_PTR)();
typedef BOOL(*INSTALLFOCUSHOOK_PTR)(HWND,UINT);
typedef BOOL(*UNINSTALLFOCUSHOOK_PTR)();
INSTALLMSGHOOK_PTR pInstallMsgHook;
CALLGETPASSWORD_PTR pCallGetPassword;
CALLSHOWPASSWORD_PTR pCallShowPassword;
UNINSTALLMSGHOOK_PTR pUninstallMsgHook;
INSTALLFOCUSHOOK_PTR pInstallFocusHook;
UNINSTALLFOCUSHOOK_PTR pUninstallFocusHook;

UINT WM_HOOKDIALOG;



LRESULT CALLBACK WndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam){
	switch(uMsg){
		case WM_COPYDATA:
			SendMessage(FindWindow(NELUMBO_CLASS_NAME,NULL),uMsg,wParam,lParam);
			//fall through
		case WM_DESTROY:
			PostQuitMessage(0);
			break;

		default:
			break;
	}

	if(uMsg==WM_HOOKDIALOG){
		SendMessage(FindWindow(NELUMBO_CLASS_NAME,NULL),uMsg,wParam,lParam);
	}

	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

//エントリポイント
#ifndef _DEBUG
void WinMainCRTStartup(){
#else
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInst,LPSTR lpszCmdLine,int nCmdShow){
#endif
#define MSGFLT_ALLOW 1
#define MSGFLT_RESET 0
#define MSGFLT_ADD 1
#define MSGFLT_REMOVE 2
	HWND hWnd,hFindWindow=NULL;
	MSG msg;
	int iResult=-1;
	TCHAR szEnv[32]={0},szEnvMode[32]={0};
	HINSTANCE hInstance=GetModuleHandle(NULL);
	WNDCLASS wc={0};
	typedef BOOL(WINAPI*PCHANGEWINDOWMESSAGEFILTEREX)(HWND,UINT,DWORD,int);
	typedef BOOL(WINAPI*PCHANGEWINDOWMESSAGEFILTER)(UINT,DWORD);
	PCHANGEWINDOWMESSAGEFILTEREX pChangeWindowMessageFilterEx=NULL;
	PCHANGEWINDOWMESSAGEFILTER pChangeWindowMessageFilter=NULL;

	GetEnvironmentVariable(_T("NELUMBO_TARGET_HWND"),szEnv,ARRAY_SIZEOF(szEnv));
	GetEnvironmentVariable(_T("NELUMBO64_MODE"),szEnvMode,ARRAY_SIZEOF(szEnvMode));

	if(lstrcmp(szEnv,_T(""))==0&&
	   lstrcmp(szEnvMode,_T("FocusHookMode"))!=0){
		if(GetLastError()==ERROR_ALREADY_EXISTS){
			hFindWindow=FindWindow(NELUMBO_CLASS_NAME64,NULL);
			if(hFindWindow){
				SendMessage(hFindWindow,WM_CLOSE,(WPARAM)0,(LPARAM)0);
			}
			ExitProcess(0);
		}
	}

	if(lstrcmp(szEnv,_T(""))==0){
		if(lstrcmp(szEnvMode,_T("FocusHookMode"))!=0){
			//Nelumboを起動し、自分は終了
			TCHAR szProcess[]=_T("Nelumbo");
			STARTUPINFO StartupInfo={sizeof(STARTUPINFO)};
			PROCESS_INFORMATION ProcessInfo={0};

			CreateProcess(NULL,szProcess,NULL,NULL,FALSE,0,NULL,NULL,&StartupInfo,&ProcessInfo);
			ExitProcess(iResult);
		}
	}

	wc.lpszClassName=NELUMBO_CLASS_NAME64;
	wc.hInstance=hInstance;
	wc.lpfnWndProc=WndProc;
	RegisterClass(&wc);

	hWnd=CreateWindow(NELUMBO_CLASS_NAME64,
					  NULL,
					  0,
					  0,0,
					  0,0,
					  NULL,
					  NULL,
					  hInstance,
					  NULL);

	g_hwndMain=hWnd;

	WM_HOOKDIALOG=RegisterWindowMessage(_T("_WM_HOOKDIALOG_"));
	g_hHookDll=LoadLibrary(_T("MsgHook64.dll"));
	if(g_hHookDll!=NULL){
		//メッセージ受信許可
		pChangeWindowMessageFilterEx=(PCHANGEWINDOWMESSAGEFILTEREX)GetProcAddress(GetModuleHandle(_T("user32")),"ChangeWindowMessageFilterEx");

		if(pChangeWindowMessageFilterEx){
			pChangeWindowMessageFilterEx(hWnd,WM_COPYDATA,MSGFLT_ALLOW,0);
			pChangeWindowMessageFilterEx(hWnd,WM_HOOKDIALOG,MSGFLT_ALLOW,0);
		}else{
			pChangeWindowMessageFilter=(PCHANGEWINDOWMESSAGEFILTER)GetProcAddress(GetModuleHandle(_T("user32")),"ChangeWindowMessageFilter");
			if(pChangeWindowMessageFilter){
				pChangeWindowMessageFilter(WM_COPYDATA,MSGFLT_ADD);
				pChangeWindowMessageFilter(WM_HOOKDIALOG,MSGFLT_ADD);
			}
		}

		if(lstrcmp(szEnvMode,_T("FocusHookMode"))!=0){
			pInstallMsgHook=(INSTALLMSGHOOK_PTR)GetProcAddress(g_hHookDll,"InstallMsgHook");
			pCallGetPassword=(CALLGETPASSWORD_PTR)GetProcAddress(g_hHookDll,"CallGetPassword");
			pCallShowPassword=(CALLSHOWPASSWORD_PTR)GetProcAddress(g_hHookDll,"CallShowPassword");
			pUninstallMsgHook=(UNINSTALLMSGHOOK_PTR)GetProcAddress(g_hHookDll,"UninstallMsgHook");

			//対象のウインドウハンドルを取得
			LONGLONG llTarget=0;

			StrToInt64Ex(szEnv,STIF_DEFAULT,&llTarget);
			pInstallMsgHook(GetWindowThreadProcessId((HWND)llTarget,NULL));

			TCHAR szDummy[12]={0};
			BOOL bShowPassword=GetEnvironmentVariable(_T("NELUMBO_SHOW_PASSWORD"),szDummy,ARRAY_SIZEOF(szDummy));

			if((!bShowPassword)?
			   pCallGetPassword((HWND)llTarget,hWnd):
			   pCallShowPassword((HWND)llTarget,hWnd)){
				iResult=1;
			}
		}else{
			pInstallFocusHook=(INSTALLFOCUSHOOK_PTR)GetProcAddress(g_hHookDll,"InstallFocusHook");
			pUninstallFocusHook=(UNINSTALLFOCUSHOOK_PTR)GetProcAddress(g_hHookDll,"UninstallFocusHook");

			pInstallFocusHook(hWnd,WM_HOOKDIALOG);

		}
	}

	while(GetMessage(&msg,NULL,0,0)){
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	if(pChangeWindowMessageFilterEx){
		pChangeWindowMessageFilterEx(hWnd,WM_COPYDATA,MSGFLT_RESET,0);
		pChangeWindowMessageFilterEx(hWnd,WM_HOOKDIALOG,MSGFLT_RESET,0);
	}else if(pChangeWindowMessageFilter){
		pChangeWindowMessageFilter(WM_COPYDATA,MSGFLT_REMOVE);
		pChangeWindowMessageFilter(WM_HOOKDIALOG,MSGFLT_REMOVE);
	}

	if(lstrcmp(szEnvMode,_T("FocusHookMode"))!=0){
		pUninstallMsgHook();
	}else{
		pUninstallFocusHook();
	}
	FreeLibrary(g_hHookDll);

	ExitProcess(iResult);
}
