﻿//PrivateProfile.cpp
//cfgファイル操作

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Nelumbo Ver.1.72
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Nelumboはクリックひとつでパスワード「*****」を表示&コピーするソフトウェアです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/

#include"StdAfx.h"
#include"CommonSettings.h"
#include"PrivateProfile.h"
#include<shlwapi.h>

TCHAR g_szPrivateProfile[MAX_PATH]={};

//KeyDataアイテム
LPCTSTR lpszKeyDataItem[]={
	_T("LButtonWheel"),
	_T("RButtonWheel"),
	_T("CtrlWheel"),
	_T("CtrlLButton"),
	_T("CtrlRButton"),
	_T("AltWheel"),
	_T("AltLButton"),
	_T("AltRButton"),
	_T("HotKey")
};

//デフォルトのKeyData設定値
const DWORD dwDefaultKeyDataItem[KEYDATA_NUM]={
	//左クリック+ホイール回転
	KD_MODE_PASSWORD|KD_TARGET_SINGLE,
	//右クリック+ホイール回転
	KD_MODE_CONTROL|KD_TARGET_SINGLE,
	//Ctrl+ホイール回転
	KD_MODE_PASSWORD|KD_TARGET_WINDOW|KD_EX_MASK,
	//Ctrl+左クリック
	KD_MODE_PASSWORD|KD_TARGET_SINGLE,
	//Ctrl+右クリック
	KD_MODE_CONTROL|KD_TARGET_SINGLE,
	//Alt+ホイール回転
	KD_MODE_CONTROL|KD_TARGET_ALL,
	//Alt+左クリック
	0,
	//Alt+右クリック
	0,
	//ホットキー
	KD_MODE_PASSWORD|KD_TARGET_ALL,
};

//cfgファイルパスを取得
void GetPrivateProfilePath(){
	GetModuleFileName(NULL,g_szPrivateProfile,MAX_PATH);
	PathRemoveFileSpec(g_szPrivateProfile);
	lstrcat(g_szPrivateProfile,_T("\\Nelumbo.cfg"));
	return;
}

//整数を文字列に変換してPrivateProfileファイルに書き込む
bool WINAPI WritePrivateProfileInt(LPCTSTR lpAppName,LPCTSTR lpKeyName,LONG_PTR lData,LPCTSTR lpFileName){
	TCHAR szValue[256]={};

	wsprintf(szValue,_T("%d"),lData);
	return WritePrivateProfileString(lpAppName,lpKeyName,szValue,lpFileName)!=0;
}

//PrivateProfileファイルへ書き込む
void WritePrivateProfile(){
	//左クリック+ホイール回転～Alt+右クリック
	for(size_t i=0;i<KEYDATA_NUM;i++){
		WritePrivateProfileInt(_T("KeyData"),lpszKeyDataItem[i],g_Config.dwKeyData[i],g_szPrivateProfile);
	}
	//ホットキー
	WritePrivateProfileInt(_T("HotKey"),_T("HotKey"),g_Config.wHotKey,g_szPrivateProfile);
	//自動的にパスワードマスクを解除
	WritePrivateProfileInt(_T("Mode"),_T("AutoUnmask"),g_Config.bAutoUnmask,g_szPrivateProfile);
	return;
}

//PrivateProfileファイルから読み込む
void ReadPrivateProfile(){
	GetPrivateProfilePath();//cfgファイルパス取得

	//左クリックホイール回転～Alt+右クリック
	for(size_t i=0;i<KEYDATA_NUM;i++){
		g_Config.dwKeyData[i]=(DWORD)GetPrivateProfileInt(_T("KeyData"),lpszKeyDataItem[i],dwDefaultKeyDataItem[i],g_szPrivateProfile);
	}
	//ホットキー
	//848=Ctrl+Shift+P
	g_Config.wHotKey=(WORD)GetPrivateProfileInt(_T("HotKey"),_T("HotKey"),848,g_szPrivateProfile);
	//自動的にパスワードマスクを解除
	g_Config.bAutoUnmask=(WORD)GetPrivateProfileInt(_T("Mode"),_T("AutoUnmask"),0,g_szPrivateProfile)!=0;
	return;
}
