﻿//Settings.cpp
//設定ダイアログ

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Nelumbo Ver.1.72
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Nelumboはクリックひとつでパスワード「*****」を表示&コピーするソフトウェアです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/

#include"StdAfx.h"
#include"Settings.h"
#include"CommonSettings.h"
#include"Function.h"
#include"PrivateProfile.h"
#include"resources/resource.h"

enum{
	ID_MODE_NONE=0,
	ID_MODE_PASSWORD,
	ID_MODE_CONTROL,
};

enum{
	ID_TARGET_SINGLE=0,
	ID_TARGET_WINDOW,
	ID_TARGET_ALL,
};

enum{
	ID_EX_NONE=0,
	ID_EX_MASK,
	ID_EX_MENU,
};

//コントロールでのインデックスを取得
#define GetModeControlIndex(dwKeyData) ((dwKeyData&KD_MODE_PASSWORD)?ID_MODE_PASSWORD:(dwKeyData&KD_MODE_CONTROL)?ID_MODE_CONTROL:ID_MODE_NONE)
#define GetTargetControlIndex(dwKeyData) ((dwKeyData&KD_TARGET_ALL)?ID_TARGET_ALL:(dwKeyData&KD_TARGET_WINDOW)?ID_TARGET_WINDOW:ID_TARGET_SINGLE)
#define GetExControlIndex(dwKeyData) ((dwKeyData&KD_EX_MASK)?ID_EX_MASK:(dwKeyData&KD_EX_MENU)?ID_EX_MENU:ID_EX_NONE)
/*
//ホットキー登録
void RegistHotKey(HWND hWnd);
//ホットキー登録解除
void UnregistHotKey(HWND hWnd);
//画面中央にダイアログを表示
void CenterDialog(HWND hDlg);
//設定ウインドウを表示する
void ShowSettingsDialog(HWND hWnd,int iStartTab);
//現在の設定をコントロールに適用
void SetCurrentSettings(HWND hDlg,struct CONFIG* pConfig,int iIndex);
//設定ダイアログプロシージャ
BOOL CALLBACK SettingsDialogProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);
//「全般」タブプロシージャ
BOOL CALLBACK GeneralTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);
//リストビュープロシージャ
LRESULT CALLBACK ListViewProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
//「バージョン情報」タブプロシージャ
BOOL CALLBACK VersionTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);
//リンクプロシージャ
LRESULT CALLBACK HyperLinkProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
*/
//最初に表示するタブ
int g_iStartTab;


//ホットキー登録
void RegistHotKey(HWND hWnd){
	if(g_Config.wHotKey){
		UINT uModifiers=0,uVirtKey=0;
		WORD wModify=(WORD)(g_Config.wHotKey>>8);

		if(wModify&HOTKEYF_SHIFT){
			uModifiers|=MOD_SHIFT;
		}
		if(wModify&HOTKEYF_ALT){
			uModifiers|=MOD_ALT;
		}
		if(wModify&HOTKEYF_CONTROL){
			uModifiers|=MOD_CONTROL;
		}
		uVirtKey=(UINT)LOBYTE(g_Config.wHotKey);
		if(!RegisterHotKey(hWnd,ID_HOTKEY,uModifiers,uVirtKey)){
			//ホットキー登録に失敗
			MessageBox(hWnd,_T("ホットキーの登録に失敗しました"),NELUMBO_VERSION,MB_OK);
			g_Config.wHotKey=0;
		}
	}
	return;
}

//ホットキー登録解除
void UnregistHotKey(HWND hWnd){
	if(g_Config.wHotKey){
		UnregisterHotKey(hWnd,ID_HOTKEY);
	}
	return;
}

//画面中央にダイアログを表示
void CenterDialog(HWND hDlg){
	RECT rc;
	HWND hParent=GetParent(hDlg);
	GetWindowRect(hParent,&rc);
	SetWindowPos(hParent,
				NULL,
				(GetSystemMetrics(SM_CXSCREEN)-(rc.right-rc.left))>>1,
				(GetSystemMetrics(SM_CYSCREEN)-(rc.bottom-rc.top))>>1,
				-1,
				-1,
				SWP_NOSIZE|SWP_NOZORDER|SWP_NOACTIVATE);
	return;
}

//現在の設定をコントロールに適用
void SetCurrentSettings(HWND hDlg,struct CONFIG* pConfig,int iIndex){
	if(iIndex<0)return;
	//動作
	SendDlgItemMessage(hDlg,IDC_COMBO_MODE,CB_SETCURSEL,(WPARAM)GetModeControlIndex(pConfig->dwKeyData[iIndex]),(LPARAM)0);
	//対象
	SendDlgItemMessage(hDlg,IDC_COMBO_TARGET,CB_SETCURSEL,(WPARAM)GetTargetControlIndex(pConfig->dwKeyData[iIndex]),(LPARAM)0);
	//拡張
	if(pConfig->dwKeyData[iIndex]&KD_MODE_PASSWORD){
		//パスワードマスクを解除
		SendDlgItemMessage(hDlg,IDC_CHECKBOX_EX_MASK,BM_SETCHECK,(WPARAM)(pConfig->dwKeyData[iIndex]&KD_EX_MASK)?BST_CHECKED:BST_UNCHECKED,(LPARAM)0);
	}else if(pConfig->dwKeyData[iIndex]&KD_MODE_CONTROL){
		//無効なメニューも有効化
		SendDlgItemMessage(hDlg,IDC_CHECKBOX_EX_MENU,BM_SETCHECK,(WPARAM)(pConfig->dwKeyData[iIndex]&KD_EX_MENU)?BST_CHECKED:BST_UNCHECKED,(LPARAM)0);
	}
	//ホットキー
	SendDlgItemMessage(hDlg,IDC_HOTKEY,HKM_SETHOTKEY,(WPARAM)pConfig->wHotKey,(LPARAM)0);
	return;
}

//「全般」ページ
BOOL CALLBACK GeneralTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	int i=0;
	//選択行
	static int iIndex;
	static HWND hListView;
	LVCOLUMN LVColumn;
	LVITEM LVItem;

	//カラム順
	enum{
		//操作
		LISTITEM_KEY=0,
		//動作
		LISTITEM_MODE,
		//対象
		LISTITEM_TARGET,
		//拡張
		LISTITEM_EX,
		LISTITEM_NUM,
	};
	//リストビューカラム
	LPCTSTR lpszListViewColumn[]={
		_T("操作"),
		_T("動作"),
		_T("対象"),
		_T("拡張"),
	};
	//リストビュー「操作」アイテム
	LPCTSTR lpszKeyListViewItem[]={
		_T("左クリック+ホイール回転"),
		_T("右クリック+ホイール回転"),
		_T("Ctrl+ホイール回転"),
		_T("Ctrl+左クリック"),
		_T("Ctrl+右クリック"),
		_T("Alt+ホイール回転"),
		_T("Alt+左クリック"),
		_T("Alt+右クリック"),
		_T("ホットキー"),
	};
	//リストビュー「動作」アイテム(コンボボックスでも使用)
	LPCTSTR lpszModeListViewItem[]={
		_T("なし"),
		_T("パスワード表示"),
		_T("コントロール有効化"),
	};
	//リストビュー「対象」アイテム(コンボボックスでも使用)
	LPCTSTR lpszTargetListViewItem[]={
		_T("ひとつのみ"),
		_T("ウインドウ上全て"),
		_T("画面上全て"),
	};
	//リストビュー「拡張」アイテム
	LPCTSTR lpszExListViewItem[]={
		_T("なし"),
		_T("パスワードマスクを解除"),
		_T("無効なメニューも有効化"),
	};

	//設定一時保存用
	static struct CONFIG ConfigTmp;

	switch(uMsg){
		case WM_INITDIALOG:{
			ConfigTmp=g_Config;

			hListView=GetDlgItem(hDlg,IDC_LIST);
			//リストビューにカラムを追加
			LVColumn.mask=LVCF_FMT|LVCF_WIDTH|LVCF_TEXT|LVCF_SUBITEM;
			LVColumn.fmt=LVCFMT_LEFT;
			for(i=0;i<LISTITEM_NUM;i++){
				LVColumn.cx=(i==LISTITEM_TARGET)?100:130;
				LVColumn.pszText=(LPTSTR)lpszListViewColumn[i];
				LVColumn.iSubItem=i;
				ListView_InsertColumn(hListView,i,&LVColumn);
			}
			//リストビューにアイテムを追加
			LVItem.mask=LVIF_TEXT;
			for(i=0;i<(int)ARRAY_SIZEOF(lpszKeyListViewItem);i++){
				//操作
				LVItem.pszText=(LPTSTR)lpszKeyListViewItem[i];
				LVItem.iItem=i;
				LVItem.iSubItem=LISTITEM_KEY;
				ListView_InsertItem(hListView,&LVItem);
				//動作
				LVItem.pszText=(LPTSTR)lpszModeListViewItem[GetModeControlIndex(g_Config.dwKeyData[i])];
				LVItem.iSubItem=LISTITEM_MODE;
				ListView_SetItem(hListView,&LVItem);
				//対象
				LVItem.pszText=(LPTSTR)lpszTargetListViewItem[GetTargetControlIndex(g_Config.dwKeyData[i])];
				LVItem.iSubItem=LISTITEM_TARGET;
				ListView_SetItem(hListView,&LVItem);
				//拡張
				LVItem.pszText=(LPTSTR)lpszExListViewItem[GetExControlIndex(g_Config.dwKeyData[i])];
				LVItem.iSubItem=LISTITEM_EX;
				ListView_SetItem(hListView,&LVItem);
			}

			//「動作」にアイテムを追加
			for(i=0;i<(int)ARRAY_SIZEOF(lpszModeListViewItem);i++){
				SendDlgItemMessage(hDlg,IDC_COMBO_MODE,CB_ADDSTRING,(WPARAM)0,(LPARAM)lpszModeListViewItem[i]);
			}

			//「対象」にアイテムを追加
			for(i=0;i<(int)ARRAY_SIZEOF(lpszTargetListViewItem);i++){
				SendDlgItemMessage(hDlg,IDC_COMBO_TARGET,CB_ADDSTRING,(WPARAM)0,(LPARAM)lpszTargetListViewItem[i]);
			}

			//LVS_EX_FULLROWSELECT(行全体選択)
			//LVS_EX_GRIDLINES(罫線表示)
			ListView_SetExtendedListViewStyle(hListView,ListView_GetExtendedListViewStyle(hListView)|
											  LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

			//先頭行を選択
			ListView_SetItemState(hListView,0,LVIS_FOCUSED|LVIS_SELECTED,LVIS_FOCUSED|LVIS_SELECTED);

			//現在の設定をコントロールに適用
			SetCurrentSettings(hDlg,&g_Config,0);
			return true;
		}

		case WM_CTLCOLORSTATIC:{
			HDC hDC=(HDC)wParam;
			SetBkMode(hDC,TRANSPARENT);
			break;
		}

		case WM_COMMAND:{
			int iComboIndex=0;

			if(LOWORD(wParam)==IDC_COMBO_MODE||LOWORD(wParam)==IDC_COMBO_TARGET){
				iComboIndex=SendDlgItemMessage(hDlg,LOWORD(wParam),CB_GETCURSEL,(WPARAM)0,(LPARAM)0);
			}
			switch(LOWORD(wParam)){
				case IDC_COMBO_MODE:
					//動作
					if(HIWORD(wParam)==CBN_SELCHANGE){
						if(iIndex<0)break;

						//動作をクリア
						ConfigTmp.dwKeyData[iIndex]&=~KD_MODE_CLEAR;
						//拡張を一度「なし」に
						ListView_SetItemText(hListView,iIndex,LISTITEM_EX,(LPTSTR)lpszExListViewItem[ID_EX_NONE]);
						SendDlgItemMessage(hDlg,IDC_CHECKBOX_EX_MASK,BM_SETCHECK,(WPARAM)BST_UNCHECKED,(LPARAM)0);
						SendDlgItemMessage(hDlg,IDC_CHECKBOX_EX_MENU,BM_SETCHECK,(WPARAM)BST_UNCHECKED,(LPARAM)0);
						if(iComboIndex==ID_MODE_NONE){
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MASK),SW_HIDE);
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MENU),SW_HIDE);
							//拡張をクリア
							ConfigTmp.dwKeyData[iIndex]&=~KD_EX_CLEAR;
						}else if(iComboIndex==ID_MODE_PASSWORD){
							//パスワード表示
							ConfigTmp.dwKeyData[iIndex]|=KD_MODE_PASSWORD;
							SetDlgItemText(hDlg,IDC_CHECKBOX_EX_MASK,lpszExListViewItem[ID_EX_MASK]);
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MASK),SW_SHOW);
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MENU),SW_HIDE);
							if(ConfigTmp.dwKeyData[iIndex]&KD_EX_MASK){
								ListView_SetItemText(hListView,iIndex,LISTITEM_EX,(LPTSTR)lpszExListViewItem[ID_EX_MASK]);
								SendDlgItemMessage(hDlg,IDC_CHECKBOX_EX_MASK,BM_SETCHECK,(WPARAM)BST_CHECKED,(LPARAM)0);
							}
						}else if(iComboIndex==ID_MODE_CONTROL){
							//コントロール有効化
							ConfigTmp.dwKeyData[iIndex]|=KD_MODE_CONTROL;
							SetDlgItemText(hDlg,IDC_CHECKBOX_EX_MENU,lpszExListViewItem[ID_EX_MENU]);
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MASK),SW_HIDE);
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MENU),SW_SHOW);
							if(ConfigTmp.dwKeyData[iIndex]&KD_EX_MENU){
								ListView_SetItemText(hListView,iIndex,LISTITEM_EX,(LPTSTR)lpszExListViewItem[ID_EX_MENU]);
								SendDlgItemMessage(hDlg,IDC_CHECKBOX_EX_MENU,BM_SETCHECK,(WPARAM)BST_CHECKED,(LPARAM)0);
							}
						}
						ListView_SetItemText(hListView,iIndex,LISTITEM_MODE,(LPTSTR)lpszModeListViewItem[iComboIndex]);
					}
					break;

				case IDC_COMBO_TARGET:
					//対象
					if(HIWORD(wParam)==CBN_SELCHANGE){
						if(iIndex<0)break;

						//対象をクリア
						ConfigTmp.dwKeyData[iIndex]&=~KD_TARGET_CLEAR;
						if(iComboIndex==ID_TARGET_SINGLE){
							//ひとつのみ
							ConfigTmp.dwKeyData[iIndex]|=KD_TARGET_SINGLE;
						}else if(iComboIndex==ID_TARGET_WINDOW){
							//ウインドウ上全て
							ConfigTmp.dwKeyData[iIndex]|=KD_TARGET_WINDOW;
						}else{
							//画面上全て
							ConfigTmp.dwKeyData[iIndex]|=KD_TARGET_ALL;
						}
						ListView_SetItemText(hListView,iIndex,LISTITEM_TARGET,(LPTSTR)lpszTargetListViewItem[iComboIndex]);
					}
					break;

				case IDC_CHECKBOX_EX_MASK:
				case IDC_CHECKBOX_EX_MENU:{
					//拡張
					if(iIndex<0)break;

					int iExIndex=0;
					bool bChecked=false;

					if(SendDlgItemMessage(hDlg,LOWORD(wParam),BM_GETCHECK,(WPARAM)0,(LPARAM)0)==BST_CHECKED)bChecked=true;
					if(LOWORD(wParam)==IDC_CHECKBOX_EX_MASK&&ConfigTmp.dwKeyData[iIndex]&KD_MODE_PASSWORD){
						//パスワードマスクを解除
						if(bChecked){
							iExIndex=ID_EX_MASK;
							ConfigTmp.dwKeyData[iIndex]|=KD_EX_MASK;
						}else{
							iExIndex=ID_EX_NONE;
							ConfigTmp.dwKeyData[iIndex]&=~KD_EX_MASK;
						}
					}else if(LOWORD(wParam)==IDC_CHECKBOX_EX_MENU&&ConfigTmp.dwKeyData[iIndex]&KD_MODE_CONTROL){
						//無効なメニューも無効化
						if(bChecked){
							iExIndex=ID_EX_MENU;
							ConfigTmp.dwKeyData[iIndex]|=KD_EX_MENU;
						}else{
							iExIndex=ID_EX_NONE;
							ConfigTmp.dwKeyData[iIndex]&=~KD_EX_MENU;
						}
					}else{
						//なし
						iExIndex=ID_EX_NONE;
					}
					ListView_SetItemText(hListView,iIndex,LISTITEM_EX,(LPTSTR)lpszExListViewItem[iExIndex]);
					break;
				}

				case IDC_HOTKEY:
					//ホットキー
					//現在の設定を保存
					ConfigTmp.wHotKey=(WORD)SendDlgItemMessage(hDlg,IDC_HOTKEY,HKM_GETHOTKEY,(WPARAM)0,(LPARAM)0);
					break;

				case IDC_BUTTON_UNREGHOTKEY:
					//解除
					ConfigTmp.wHotKey=0;
					SendDlgItemMessage(hDlg,IDC_HOTKEY,HKM_SETHOTKEY,(WPARAM)0,(LPARAM)0);
					break;

				default:
					break;
			}
			break;
		}

		case WM_NOTIFY:
			if(((LPNMHDR)lParam)->idFrom==IDC_LIST){
				switch(((LPNMLISTVIEW)lParam)->hdr.code){
					case LVN_ITEMCHANGED:
						iIndex=ListView_GetNextItem(((LPNMLISTVIEW)lParam)->hdr.hwndFrom,-1,LVIS_SELECTED);
						SetCurrentSettings(hDlg,&ConfigTmp,iIndex);

						if(ConfigTmp.dwKeyData[iIndex]&KD_MODE_PASSWORD){
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MASK),SW_SHOW);
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MENU),SW_HIDE);
							SetDlgItemText(hDlg,IDC_CHECKBOX_EX_MENU,lpszExListViewItem[ID_EX_MASK]);
						}else if(ConfigTmp.dwKeyData[iIndex]&KD_MODE_CONTROL){
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MASK),SW_HIDE);
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MENU),SW_SHOW);
							SetDlgItemText(hDlg,IDC_CHECKBOX_EX_MENU,lpszExListViewItem[ID_EX_MENU]);
						}else{
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MASK),SW_HIDE);
							ShowWindow(GetDlgItem(hDlg,IDC_CHECKBOX_EX_MENU),SW_HIDE);
							SetDlgItemText(hDlg,IDC_CHECKBOX_EX_MENU,lpszExListViewItem[ID_EX_NONE]);
						}

						if(ListView_GetItemCount(((LPNMLISTVIEW)lParam)->hdr.hwndFrom)-1==iIndex){
							ShowWindow(GetDlgItem(hDlg,IDC_HOTKEY),SW_SHOW);
							ShowWindow(GetDlgItem(hDlg,IDC_BUTTON_UNREGHOTKEY),SW_SHOW);
						}else{
							ShowWindow(GetDlgItem(hDlg,IDC_HOTKEY),SW_HIDE);
							ShowWindow(GetDlgItem(hDlg,IDC_BUTTON_UNREGHOTKEY),SW_HIDE);
						}
						break;
					default:
						break;
				}
			}
			break;

		case WM_CLOSETAB:
			//設定を保存
			g_Config=ConfigTmp;
			break;

		default:
			break;
	}
	return false;
}


//ハイパーリンクのプロシージャ
LRESULT CALLBACK HyperLinkProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam){
	switch(uMsg){
		case WM_SETCURSOR:
			SetCursor(LoadCursor(NULL,IDC_HAND));
			return true;

		default:
			break;
	}
	return CallWindowProc((WNDPROC)GetWindowLongPtr(hWnd,GWLP_USERDATA),hWnd,uMsg,wParam,lParam);
}

//「バージョン情報」ページ
BOOL CALLBACK VersionTabProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	static HFONT hFont;
	static HICON hIcon;

	switch(uMsg){
		case WM_INITDIALOG:{
			//バージョン情報入力
			SetDlgItemText(hDlg,IDC_STATIC_NELUMBO_VERSION,NELUMBO_VERSION);

			//フォントを作成
			LOGFONT lfFont;
			GetObject(GetWindowFont(hDlg),sizeof(LOGFONT),&lfFont);
			lfFont.lfUnderline=true;
			hFont=CreateFontIndirect(&lfFont);
			//フォントを設定
			HWND hURL=GetDlgItem(hDlg,IDC_STATIC_URL);
			SetWindowFont(hURL,hFont,false);

			//アイコン読み込み
			hIcon=(HICON)LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICON1),IMAGE_ICON,48,48,LR_SHARED);

			//アイコン設定
			SendMessage(GetDlgItem(hDlg,IDC_PICTURE_ICON),STM_SETIMAGE,IMAGE_ICON,(LPARAM)hIcon);

			//サブクラス化
			SetWindowLongPtr(hURL,GWLP_USERDATA,GetWindowLongPtr(hURL,GWLP_WNDPROC));
			SetWindowLongPtr(hURL,GWLP_WNDPROC,(LONG_PTR)HyperLinkProc);
			return true;
		}

		case WM_CTLCOLORSTATIC:{
			HDC hDC=(HDC)wParam;
			SetBkMode(hDC,TRANSPARENT);
			break;
		}

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_STATIC_URL:
					if(HIWORD(wParam)==STN_CLICKED){
						//ホームページへ
						TCHAR szURL[256]={};

						GetWindowText(GetDlgItem(hDlg,IDC_STATIC_URL),szURL,ARRAY_SIZEOF(szURL));
						ShellExecute(NULL,_T("open"),szURL,NULL,NULL,SW_SHOWNORMAL);
						return true;
					}
					break;
				default:
					break;
			}
			break;

		case WM_CLOSETAB:
			//フォント削除
			DeleteFont(hFont);
			break;

		default:
			break;
	}
	return false;
}

//設定ダイアログプロシージャ
BOOL CALLBACK SettingsDialogProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	static HWND hTab;
	//「全般」タブ
	static HWND hTabGeneral;
	//「バージョン情報」タブ
	static HWND hTabVersion;

	switch (uMsg){
		case WM_INITDIALOG:{
			CenterDialog(hDlg);
			SetForegroundWindowEx(hDlg);

			InitCommonControls();
			hTab=GetDlgItem(hDlg,IDC_TAB);

			//タブ追加
			TC_ITEM TabItem;

			TabItem.mask=TCIF_TEXT;
			TabItem.pszText=(LPTSTR)_T("全般");
			TabCtrl_InsertItem(hTab,0,&TabItem);

			TabItem.mask=TCIF_TEXT;
			TabItem.pszText=(LPTSTR)_T("バージョン情報");
			TabCtrl_InsertItem(hTab,1,&TabItem);

			//タブ(ダイアログ)作成
			hTabGeneral=CreateDialog(g_hInstance,MAKEINTRESOURCE(IDD_GENERAL_TAB),hDlg,(DLGPROC)GeneralTabProc);
			hTabVersion=CreateDialog(g_hInstance,MAKEINTRESOURCE(IDD_VERSION_TAB),hDlg,(DLGPROC)VersionTabProc);

			//タブの座標取得
			RECT rc;
			LPPOINT lpt=(LPPOINT)&rc;

			GetClientRect(hTab,&rc);
			TabCtrl_AdjustRect(hTab,false,&rc);
			//座標変換
			MapWindowPoints(hTab,hDlg,lpt,2);

			//タブの位置とサイズの調整
			MoveWindow(hTabGeneral,
						rc.left,
						rc.top,
						rc.right-rc.left,
						rc.bottom-rc.top,
						false);
			MoveWindow(hTabVersion,
						rc.left,
						rc.top,
						rc.right-rc.left,
						rc.bottom-rc.top,
						false);

			//タブを表示
			if(g_iStartTab==0){//全般
				ShowWindow(hTabGeneral,SW_SHOW);
				ShowWindow(hTabVersion,SW_HIDE);
				TabCtrl_SetCurFocus(hTab,0);
			}else{//バージョン情報
				ShowWindow(hTabGeneral,SW_HIDE);
				ShowWindow(hTabVersion,SW_SHOW);
				TabCtrl_SetCurFocus(hTab,1);
			}
			return true;
		}

		case WM_NOTIFY:{
			if(((LPNMHDR)lParam)->idFrom==IDC_TAB){
				switch(((LPNMHDR)lParam)->code){
					case TCN_SELCHANGE:
						switch(TabCtrl_GetCurSel(hTab)){
							case 0://全般
								ShowWindow(hTabGeneral,SW_SHOW);
								ShowWindow(hTabVersion,SW_HIDE);
								return true;

							case 1://バージョン情報
								ShowWindow(hTabGeneral,SW_HIDE);
								ShowWindow(hTabVersion,SW_SHOW);
								return true;

							default:
								break;
						}
						break;

					default:
						break;
				}
			}
			break;
		}

		case WM_COMMAND :
			switch(LOWORD(wParam)){
				case IDOK:
					if(IsWindowVisible(hTabGeneral)){
						//設定を保存
						SendMessage(hTabGeneral,WM_CLOSETAB,(WPARAM)0,(LPARAM)0);
						//cfgファイルに書き込む
						WritePrivateProfile();
					}else{
						SendMessage(hTabVersion,WM_CLOSETAB,(WPARAM)0,(LPARAM)0);
					}

				case IDCANCEL:
					EndDialog(hDlg,IDOK);
					break;
			}
			return true;

		case WM_CLOSE:
			PostMessage(hDlg,WM_COMMAND,(WPARAM)IDCANCEL,(LPARAM)0);
			return true;

		default:
			return false;
	}
	return false;
}

//設定ウインドウを表示する
void ShowSettingsDialog(HWND hWnd,int iStartTab){
	g_iStartTab=iStartTab;
	DialogBox(g_hInstance,MAKEINTRESOURCE(IDD_SETTINGS_DIALOG),hWnd,(DLGPROC)SettingsDialogProc);
	return;
}
