﻿//HookMessage.c

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	Nelumbo Ver.1.72
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	Nelumboはクリックひとつでパスワード「*****」を表示&コピーするソフトウェアです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/

#include"..\StdAfx.h"
#include"HookMessage.h"


#ifndef _DEBUG
#ifdef _MSC_VER
#pragma comment(linker,"/merge:.data=.text")
#pragma comment(linker,"/section:.text,erw")
#endif
#endif

HHOOK g_hHook=NULL;
DWORD g_dwThreadId=0;
HINSTANCE g_hInstDll=NULL;

UINT WM_GETPASSWORD=WM_APP+12;
UINT WM_SHOWPASSWORD=WM_APP+13;

//パスワードを取得する
void GetPassword(const HWND hTarget,const HWND hDispatch){
	TCHAR szBuffer[512];
	COPYDATASTRUCT CopyDataStruct;

	SendMessage(hTarget,WM_GETTEXT,ARRAY_SIZEOF(szBuffer),(LPARAM)szBuffer);
	CopyDataStruct.dwData=HandleToLong(hTarget);
	CopyDataStruct.cbData=(lstrlen(szBuffer)+1)*sizeof(TCHAR);
	CopyDataStruct.lpData=szBuffer;

	SendMessage(hDispatch,WM_COPYDATA,(WPARAM)hTarget,(LPARAM)&CopyDataStruct);
}

//パスワードマスクを解除
void ShowPassword(const HWND hTarget,const HWND hDispatch){
	COPYDATASTRUCT CopyDataStruct;
	HWND hFocus=GetFocus();

	PostMessage(hTarget,EM_SETPASSWORDCHAR,(WPARAM)0,(LPARAM)0);
	InvalidateRect(hTarget,NULL,TRUE);
	UpdateWindow(hTarget);
	SetFocus(hTarget);
	SetFocus(hFocus);

	CopyDataStruct.dwData=HandleToLong(hTarget);
	CopyDataStruct.cbData=0;
	CopyDataStruct.lpData=NULL;

	SendMessage(hDispatch,WM_COPYDATA,(WPARAM)hTarget,(LPARAM)&CopyDataStruct);
}

//WH_GETMESSAGEのコールバック
LRESULT WINAPI GetMsgProc(int nCode,WPARAM wParam,LPARAM lParam){
	if(nCode>=0){
		MSG *pMsg=(MSG*)lParam;

		if(pMsg->message==WM_GETPASSWORD){
			GetPassword((HWND)pMsg->wParam,(HWND)pMsg->lParam);
		}else if(pMsg->message==WM_SHOWPASSWORD){
			ShowPassword((HWND)pMsg->wParam,(HWND)pMsg->lParam);
		}
	}

	return CallNextHookEx(NULL,nCode,wParam,lParam);
}

//WH_GETMESSAGEフックをインストール
BOOL DLL_EXPORT InstallMsgHook(const DWORD dwThreadId){
	BOOL bResult=FALSE;

	//フック済み
	if(g_dwThreadId==dwThreadId)return TRUE;

	//別のスレッドをフックしているのでフックを解除
	if(g_dwThreadId!=dwThreadId&&g_hHook!=NULL){
		UninstallMsgHook();
	}

	g_dwThreadId=dwThreadId;

	if(g_dwThreadId!=0){
		HANDLE hMutex=CreateMutex(NULL,FALSE,_T("{F8E4635B-514E-4581-B2EA-F622ED0AB137}"));

		if(hMutex!=NULL){
			if(WaitForSingleObject(hMutex,INFINITE)==WAIT_OBJECT_0){
				g_hHook=SetWindowsHookEx(WH_GETMESSAGE,GetMsgProc,g_hInstDll,g_dwThreadId);
				bResult=g_hHook!=NULL;
			}
			ReleaseMutex(hMutex);
			CloseHandle(hMutex);
			hMutex=NULL;
		}
	}

	return bResult;
}

//フックをアンインストール
BOOL DLL_EXPORT UninstallMsgHook(){
	BOOL bResult=FALSE;

	if(g_hHook!=NULL){
		bResult=UnhookWindowsHookEx(g_hHook)!=0;
		g_hHook=NULL;
		g_dwThreadId=0;
	}
	return bResult;
}

//GetPassword()関数を呼び出す
BOOL DLL_EXPORT CallGetPassword(const HWND hTarget,const HWND hDispatch){
	BOOL bResult=FALSE;

	if(g_dwThreadId!=0&&hTarget!=NULL&&hDispatch!=NULL){
		PostThreadMessage(g_dwThreadId,WM_GETPASSWORD,(WPARAM)hTarget,(LPARAM)hDispatch);
		bResult=TRUE;
	}

	return bResult;
}

//ShowPassword()関数を呼び出す
BOOL DLL_EXPORT CallShowPassword(const HWND hTarget,const HWND hDispatch){
	BOOL bResult=FALSE;

	if(g_dwThreadId!=0&&hTarget!=NULL&&hDispatch!=NULL){
		PostThreadMessage(g_dwThreadId,WM_SHOWPASSWORD,(WPARAM)hTarget,(LPARAM)hDispatch);
		bResult=TRUE;
	}

	return bResult;
}

#pragma data_seg(".myseg")
HWND g_hWnd=NULL;
UINT WM_HOOKDIALOG=0;
HHOOK g_hook_handle=NULL;
#pragma data_seg()
#pragma comment(linker,"/Section:.myseg,rws")
LRESULT CALLBACK CBTProc(int code,WPARAM wparam,LPARAM lparam){
	if(code==HCBT_SETFOCUS){
		if(g_hWnd!=NULL&&
		   GetWindowLongPtr((HWND)wparam,GWL_STYLE)&WS_VISIBLE&&
		   !(GetWindowLongPtr((HWND)wparam,GWL_STYLE)&WS_DISABLED)){
			PostMessage(g_hWnd,WM_HOOKDIALOG,wparam,lparam);
		}
	}
	return CallNextHookEx(NULL/*This parameter is ignored.*/,code,wparam,lparam);
}

BOOL DLL_EXPORT InstallFocusHook(HWND hWnd,UINT msg){
	if((g_hook_handle=SetWindowsHookEx(WH_CBT,CBTProc,g_hInstDll,0))!=NULL){
		g_hWnd=hWnd;
		WM_HOOKDIALOG=msg;
		return TRUE;
	}
	return FALSE;
}

//フックをアンインストール
BOOL DLL_EXPORT UninstallFocusHook(){
	if(g_hook_handle!=NULL&&
	   UnhookWindowsHookEx(g_hook_handle)!=0){
		PostMessage(HWND_BROADCAST,WM_SETTINGCHANGE,0,0);
		g_hook_handle=NULL;
		g_hWnd=NULL;
		return TRUE;
	}

	return FALSE;
}

BOOL WINAPI DllMain(HINSTANCE hInstDll,DWORD fdwReason,LPVOID lpvReserved){
	switch (fdwReason){
		case DLL_PROCESS_ATTACH:
			// attach to process
			// return FALSE to fail DLL load
			//Dllのハンドルを保存
			g_hInstDll=hInstDll;
			//DLL_THREAD_ATTACHとDLL_THREAD_DETACHを無効にする
			DisableThreadLibraryCalls(hInstDll);
			break;

		case DLL_PROCESS_DETACH:
			// detach from process
			break;

		case DLL_THREAD_ATTACH:
			// attach to thread
			break;

		case DLL_THREAD_DETACH:
			// detach from thread
			break;
	}
	return TRUE;// succesful
}
