#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <richedit.h>

#include "resource.h"

HINSTANCE hInst;
HINSTANCE hRichDll;

BOOL CALLBACK DialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	switch(uMsg){
		case WM_INITDIALOG:
			/*
			 * TODO: Add code to initialize the dialog.
			 */
			CHARFORMAT cfm;

			memset(&cfm,0,sizeof(CHARFORMAT));
			cfm.cbSize=sizeof(CHARFORMAT);
			cfm.dwMask=CFM_COLOR;
			cfm.crTextColor=RGB(255,0,0);
			cfm.dwEffects=0;

			SendMessage(GetDlgItem(hwndDlg,IDC_RICHEDIT1),EM_SETCHARFORMAT,(WPARAM)SCF_SELECTION,(LPARAM)&cfm);
			SendMessage(GetDlgItem(hwndDlg,IDC_RICHEDIT1),EM_REPLACESEL,(WPARAM)FALSE,(LPARAM)"JEgJtEL[I[");
			return TRUE;

		case WM_CLOSE:
			EndDialog(hwndDlg,0);
			return TRUE;

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				/*
				 * TODO: Add more control ID's, when needed.
				 */
				case IDC_BTN_QUIT:
					EndDialog(hwndDlg,0);
					return TRUE;

				case IDC_BTN_TEST:
					MessageBox(hwndDlg,"You clicked \"Test\" button!","Information",MB_ICONINFORMATION);
					return TRUE;

				default:
					break;
			}
	}

	return FALSE;
}


int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd){
	hInst=hInstance;

	hRichDll=LoadLibrary("Riched20.dll");

	// The user interface is a modal dialog box
	int iResult=DialogBox(hInstance,MAKEINTRESOURCE(DLG_MAIN),NULL,(DLGPROC)DialogProc);

	if(hRichDll!=NULL)FreeLibrary(hRichDll);

	return iResult;
}
