#define STRICT
#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <commctrl.h>

#include "resource.h"

#define ID_TAB1 0
#define ID_TAB2 1

#define WM_CLOSETAB (WM_APP+100)

HINSTANCE g_hInstance;

BOOL CALLBACK Tab1Proc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	switch(uMsg){
		case WM_INITDIALOG:{
			/*
			* TODO: Add code to initialize the dialog.
			*/
			HWND hEdit=GetDlgItem(hDlg,IDC_EDIT1);

			SendMessage(hEdit,EM_SETSEL,(WPARAM)GetWindowTextLength(hEdit),(LPARAM)GetWindowTextLength(hEdit));
			SendMessage(hEdit,EM_REPLACESEL,(WPARAM)0,(LPARAM)"^uRg[\n");

			SendMessage(hEdit,EM_SETSEL,(WPARAM)GetWindowTextLength(hEdit),(LPARAM)GetWindowTextLength(hEdit));
			SendMessage(hEdit,EM_REPLACESEL,(WPARAM)0,(LPARAM)"Ă\n");
			return true;
		}

		case WM_COMMAND:
			/*
			* TODO: Add more control ID's, when needed.
			*/
			break;

		case WM_CLOSETAB:
			return true;
	}

	return false;
}

BOOL CALLBACK Tab2Proc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	switch(uMsg){
		case WM_INITDIALOG:
			/*
			* TODO: Add code to initialize the dialog.
			*/
			break;

		case WM_CLOSETAB:
			return true;
	}

	return false;
}

bool CALLBACK DialogProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){
	static HWND hTab;
	static HWND hTab1;
	static HWND hTab2;

	switch (uMsg){
		case WM_INITDIALOG:{
			hTab=GetDlgItem(hDlg,IDC_TAB1);

			//^uǉ
			TC_ITEM TabItem;

			TabItem.mask=TCIF_TEXT;
			TabItem.pszText=(char*)"Tab1";
			TabCtrl_InsertItem(hTab,ID_TAB1,&TabItem);

			TabItem.mask=TCIF_TEXT;
			TabItem.pszText=(char*)"Tab2";
			TabCtrl_InsertItem(hTab,ID_TAB2,&TabItem);

			//^u(_CAO)쐬
			hTab1=CreateDialog(g_hInstance,MAKEINTRESOURCE(IDD_TAB1),hDlg,(DLGPROC)Tab1Proc);
			hTab2=CreateDialog(g_hInstance,MAKEINTRESOURCE(IDD_TAB2),hDlg,(DLGPROC)Tab2Proc);

			//^u̍W擾
			RECT rc;
			LPPOINT lpt=(LPPOINT)&rc;

			GetClientRect(hTab,&rc);
			TabCtrl_AdjustRect(hTab,false,&rc);
			//Wϊ
			MapWindowPoints(hTab,hDlg,lpt,2);

			//^üʒuƃTCY̒
			MoveWindow(hTab1,
						rc.left,
						rc.top,
						rc.right-rc.left,
						rc.bottom-rc.top,
						false
			);
			MoveWindow(hTab2,
						rc.left,
						rc.top,
						rc.right-rc.left,
						rc.bottom-rc.top,
						false
			);

			//^u\
			ShowWindow(hTab1,SW_SHOW);
			ShowWindow(hTab2,SW_HIDE);
			TabCtrl_SetCurFocus(hTab,ID_TAB1);
			return true;
		}

		case WM_NOTIFY:{
			switch(((LPNMHDR)lParam)->idFrom){
				case IDC_TAB1:
					switch(((LPNMHDR)lParam)->code){
						case TCN_SELCHANGE:
							switch(TabCtrl_GetCurSel(hTab)){
								case ID_TAB1:
									ShowWindow(hTab1,SW_SHOW);
									ShowWindow(hTab2,SW_HIDE);
									return true;
								case ID_TAB2:
									ShowWindow(hTab1,SW_HIDE);
									ShowWindow(hTab2,SW_SHOW);
									return true;
								default:
									break;
							}
							break;
						default:
							break;
					}
			}
			break;
		}

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				/*
				* TODO: Add more control ID's, when needed.
				*/
				case IDC_BTN_QUIT:
					EndDialog(hDlg,0);
					return true;

				case IDC_BTN_TEST:
					MessageBox(hDlg,"You clicked \"Test\" button!","Information",MB_ICONINFORMATION);
					return true;
			}

		case WM_CLOSE:
			EndDialog(hDlg,0);
			return true;

		default:
			return false;
	}
	return false;
}


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd){
	g_hInstance=hInstance;

	// The user interface is a modal dialog box
	return DialogBox(hInstance,MAKEINTRESOURCE(DLG_MAIN),NULL,(DLGPROC)DialogProc);
}
