﻿//clipNENNE.cpp
//メイン

/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	その娘なら今俺のクリップボードで寝てるけど Ver.1.00
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	「その娘なら今俺のクリップボードで寝てるけど」は、
	指定された画像ファイルの内容をクリップボードにコピーするソフトウェアです。
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/


#include"Pch.h"
#include"GDIPlusInit.h"

#include<gdiplus.h>

//HBITMAPとして画像を読み込む
HBITMAP LoadHBITMAP(TCHAR* pszFileName){
	Gdiplus::Bitmap* pBitmap=Gdiplus::Bitmap::FromFile(pszFileName);
	if(pBitmap->GetLastStatus()!=Gdiplus::Ok)return NULL;

	HBITMAP hBitmap=NULL;
	pBitmap->GetHBITMAP(0,&hBitmap);
	return hBitmap;
}

//クリップボードにあるテキストのサイズを取得
int GetClipboardSize(){
	if(!IsClipboardFormatAvailable(CF_TEXT))return -1;

	if(!OpenClipboard(NULL))return -1;

#ifdef UNICODE
	HGLOBAL hGlobal=GetClipboardData(CF_UNICODETEXT);
#else
	HGLOBAL hGlobal=GetClipboardData(CF_TEXT);
#endif //UNICODE

	CloseClipboard();
	return GlobalSize(hGlobal);
} 

//HBITMAPをクリップボードにコピー
bool SetClipboardBitmap(HWND hWnd,HBITMAP hBitmap){
	bool bResult=false;

	DIBSECTION ds;
	GetObject(hBitmap,sizeof(ds),&ds);
	//圧縮形式をBI_BITFIELDSからBI_RGBに変更
	ds.dsBmih.biCompression=BI_RGB;
	HDC hDC=GetDC(NULL);
	//DIBをDDBに変換
	HBITMAP hDDB=CreateDIBitmap(hDC,
								&ds.dsBmih,
								CBM_INIT,
								ds.dsBm.bmBits,
								(BITMAPINFO*)&ds.dsBmih,
								DIB_RGB_COLORS);
	ReleaseDC(NULL,hDC);

	//If an application calls OpenClipboard with hwnd set to NULL, EmptyClipboard sets the clipboard owner to NULL; this causes SetClipboardData to fail.
	//(http://msdn.microsoft.com/en-us/library/windows/desktop/ms649051%28v=vs.85%29.aspx)
	if(!OpenClipboard(hWnd))return bResult;
	EmptyClipboard();
	if(SetClipboardData(CF_BITMAP,hDDB)){
		bResult=true;
	}
	CloseClipboard();
	return bResult;
}

//クリップボードのテキストを取得
bool GetClipboardText(TCHAR* pszResult){
	bool bResult=false;

	if(!IsClipboardFormatAvailable(CF_TEXT))return bResult;

	if(!OpenClipboard(NULL))return bResult;

#ifdef UNICODE
	HGLOBAL hGlobal=GetClipboardData(CF_UNICODETEXT);
#else
	HGLOBAL hGlobal=GetClipboardData(CF_TEXT);
#endif //UNICODE

	const TCHAR* pszText=(TCHAR*)GlobalLock(hGlobal);

	lstrcpy(pszResult,pszText);
	bResult=true;

	GlobalUnlock(hGlobal);
	CloseClipboard();

	return bResult;
}


//ウインドウプロシージャ
LRESULT CALLBACK WindowProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam){
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

//ウインドウクラスを登録
bool InitApplication(HINSTANCE hInstance,LPCTSTR lpszClassName){
	WNDCLASS wc;

	wc.style		=0;
	wc.lpfnWndProc	=(WNDPROC)WindowProc;
	wc.cbClsExtra	=0;
	wc.cbWndExtra	=0;
	wc.hInstance	=hInstance;
	wc.hIcon		=NULL;
	wc.hCursor		=NULL;
	wc.hbrBackground=NULL;
	wc.lpszMenuName	=NULL;
	wc.lpszClassName=lpszClassName;
	return RegisterClass(&wc);
}

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd){
	TCHAR szWindowClass[]=_T("{9DE68620-D6DB-43c7-8529-D7E2968E5E41}");

	//コマンドライン引数を取得
	int iArgc=0;//argc
	LPTSTR* lplpszArgv=NULL;//argv
	lplpszArgv=CommandLineToArgvW(GetCommandLine(),&iArgc);

	if(IsClipboardFormatAvailable(CF_TEXT)&&iArgc==1){
		bool bResult=false;
		TCHAR* pszBuffer=(TCHAR*)malloc(GetClipboardSize()+1);

		if(pszBuffer!=NULL){
			if(GetClipboardText(pszBuffer)){
				lplpszArgv[1]=pszBuffer;
				bResult=true;
			}else{
				MessageBox(NULL,_T("クリップボードからパスを取得できませんでした。"),NULL,MB_OK|MB_ICONERROR);
			}
		}else{
			return 1;
		}
		free(pszBuffer);
		if(!bResult)return -1;
	}else if(iArgc!=2){
		MessageBox(NULL,_T("引数が不正です。"),NULL,MB_OK|MB_ICONERROR);
		return 1;
	}

	InitApplication(hInstance,szWindowClass);

	HWND hWnd=CreateWindow(szWindowClass,
						   NULL,
						   0,
						   0,0,
						   0,0,
						   NULL,
						   NULL,
						   hInstance,
						   NULL);

	if(hWnd==NULL)MessageBox(NULL,_T("ウインドウの作成に失敗しました。"),NULL,MB_OK);

	//GDI+の初期化
	CGDIPlusInit GDIPlusInit;

	HBITMAP hBitmap=LoadHBITMAP(lplpszArgv[1]);
	if(hBitmap==NULL){
		MessageBox(NULL,_T("画像ファイルの読み込みに失敗しました。"),NULL,MB_OK|MB_ICONERROR);
	}else{
		if(!SetClipboardBitmap(hWnd,hBitmap))MessageBox(NULL,_T("クリップボードへのコピーに失敗しました。"),NULL,MB_OK|MB_ICONERROR);
		DeleteObject(hBitmap);
	}

	return 0;
}
