//clipper -Clipboard Logger- Ver.2.00
//coded by Y.Takanashi
#include <windows.h>
#include <psapi.h>
#include <shlwapi.h>
#define ID_MYTIMER 5001
#define ID_HOTKEY 10001
#define MY_BUFSIZE 1024
#define APP_NAME "clipper"

HANDLE hStdout=NULL;
CONSOLE_SCREEN_BUFFER_INFO screenBuffer;
DWORD dwWriteByte;
HWND hNextWnd=NULL;
BOOL is_output=FALSE,is_overwrite=FALSE,is_hide=FALSE,WM_CREATE_OK=FALSE;

#define F_BLACK			0
#define F_OLIVE			FOREGROUND_RED|FOREGROUND_GREEN
#define F_NAVY			FOREGROUND_BLUE
#define F_MAROON		FOREGROUND_RED
#define F_GREEN			FOREGROUND_GREEN
#define F_PURPLE		FOREGROUND_RED|FOREGROUND_BLUE
#define F_SILVER			FOREGROUND_RED|FOREGROUND_BLUE|FOREGROUND_GREEN
#define F_TEAL				FOREGROUND_BLUE|FOREGROUND_GREEN
#define F_YELLOW		FOREGROUND_RED|FOREGROUND_GREEN|FOREGROUND_INTENSITY
#define F_BLUE			FOREGROUND_BLUE|FOREGROUND_INTENSITY
#define F_RED				FOREGROUND_RED|FOREGROUND_INTENSITY
#define F_LIME				FOREGROUND_GREEN|FOREGROUND_INTENSITY
#define F_MAGENTA	FOREGROUND_RED|FOREGROUND_BLUE|FOREGROUND_INTENSITY
#define F_WHITE			FOREGROUND_RED|FOREGROUND_BLUE|FOREGROUND_GREEN|FOREGROUND_INTENSITY
#define F_AQUA			FOREGROUND_BLUE|FOREGROUND_GREEN|FOREGROUND_INTENSITY
#define F_GRAY			0|FOREGROUND_INTENSITY
#define B_BLACK			0
#define B_OLIVE			BACKGROUND_RED|BACKGROUND_GREEN
#define B_NAVY			BACKGROUND_BLUE
#define B_MAROON		BACKGROUND_RED
#define B_GREEN			BACKGROUND_GREEN
#define B_PURPLE		BACKGROUND_RED|BACKGROUND_BLUE
#define B_SILVER			BACKGROUND_RED|BACKGROUND_BLUE|BACKGROUND_GREEN
#define B_TEAL			BACKGROUND_BLUE|BACKGROUND_GREEN
#define B_YELLOW		BACKGROUND_RED|BACKGROUND_GREEN|BACKGROUND_INTENSITY
#define B_BLUE			BACKGROUND_BLUE|BACKGROUND_INTENSITY
#define B_RED				BACKGROUND_RED|BACKGROUND_INTENSITY
#define B_LIME				BACKGROUND_GREEN|BACKGROUND_INTENSITY
#define B_MAGENTA	BACKGROUND_RED|BACKGROUND_BLUE|BACKGROUND_INTENSITY
#define B_WHITE			BACKGROUND_RED|BACKGROUND_BLUE|BACKGROUND_GREEN|BACKGROUND_INTENSITY
#define B_AQUA			BACKGROUND_BLUE|BACKGROUND_GREEN|BACKGROUND_INTENSITY
#define B_GRAY			0|BACKGROUND_INTENSITY

PSTR GetFileName(char *pp_ext){
	static char path_module[MAX_PATH]={'\0'};
	GetModuleFileName(NULL,path_module,MAX_PATH);
	PathRenameExtension(PathFindFileName(path_module),pp_ext);
	return path_module;
}

HWND GetConsoleHwnd(void){
	HWND hwndFound;
	char pszNewWindowTitle[MY_BUFSIZE];
	char pszOldWindowTitle[MY_BUFSIZE];
	GetConsoleTitle(pszOldWindowTitle, MY_BUFSIZE);
	wsprintf(pszNewWindowTitle,"%d/%d",GetTickCount(),GetCurrentProcessId());
	SetConsoleTitle(pszNewWindowTitle);
	Sleep(40);
	hwndFound=FindWindow(NULL, pszNewWindowTitle);
	SetConsoleTitle(pszOldWindowTitle);
	return(hwndFound);
}

BOOL ReadPrivateProfile(void){
	WORD color=0;
	BOOL cfg_ok=FALSE;
	PSTR CfgPath=NULL;
	char FGColor[7]={'\0'};
	char BGColor[7]={'\0'};
	char Title[1024]={'\0'};
	CfgPath=GetFileName(".cfg");
	switch(GetFileAttributes(CfgPath)){
			case FILE_ATTRIBUTE_DIRECTORY:break;
			case -1:break;
			default:cfg_ok=TRUE;
	}
	if(!cfg_ok)return FALSE;
	is_output=(BOOL)GetPrivateProfileInt("Main","OutputLog",0,CfgPath);
	if(is_output)is_overwrite=(BOOL)GetPrivateProfileInt("Main","OverWrite",0,CfgPath);
	if(is_output)is_hide=(BOOL)GetPrivateProfileInt("Main","Hide",0,CfgPath);
	if(!is_hide){
		GetPrivateProfileString("Main","ForeGround","silver",FGColor,sizeof(FGColor),CfgPath);
		if(!lstrcmpi(FGColor,"black"))color=F_BLACK;
		else if(!lstrcmpi(FGColor,"olive"))color=F_OLIVE;
		else if(!lstrcmpi(FGColor,"navy"))color=F_NAVY;
		else if(!lstrcmpi(FGColor,"maroon"))color=F_MAROON;
		else if(!lstrcmpi(FGColor,"green"))color=F_GREEN;
		else if(!lstrcmpi(FGColor,"purple"))color=F_PURPLE;
		else if(!lstrcmpi(FGColor,"silver"))color=F_SILVER;
		else if(!lstrcmpi(FGColor,"teal"))color=F_TEAL;
		else if(!lstrcmpi(FGColor,"yellow"))color=F_YELLOW;
		else if(!lstrcmpi(FGColor,"blue"))color=F_BLUE;
		else if(!lstrcmpi(FGColor,"red"))color=F_RED;
		else if(!lstrcmpi(FGColor,"lime"))color=F_LIME;
		else if(!lstrcmpi(FGColor,"magenta"))color=F_MAGENTA;
		else if(!lstrcmpi(FGColor,"white"))color=F_WHITE;
		else if(!lstrcmpi(FGColor,"aqua"))color=F_AQUA;
		else if(!lstrcmpi(FGColor,"gray"))color=F_GRAY;
		else color=F_SILVER;
		GetPrivateProfileString("Main","BackGround","black",BGColor,sizeof(BGColor),CfgPath);
		if(!lstrcmpi(BGColor,"black"))color+=B_BLACK;
		else if(!lstrcmpi(BGColor,"olive"))color+=B_OLIVE;
		else if(!lstrcmpi(BGColor,"navy"))color+=B_NAVY;
		else if(!lstrcmpi(BGColor,"maroon"))color+=B_MAROON;
		else if(!lstrcmpi(BGColor,"green"))color+=B_GREEN;
		else if(!lstrcmpi(BGColor,"purple"))color+=B_PURPLE;
		else if(!lstrcmpi(BGColor,"silver"))color+=B_SILVER;
		else if(!lstrcmpi(BGColor,"teal"))color+=B_TEAL;
		else if(!lstrcmpi(BGColor,"yellow"))color+=B_YELLOW;
		else if(!lstrcmpi(BGColor,"blue"))color+=B_BLUE;
		else if(!lstrcmpi(BGColor,"red"))color+=B_RED;
		else if(!lstrcmpi(BGColor,"lime"))color+=B_LIME;
		else if(!lstrcmpi(BGColor,"magenta"))color+=B_MAGENTA;
		else if(!lstrcmpi(BGColor,"white"))color+=B_WHITE;
		else if(!lstrcmpi(BGColor,"aqua"))color+=B_AQUA;
		else if(!lstrcmpi(BGColor,"gray"))color+=B_GRAY;
		else color+=B_BLACK;
		SetConsoleTextAttribute(hStdout,color);
		GetPrivateProfileString("Main","Title",NULL,Title,sizeof(Title),CfgPath);
		if(lstrcmp(Title,""))SetConsoleTitle(Title);
	}
	return TRUE;
}

BOOL WriteLogfile(PSTR pstr){
	HANDLE hFile;
	DWORD dwWriteSize;
	hFile=CreateFile(GetFileName(".log"),GENERIC_READ|GENERIC_WRITE,0,NULL,(is_overwrite)?(CREATE_ALWAYS):(OPEN_ALWAYS),FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE) {
		MessageBox(NULL,"Cannot open file.",NULL,MB_OK|MB_TOPMOST|MB_ICONEXCLAMATION);
		return FALSE;
	}
	if(is_overwrite){SetFilePointer(hFile,0,NULL,FILE_BEGIN);is_overwrite=FALSE;}
	else SetFilePointer(hFile,0,NULL,FILE_END);
	WriteFile(hFile,pstr,lstrlen(pstr),&dwWriteSize,NULL);
	CloseHandle(hFile);
	return TRUE;
}

LRESULT CALLBACK WndProc(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp){
	HANDLE hText=NULL;
	BOOL not_timer=FALSE;
	HWND hConsole=NULL;
	char *pText=NULL;
	switch(msg){
		case WM_CREATE:
			if(!RegisterHotKey(hWnd,ID_HOTKEY,MOD_WIN,0x43)){
				MessageBox(NULL,"Cannot register hotkey.\n[Windows]+C",NULL,MB_OK|MB_TOPMOST|MB_ICONEXCLAMATION);
				DestroyWindow(hWnd);
			}
			hNextWnd=SetClipboardViewer(hWnd);
			if(!SetTimer(hWnd,ID_MYTIMER,3000,NULL))not_timer=TRUE;
			ReadPrivateProfile();
			if(is_hide){
				hConsole=GetConsoleHwnd();
				ShowWindow(hConsole,SW_HIDE);
			}
			WM_CREATE_OK=TRUE;
		break;
		case WM_DRAWCLIPBOARD:
			if(!WM_CREATE_OK)break;
			OpenClipboard(hWnd);
			hText=GetClipboardData(CF_TEXT);
			if(hText){
				pText=GlobalLock(hText);
				lstrcat(pText,"\n");
				WriteFile(hStdout,pText,lstrlen(pText),&dwWriteByte,NULL);
				if(is_output)WriteLogfile(pText);
				GlobalUnlock(hText);
			}
			CloseClipboard();
			if(hNextWnd)SendMessage(hNextWnd,msg,wp,lp);
			break;
		case WM_CHANGECBCHAIN:
			if((HWND)wp==hNextWnd)hNextWnd=(HWND)lp;
			else if(hNextWnd)SendMessage(hNextWnd,msg,wp,lp);
			break;
		case WM_TIMER:
			EmptyWorkingSet(GetCurrentProcess());
			break;
			case WM_HOTKEY:
				switch(LOWORD(wp)){
					case ID_HOTKEY:
						SetConsoleTextAttribute(hStdout,screenBuffer.wAttributes);
						if(!not_timer)KillTimer(hWnd,ID_MYTIMER);
						ChangeClipboardChain(hWnd,hNextWnd);
						UnregisterHotKey(hWnd,ID_HOTKEY);
						FreeConsole();
						PostQuitMessage(0);
					return 0;
			}
			break;
	}
	return DefWindowProc(hWnd,msg,wp,lp);
}

void WinMainCRTStartup(void){
	WNDCLASSEX wc;
	HINSTANCE hInst;
	HWND hWnd;
	MSG msg;
	hInst=GetModuleHandle(NULL);
	AllocConsole();
	hStdout=CreateFile("CONOUT$",GENERIC_WRITE,FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,0);
	GetConsoleScreenBufferInfo(hStdout,&screenBuffer);
	wc.cbSize=sizeof(wc);
	wc.style=0;
	wc.lpfnWndProc=WndProc;
	wc.cbClsExtra=0;
	wc.cbWndExtra=0;
	wc.hInstance=hInst;
	wc.hIcon=NULL;
	wc.hIconSm=NULL;
	wc.hCursor=NULL;
	wc.hbrBackground=NULL;
	wc.lpszMenuName=NULL;
	wc.lpszClassName=APP_NAME;
	if(RegisterClassEx(&wc)==0){ExitProcess(0);}
	hWnd=CreateWindow(APP_NAME,NULL,0,0,0,0,0,(HWND)NULL,(HMENU)NULL,hInst,(LPVOID)NULL);
	if(hWnd==NULL){ExitProcess(1);}
	UpdateWindow(hWnd);
	while(1){
		BOOL ret=GetMessage(&msg,NULL,0,0);
		if(ret==0||ret==-1){
			break;
		}else{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	ExitProcess(0);
}
