﻿//eyesofSaya.cpp
//eyes of Saya Ver.1.00
//Coded by 高梨怜奈
#include"Common.h"
#include"resources/resource.h"
#include"third-party/jhead/jhead.h"

#include<objidl.h>
#include<olectl.h>

#include<shlwapi.h>


HINSTANCE g_hInstance=NULL;//インスタンスハンドル

//左ウインドウの幅
int g_iLeftWidth=250;
//ウインドウ下部の余白の高さ
int g_iBlank=100;

const TCHAR g_szURL[]=_T("http://www16.atpages.jp/rayna/index.html");

#define IDC_GROUPBOX_ORIGINAL 1001
#define IDC_GROUPBOX_THUMBNAIL 1002
#define IDC_BUTTON_OROGINAL 1003
#define IDC_BUTTON_THUMBNAIL 1004
#define IDC_BUTTON_CREATE 1005
#define IDC_BUTTON_SAVE 1006
#define IDC_BUTTON_DELETE 1007
#define IDC_STATIC_URL 1008
#define SPLIT_WIDTH 2

//関数のプロトタイプ宣言
//一つのファイルをを選択
bool SelectSingleFile(BOOL _stdcall (*pOpenFileFunc)(LPOPENFILENAME),HWND hWnd,const TCHAR* pszFilter,const TCHAR* pszTitle,TCHAR* pszResult,int iLength);
//ウインドウを揺らす
void ShakeWindow(HWND hWnd,int iTimes);
//イメージファイルからHBITMAPを取得
HBITMAP GetThumbnailFromImage(LPCTSTR lpszFilepath,int iDestWidth,int iDestHeight);
//サムネイルを設定
void SetButtonThumbnail(HWND hButton,LPCTSTR lpszImagepath,int iWidth,int iHeight);
//マウスポインタの位置のコントロールのハンドルを取得
HWND ControlFromPoint();
//ファイルが存在するか否か
bool FileExists(LPCTSTR lpszFilepath);
//共通グループボックスプロシージャ
LRESULT CALLBACK GroupBoxProc(HWND hgrpGroupbox,UINT uMsg,WPARAM wParam,LPARAM lParam);
//リンクプロシージャ
LRESULT CALLBACK HyperLinkProc(HWND hstcStatic,UINT uMsg,WPARAM wParam,LPARAM lParam);
//ウインドウプロシージャ
LRESULT CALLBACK WindowProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam);
//ウインドウクラスを登録
bool InitApplication(HINSTANCE hInstance,LPCTSTR lpszClassName);
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInst,LPSTR lpszCmdLine,int nCmdShow);

//一つのファイルをを選択
bool SelectSingleFile(BOOL _stdcall (*pOpenFileFunc)(LPOPENFILENAME),HWND hWnd,const TCHAR* pszFilter,const TCHAR* pszTitle,TCHAR* pszResult,int iLength){
	TCHAR szDlgErr[30]={0};//CommDlgExtendedError()用

	pszResult[0]=_T('\0');
	OPENFILENAME OpenFileName;
	ZeroMemory(&OpenFileName,sizeof(OPENFILENAME));
	OpenFileName.lStructSize=sizeof(OPENFILENAME);
	OpenFileName.hwndOwner=hWnd;
	OpenFileName.lpstrFilter=pszFilter;
	OpenFileName.lpstrFile=pszResult;
	OpenFileName.nMaxFile=iLength;
	OpenFileName.lpstrTitle=pszTitle;
	OpenFileName.Flags=OFN_EXPLORER|OFN_HIDEREADONLY|OFN_FILEMUSTEXIST|OFN_OVERWRITEPROMPT;
	if(!(pOpenFileFunc(&OpenFileName))){
		DWORD dwDlgErr=CommDlgExtendedError();
		if(dwDlgErr!=0){
			wsprintf(szDlgErr,_T("ファイルの選択に失敗しました。\nErrCode:0x%08X"),dwDlgErr);
			MessageBox(hWnd,szDlgErr,NULL,MB_ICONWARNING);
			pszResult[0]=_T('\0');
			return false;
		}
		return false;
	}
	return true;
}

//ウインドウを揺らす
void ShakeWindow(HWND hWnd,int iTimes){
	RECT rect;
	int iArrayX[]={-8,-5,0,5,8,0};
	int iArrayY[]={0,-8,-5,0,5,8};

	GetWindowRect(hWnd,&rect);
	for(int iCount=0;iCount<iTimes;iCount++){
		SetWindowPos(hWnd,NULL,rect.left+iArrayX[iCount%6],rect.top+iArrayY[iCount%6],0,0,SWP_NOSIZE|SWP_NOZORDER);
		Sleep(0);
	}
	SetWindowPos(hWnd,NULL,rect.left,rect.top,0,0,SWP_NOSIZE|SWP_NOZORDER);
}

//イメージファイルからHBITMAPを取得
//iDestWidthとiDestHeightがどちらも0の場合リネームしない
//どちらも指定した場合幅優先。
HBITMAP GetThumbnailFromImage(LPCTSTR lpszFilepath,int iDestWidth,int iDestHeight){
	IStream *pIStream=NULL;
	IPicture *pIPicture=NULL;
	HGLOBAL hMemory=NULL;
	LPVOID lpBuffer=NULL;
	DWORD iReadByte=0,iFileSize=0;
	HANDLE hFile;
	short sType;
	HBITMAP hBitmap;

	if((hFile=CreateFile(lpszFilepath,GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL))==NULL)return NULL;
	if(!(iFileSize=GetFileSize(hFile,NULL)))return NULL;
	hMemory=GlobalAlloc(GMEM_MOVEABLE,iFileSize);
	lpBuffer=GlobalLock(hMemory);
	ReadFile(hFile,lpBuffer,iFileSize,&iReadByte,NULL);
	GlobalUnlock(hMemory);
	CloseHandle(hFile);
	CreateStreamOnHGlobal(hMemory,true,&pIStream);

	OleLoadPicture(pIStream, iFileSize,false,IID_IPicture,(LPVOID*)&pIPicture);
	pIPicture->get_Type(&sType);
	if(sType==PICTYPE_BITMAP){
		pIPicture->get_Handle((OLE_HANDLE*)&hBitmap);
	}
	hBitmap=(HBITMAP)CopyImage(hBitmap,IMAGE_BITMAP,0,0,0);

	//リサイズしない場合
	if(!iDestWidth&&!iDestHeight)return hBitmap;


	BITMAP bmBitmap;
	GetObject(hBitmap,sizeof(BITMAP),&bmBitmap);
	int iSrcWidth=bmBitmap.bmWidth;
	int iSrcHeight=bmBitmap.bmHeight;

	if(iDestWidth){
		//幅基準で作成
		if(iDestWidth<iSrcWidth){
			float rX=(float)iDestWidth/iSrcWidth;
			float rY=(float)iDestWidth/iSrcHeight;
			//縮小後のサイズ
			iDestWidth=(int)(std::min(rX,rY)*iSrcWidth);
			iDestHeight=(int)(std::min(rX,rY)*iSrcHeight);

		}else{
			//幅か高さのどちらかが指定サイズ以下ならリサイズしない
			return hBitmap;
		}
	}else{
		//高さ基準で作成
		if(iDestHeight<iSrcHeight){
			float rX=(float)iDestHeight/iSrcWidth;
			float rY=(float)iDestHeight/iSrcHeight;
			//縮小後のサイズ
			iDestWidth=(int)(std::min(rX,rY)*iSrcWidth);
			iDestHeight=(int)(std::min(rX,rY)*iSrcHeight);
		}else{
			//幅か高さのどちらかが指定サイズ以下ならリサイズしない
			return hBitmap;
		}
	}


	HDC hdcScreen=GetDC(NULL);

	HDC hdcTmp=CreateCompatibleDC(hdcScreen);
	SelectObject(hdcTmp,hBitmap);

	HDC hdcMemory=CreateCompatibleDC(hdcScreen);
	HBITMAP hbmpResult=CreateCompatibleBitmap(hdcScreen,iDestWidth,iDestHeight);
	HGDIOBJ hobjOld=SelectObject(hdcMemory,hbmpResult);

	SetStretchBltMode(hdcMemory,HALFTONE);
	HPALETTE hPalette=CreateHalftonePalette(hdcMemory);
	HPALETTE hpltOld=SelectPalette(hdcMemory,hPalette,false);
	RealizePalette(hdcMemory);

	StretchBlt(hdcMemory,0,0,iDestWidth,iDestHeight,hdcTmp,0,0,iSrcWidth,iSrcHeight,SRCCOPY);

	SelectPalette(hdcMemory,hpltOld,false);
	DeleteObject(hPalette);
	ReleaseDC(NULL,hdcScreen);

	SelectObject(hdcMemory,hobjOld);
	DeleteDC(hdcTmp);
	DeleteObject(hBitmap);

	GlobalFree(hMemory);
	pIPicture->Release();
	pIStream->Release();

	return hbmpResult;
}

//サムネイルを設定
void SetButtonThumbnail(HWND hButton,LPCTSTR lpszImagepath,int iWidth,int iHeight){
	HBITMAP hBitmap=NULL;

	if((hBitmap=GetThumbnailFromImage(lpszImagepath,iWidth,iHeight))!=NULL){
		SendMessage(hButton,BM_SETIMAGE,(WPARAM)IMAGE_BITMAP,(LPARAM)hBitmap);
	}
}

//マウスポインタの位置のコントロールのハンドルを取得
HWND ControlFromPoint(){
	POINT pt;

	GetCursorPos(&pt);
	HWND hWnd=WindowFromPoint(pt);
	if(hWnd!=NULL){
		POINT ptClient=pt;
		ScreenToClient(hWnd,&ptClient);
		HWND hWndChild=ChildWindowFromPoint(hWnd,ptClient);
		if(hWndChild!=NULL&&IsWindowVisible(hWndChild)){
			hWnd=hWndChild;
		}
	}

	DWORD dwWnd=MAXWORD;

	HWND hWndParent=GetParent(hWnd);
	if(hWndParent!=NULL){
		if((GetWindowLongPtr(hWnd,GWL_STYLE)&WS_POPUP)==0){//ポップアップウインドウではない
			HWND hWndChild=GetWindow(hWndParent,GW_CHILD);//子ウインドウ取得
			while(hWndChild!=NULL){
				if(IsWindowVisible(hWndChild)){//非表示の子ウインドウを無視
					RECT rc;

					GetWindowRect(hWndChild,&rc);
					if(PtInRect(&rc,pt)!=0){
						DWORD dwWndChild=(rc.right-rc.left)*(rc.bottom-rc.top);
						if(dwWndChild<dwWnd){
							dwWnd=dwWndChild;
							hWnd=hWndChild;
						}
					}
				}
				hWndChild=GetWindow(hWndChild,GW_HWNDNEXT);
			}
		}
	}
	return hWnd;
}

//ファイルが存在するか否か
bool FileExists(LPCTSTR lpszFilepath){
	return (bool)(GetFileAttributes(lpszFilepath)!=0xffffffff);
}

//共通グループボックスプロシージャ
LRESULT CALLBACK GroupBoxProc(HWND hgrpGroupbox,UINT uMsg,WPARAM wParam,LPARAM lParam){
	switch(uMsg){
		case WM_DROPFILES:{
			HDROP hDrop=(HDROP)wParam;
			TCHAR szImagepath[MAX_PATH]={0};

			//DragQueryFileでファイル名[フルパス]を取得
			DragQueryFile(hDrop,0,szImagepath,array_sizeof(szImagepath));

			LPTSTR lpszExtension=NULL;

			lpszExtension=PathFindExtension(szImagepath);
			if(_tcsicmp(lpszExtension,_T(".jpg"))==0){

				HWND hButton=ControlFromPoint();

				//サムネイルを設定
				SetButtonThumbnail(hButton,szImagepath,0,170);

				//画像のパスを保存
				SetWindowText(hButton,szImagepath);
			}
			DragFinish(hDrop);
			break;
		}

		default:
			break;
	}
	return CallWindowProc((WNDPROC)GetWindowLongPtr(hgrpGroupbox,GWL_USERDATA),hgrpGroupbox,uMsg,wParam,lParam);
}

//リンクプロシージャ
LRESULT CALLBACK HyperLinkProc(HWND hstcStatic,UINT uMsg,WPARAM wParam,LPARAM lParam){
	static HCURSOR hHandCursor=NULL;

	switch(uMsg){
		case WM_SETCURSOR:
			if(hHandCursor==NULL){
				hHandCursor=LoadCursor(NULL,IDC_HAND);
			}else{
				SetCursor(hHandCursor);
				return true;
			}
			break;

		default:
			break;
	}
	return CallWindowProc((WNDPROC)GetWindowLongPtr(hstcStatic,GWL_USERDATA),hstcStatic,uMsg,wParam,lParam);
}

//ウインドウプロシージャ
LRESULT CALLBACK WindowProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam){
	HFONT hSystemFont=NULL;//オブジェクト用フォント

	static HWND hgrpOrig;//[左]元画像グループボックス
	static HWND hgrpThumb;//[右]サムネイル画像グループボックス
	static HWND hbtnOrig;//[左]元画像ボタン
	static HWND hbtnThumb;//[右]サムネイル画像ボタン

	static HWND hbtnCreate;//作成ボタン
	static HWND hbtnSave;//保存ボタン
	static HWND hbtnDelete;//削除ボタン

	static HICON hicnCreate;//作成アイコン
	static HICON hicnSave;//保存アイコン
	static HICON hicnDelete;//削除アイコン

	static HWND hstcURL;//ホームページへのリンク

	switch(uMsg){
	case WM_CREATE:{
		InitCommonControls();
		NONCLIENTMETRICS ncMetrics;//フォント情報取得用
		ncMetrics.cbSize=sizeof(NONCLIENTMETRICS);//フォント情報取得
		SystemParametersInfo(SPI_GETNONCLIENTMETRICS,sizeof(NONCLIENTMETRICS),&ncMetrics,0);
		hSystemFont=CreateFontIndirect(&ncMetrics.lfStatusFont);

		hgrpOrig=CreateWindowEx(WS_EX_CLIENTEDGE,
								_T("BUTTON"),
								_T("[元画像]"),
								WS_CHILD|WS_VISIBLE|BS_GROUPBOX,
								0,0,
								200,210,
								hWnd,
								(HMENU)IDC_GROUPBOX_ORIGINAL,
								g_hInstance,
								NULL
		);

		hgrpThumb=CreateWindowEx(WS_EX_CLIENTEDGE,
								_T("BUTTON"),
								_T("[サムネイル画像]"),
								WS_CHILD|WS_VISIBLE|BS_GROUPBOX,
								200+SPLIT_WIDTH,0,
								200,210,
								hWnd,
								(HMENU)IDC_GROUPBOX_THUMBNAIL,
								g_hInstance,
								NULL
		);
		hbtnOrig=CreateWindowEx(0,
								_T("BUTTON"),
								_T("ボタンをクリック、\nまたはファイルをドロップしてください"),
								WS_CHILD|WS_VISIBLE|BS_BITMAP|BS_MULTILINE,
								10,20,
								180,180,
								hWnd,
								(HMENU)IDC_BUTTON_OROGINAL,
								g_hInstance,
								NULL
		);

		hbtnThumb=CreateWindowEx(0,
								_T("BUTTON"),
								TEXT("ボタンをクリック、\nまたはファイルをドロップしてください"),
								WS_CHILD|WS_VISIBLE|BS_BITMAP|BS_MULTILINE,
								(200+SPLIT_WIDTH)+10,20,
								180,180,
								hWnd,
								(HMENU)IDC_BUTTON_THUMBNAIL,
								g_hInstance,
								NULL
		);

		hbtnCreate=CreateWindowEx(0,
								_T("BUTTON"),
								TEXT("作成"),
								WS_CHILD|WS_VISIBLE,
								(200+SPLIT_WIDTH)+60,220,
								100,50,
								hWnd,
								(HMENU)IDC_BUTTON_CREATE,
								g_hInstance,
								NULL
		);

		hbtnSave=CreateWindowEx(0,
								_T("BUTTON"),
								TEXT("保存"),
								WS_CHILD|WS_VISIBLE,
								(200+SPLIT_WIDTH)+60,280,
								100,50,
								hWnd,
								(HMENU)IDC_BUTTON_SAVE,
								g_hInstance,
								NULL
		);

		hbtnDelete=CreateWindowEx(0,
								_T("BUTTON"),
								TEXT("削除"),
								WS_CHILD|WS_VISIBLE,
								(200+SPLIT_WIDTH)+60,340,
								100,50,
								hWnd,
								(HMENU)IDC_BUTTON_DELETE,
								g_hInstance,
								NULL
		);

		hstcURL=CreateWindowEx(0,
								_T("STATIC"),
								_T("♥"),
								WS_CHILD|WS_VISIBLE|SS_LEFT|SS_NOTIFY,
								40,300,
								15,15,
								hWnd,
								(HMENU)IDC_STATIC_URL,
								g_hInstance,
								NULL
		);

		//フォントの設定
		SendMessage(hgrpOrig,WM_SETFONT,(WPARAM)hSystemFont,(LPARAM)true);
		SendMessage(hgrpThumb,WM_SETFONT,(WPARAM)hSystemFont,(LPARAM)true);
		SendMessage(hbtnOrig,WM_SETFONT,(WPARAM)hSystemFont,(LPARAM)true);
		SendMessage(hbtnThumb,WM_SETFONT,(WPARAM)hSystemFont,(LPARAM)true);
		SendMessage(hbtnCreate,WM_SETFONT,(WPARAM)hSystemFont,(LPARAM)true);
		SendMessage(hbtnSave,WM_SETFONT,(WPARAM)hSystemFont,(LPARAM)true);
		SendMessage(hbtnDelete,WM_SETFONT,(WPARAM)hSystemFont,(LPARAM)true);
		SendMessage(hstcURL,WM_SETFONT,(WPARAM)hSystemFont,(LPARAM)true);

		//アイコンの設定
		hicnCreate=static_cast<HICON>(LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICONCREATE),IMAGE_ICON,32,32,LR_DEFAULTCOLOR));
		hicnSave=static_cast<HICON>(LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICONSAVE),IMAGE_ICON,32,32,LR_DEFAULTCOLOR));
		hicnDelete=static_cast<HICON>(LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICONDELETE),IMAGE_ICON,32,32,LR_DEFAULTCOLOR));

		SendMessage(hbtnCreate,BM_SETIMAGE,(WPARAM)IMAGE_ICON,(LPARAM)hicnCreate);
		SendMessage(hbtnSave,BM_SETIMAGE,(WPARAM)IMAGE_ICON,(LPARAM)hicnSave);
		SendMessage(hbtnDelete,BM_SETIMAGE,(WPARAM)IMAGE_ICON,(LPARAM)hicnDelete);

		//サブクラス化
		SetWindowLongPtr(hgrpOrig,GWL_USERDATA,GetWindowLong(hgrpOrig,GWL_WNDPROC));
		SetWindowLongPtr(hgrpOrig,GWL_WNDPROC,(DWORD)GroupBoxProc);

		SetWindowLongPtr(hgrpThumb,GWL_USERDATA,GetWindowLong(hgrpThumb,GWL_WNDPROC));
		SetWindowLongPtr(hgrpThumb,GWL_WNDPROC,(DWORD)GroupBoxProc);

		SetWindowLongPtr(hstcURL,GWL_USERDATA,GetWindowLong(hstcURL,GWL_WNDPROC));
		SetWindowLongPtr(hstcURL,GWL_WNDPROC,(DWORD)HyperLinkProc);

		//DnD受け入れ許可
		DragAcceptFiles(hgrpOrig,true);
		DragAcceptFiles(hgrpThumb,true);

		return 0;
	}
/*
	case WM_LBUTTONDOWN:{
		TCHAR szImagepath[MAX_PATH]={0};
		HWND hButton=ControlFromPoint();
		if(hButton==hgrpOrig){
			if(SelectSingleFile(hWnd,_T("JPEGファイル (*.jpg)\0*.jpg\0\0"),_T("JPEGファイルを選択してください"),szImagepath,MAX_PATH)){
				HBITMAP hBitmap=NULL;
				if((hBitmap=GetThumbnailFromImage(szImagepath,0,150))==NULL)break;
				SendMessage(hbtnOrig,BM_SETIMAGE,(WPARAM)IMAGE_BITMAP,(LPARAM)hBitmap);

//				DrawBitmap(hgrpOrig,hBitmap);
			}
		}else if(hButton==hgrpThumb){
			if(SelectSingleFile(hWnd,_T("JPEGファイル (*.jpg)\0*.jpg\0\0"),_T("JPEGファイルを選択してください"),szImagepath,MAX_PATH)){
				HBITMAP hBitmap=NULL;
				if((hBitmap=GetThumbnailFromImage(szImagepath,0,150))==NULL)break;
				SendMessage(hbtnThumb,BM_SETIMAGE,(WPARAM)IMAGE_BITMAP,(LPARAM)hBitmap);
//				DrawBitmap(hgrpThumb,hBitmap);
			}
		}
		break;
	}
*/

	case WM_CTLCOLORSTATIC:{
		HDC hDC=(HDC)wParam;
		if((HWND)lParam==hstcURL){
			SetTextColor(hDC,RGB(255,128,192));
			SetBkMode(hDC,TRANSPARENT);
			return (BOOL)(HBRUSH)GetStockObject(NULL_BRUSH);
		}
		break;
	}

	case WM_PAINT:{
			PAINTSTRUCT ps;
			HICON hIcon=NULL;
			HDC hDC=BeginPaint(hWnd,&ps);

			//アイコンハンドル取得
			hIcon=(HICON)LoadImage(g_hInstance,MAKEINTRESOURCE(IDI_ICON1),IMAGE_ICON,256,256,LR_SHARED);
			//アイコン描写
			DrawIconEx(hDC,20,216,hIcon,256,256,0,NULL,DI_NORMAL);
			break;
		}

	case WM_COMMAND:{
		TCHAR szOriginalImagepath[MAX_PATH]={0};
		TCHAR szThumbnailImagepath[MAX_PATH]={0};
		char szOriginalImagepathA[MAX_PATH]={0};
		char szThumbnailImagepathA[MAX_PATH]={0};
		LPTSTR lpszExtension=NULL;

		switch(LOWORD(wParam)){
			case IDC_BUTTON_OROGINAL:{
				if(SelectSingleFile(GetOpenFileName,hWnd,_T("JPEGファイル (*.jpg)\0*.jpg\0\0"),_T("JPEGファイル[元]を選択してください"),szOriginalImagepath,MAX_PATH)){
					lpszExtension=PathFindExtension(szOriginalImagepath);
					if(_tcsicmp(lpszExtension,_T(".jpg"))==0){
						//サムネイルを設定
						SetButtonThumbnail(hbtnOrig,szOriginalImagepath,0,170);

						//画像のパスを保存
						SetWindowText(hbtnOrig,szOriginalImagepath);
					}
				}
				break;
			}

			case IDC_BUTTON_THUMBNAIL:{
				if(SelectSingleFile(GetOpenFileName,hWnd,_T("JPEGファイル (*.jpg)\0*.jpg\0\0"),_T("JPEGファイル[サムネイル]を選択してください"),szOriginalImagepath,MAX_PATH)){
					lpszExtension=PathFindExtension(szOriginalImagepath);
					if(_tcsicmp(lpszExtension,_T(".jpg"))==0){
						//サムネイル設定
						SetButtonThumbnail(hbtnThumb,szOriginalImagepath,0,170);

						//画像のパスを保存
						SetWindowText(hbtnThumb,szOriginalImagepath);
					}
				}
				break;
			}

			case IDC_BUTTON_CREATE:{
				//ボタンから画像のパスを取得
				GetWindowText(hbtnOrig,szOriginalImagepath,MAX_PATH);
				GetWindowText(hbtnThumb,szThumbnailImagepath,MAX_PATH);

				if(!(FileExists(szOriginalImagepath))||!(FileExists(szThumbnailImagepath))){
					MessageBox(hWnd,_T("正しいファイル名が指定されていません。"),NULL,MB_ICONSTOP);
					ShakeWindow(hWnd,150);
					break;
				}

				if(_tcscmp(szOriginalImagepath,szThumbnailImagepath)==0){
					MessageBox(hWnd,_T("同じ画像が指定されています。"),NULL,MB_ICONSTOP);
					ShakeWindow(hWnd,150);
					break;
				}

				TCHAR szMessage[MAX_PATH*3]={0};

				wsprintf(szMessage,_T("%s\nのサムネイルを\n%s\nに差し替えますか?"),szOriginalImagepath,szThumbnailImagepath);

				if(MessageBox(hWnd,szMessage,_T("処理開始の確認"),MB_YESNO|MB_ICONQUESTION)==IDYES){

					WideCharToMultiByte(CP_ACP,0,szOriginalImagepath,-1,szOriginalImagepathA,MAX_PATH,NULL,NULL);
					WideCharToMultiByte(CP_ACP,0,szThumbnailImagepath,-1,szThumbnailImagepathA,MAX_PATH,NULL,NULL);
					if(ProcessFile(szOriginalImagepathA,szThumbnailImagepathA,MODE_REPLACETHUMB)){
						MessageBox(hWnd,_T("サムネイルの差し替えが完了しました。\n\n【注意】元画像とサムネイル画像の縦横比などが異なる場合、正常に処理されていない場合があります。"),_T("処理終了"),MB_OK);
					}else{
						MessageBox(hWnd,_T("サムネイルの差し替えに失敗しました。"),NULL,MB_ICONSTOP);
						ShakeWindow(hWnd,150);
					}
				}
				break;
			}

			case IDC_BUTTON_SAVE:{
				//画像のパスを取得
				GetWindowText(hbtnOrig,szOriginalImagepath,MAX_PATH);

				if(!(FileExists(szOriginalImagepath))){
					MessageBox(hWnd,_T("正しいファイル名が指定されていません。"),NULL,MB_ICONSTOP);
					ShakeWindow(hWnd,150);
					break;
				}

				if(SelectSingleFile(GetSaveFileName,hWnd,_T("JPEGファイル (*.jpg)\0*.jpg\0\0"),_T("保存するJPEGファイル[サムネイル]を指定してください"),szThumbnailImagepath,MAX_PATH)){

					WideCharToMultiByte(CP_ACP,0,szOriginalImagepath,-1,szOriginalImagepathA,MAX_PATH,NULL,NULL);
					WideCharToMultiByte(CP_ACP,0,szThumbnailImagepath,-1,szThumbnailImagepathA,MAX_PATH,NULL,NULL);
					if(ProcessFile(szOriginalImagepathA,szThumbnailImagepathA,MODE_SAVETHUMB)){
						MessageBox(hWnd,_T("サムネイルの保存が完了しました。"),_T("処理終了"),MB_OK);
					}else{
						MessageBox(hWnd,_T("サムネイルの保存に失敗しました。"),NULL,MB_ICONSTOP);
					}
				}
				break;
			}

			case IDC_BUTTON_DELETE:{
				//画像のパスを取得
				GetWindowText(hbtnOrig,szOriginalImagepath,MAX_PATH);

				if(!(FileExists(szOriginalImagepath))){
					MessageBox(hWnd,_T("正しいファイル名が指定されていません。"),NULL,MB_ICONSTOP);
					ShakeWindow(hWnd,150);
					break;
				}

				TCHAR szMessage[MAX_PATH*2]={0};

				wsprintf(szMessage,_T("%s\nのサムネイルを削除しますか?"),szOriginalImagepath);

				if(MessageBox(hWnd,szMessage,_T("処理開始の確認"),MB_YESNO|MB_ICONQUESTION)==IDYES){

					WideCharToMultiByte(CP_ACP,0,szOriginalImagepath,-1,szOriginalImagepathA,MAX_PATH,NULL,NULL);
					if(ProcessFile(szOriginalImagepathA,NULL,MODE_REPLACETHUMB)){
						MessageBox(hWnd,_T("サムネイルの削除が完了しました。\n\n【注意】削除されたのはサムネイルのみです。撮影日時などのExif情報は削除されていません。"),_T("処理終了"),MB_OK);
					}else{
						MessageBox(hWnd,_T("サムネイルの削除に失敗しました。"),NULL,MB_ICONSTOP);
					}
				}
				break;
			}

			case IDC_STATIC_URL:
				if(HIWORD(wParam)==STN_CLICKED){
					//ホームページへ
					ShellExecute(NULL,_T("open"),g_szURL,NULL,NULL,SW_SHOWNORMAL);
					return true;
				}
				break;
		}
		break;
	}

	case WM_CLOSE:
		ShowWindow(hWnd,SW_HIDE);
		//フォントを破棄
		DeleteObject(hSystemFont);
		DestroyWindow(hWnd);
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;

	default:
		break;
	}

	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

//ウインドウクラスを登録
bool InitApplication(HINSTANCE hInstance,LPCTSTR lpszClassName){
	WNDCLASS wc;
	wc.style		=CS_HREDRAW|CS_VREDRAW;
	wc.lpfnWndProc	=static_cast<WNDPROC>(WindowProc);
	wc.cbClsExtra	=0;
	wc.cbWndExtra	=0;
	wc.hInstance	=hInstance;
	wc.hIcon		=LoadIcon(hInstance,MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor		=LoadCursor(NULL,IDC_ARROW);//static_cast<HCURSOR>(LoadImage(NULL,IDC_ARROW,IMAGE_CURSOR,0,0,LR_SHARED));
	wc.hbrBackground=(HBRUSH)(COLOR_3DFACE+1);
	wc.lpszMenuName	=NULL;
	wc.lpszClassName=lpszClassName;
	return RegisterClass(&wc);
}

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInst,LPSTR lpszCmdLine,int nCmdShow){
	TCHAR szAppName[]=EYESOFSAYA_VERSION;
	TCHAR szClassName[]=_T("eyesofSayaWindowClass");
	HWND hWnd;
	MSG msg;

	//インスタンスハンドル保存
	g_hInstance=hInstance;
	InitApplication(g_hInstance,szClassName);

	hWnd=CreateWindowEx(0,
						szClassName,
						szAppName,
						WS_OVERLAPPED|WS_MINIMIZEBOX|WS_CAPTION|WS_SYSMENU,
						CW_USEDEFAULT,CW_USEDEFAULT,//座標
						400+SPLIT_WIDTH*3,500,//サイズ
						NULL,
						NULL,
						g_hInstance,
						NULL
	);
	if(hWnd==NULL)ExitProcess(0);

	UpdateWindow(hWnd);

	//ウインドウの表示
	ShowWindow(hWnd,nCmdShow);

	while(GetMessage(&msg,NULL,0,0)){
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}
