﻿#include"jhead.h"
#include<windows.h>
#include<sys/stat.h>

#include <io.h>


static int FilesMatched;
static int FileSequence;

static const char * CurrentFile;

//--------------------------------------------------------------------------
// Command line options flags
       int ShowTags     = FALSE;    // Do not show raw by default.
       int DumpExifMap  = FALSE;



//--------------------------------------------------------------------------
// Error exit handler
//--------------------------------------------------------------------------
void ErrFatal(char * msg)
{
    fprintf(stderr,"\nError : %s\n", msg);
    if (CurrentFile) fprintf(stderr,"in file '%s'\n",CurrentFile);
    exit(EXIT_FAILURE);
}

//--------------------------------------------------------------------------
// Report non fatal errors.  Now that microsoft.net modifies exif headers,
// there's corrupted ones, and there could be more in the future.
//--------------------------------------------------------------------------
void ErrNonfatal(char * msg, int a1, int a2)
{
    fprintf(stderr,"\nNonfatal Error : ");
    if (CurrentFile) fprintf(stderr,"'%s' ",CurrentFile);
    fprintf(stderr, msg, a1, a2);
    fprintf(stderr, "\n");
}

//--------------------------------------------------------------------------
// Set file time as exif time.
//--------------------------------------------------------------------------
void FileTimeAsString(char * TimeStr)
{
    struct tm ts;
    ts = *localtime(&ImageInfo.FileDateTime);
    strftime(TimeStr, 20, "%Y:%m:%d %H:%M:%S", &ts);
}

//--------------------------------------------------------------------------
// Do selected operations to one file at a time.
//--------------------------------------------------------------------------
int ProcessFile(const char * FileName, char * ThumbName, int Mode)
{
    int Modified = FALSE;
    ReadMode_t ReadMode;
	ThumbResult_t ThumbResult;

    if (strlen(FileName) >= PATH_MAX-1){
        // Protect against buffer overruns in strcpy / strcat's on filename
        MessageBoxA(NULL,"サムネイル画像のサイズが大きすぎます。",NULL,MB_ICONSTOP);
        return FALSE;
    }

    ReadMode = READ_METADATA;
    CurrentFile = FileName;
    FilesMatched = 1;

    ResetJpgfile();

    // Start with an empty image information structure.
    memset(&ImageInfo, 0, sizeof(ImageInfo));
    ImageInfo.FlashUsed = -1;
    ImageInfo.MeteringMode = -1;
    ImageInfo.Whitebalance = -1;

    // Store file date/time.
    {
        struct stat st;
        if (stat(FileName, &st) >= 0){
            ImageInfo.FileDateTime = st.st_mtime;
            ImageInfo.FileSize = st.st_size;
        }else{
            MessageBoxA(NULL, "ファイルが見つかりません。", NULL, MB_ICONSTOP);
            return FALSE;
        }
    }

    if (access(FileName, 2 /*W_OK*/)){
            printf("Skipping readonly file '%s'\n",FileName);
            return FALSE;
    }

    strncpy(ImageInfo.FileName, FileName, PATH_MAX);


    ReadMode = static_cast<ReadMode_t> (READ_METADATA|READ_IMAGE);

    if (!ReadJpegFile(FileName, ReadMode)) return FALSE;

    FileSequence += 1; // Count files processed.

    if (Mode==MODE_SAVETHUMB){
        if ((ThumbResult = static_cast<ThumbResult_t>(SaveThumbnail(ThumbName))) == THUMB_NOTCONTAIN){
                MessageBoxA(NULL, "サムネイル画像が含まれません。", NULL, MB_ICONSTOP);
                return FALSE;
        }else if (ThumbResult==THUMB_NOTWRITE){
                MessageBoxA(NULL, "サムネイル画像の出力に失敗しました。", NULL, MB_ICONSTOP);
                return FALSE;
        }
        
        return TRUE;
        
    }else{
        if ((ThumbResult = static_cast<ThumbResult_t>(ReplaceThumbnail(ThumbName))) == THUMB_NOTCONTAIN){
            // Make a new minimal exif section
            create_EXIF();
            ReplaceThumbnail(ThumbName);
            Modified = TRUE;
        }

            if (ThumbResult){
                Modified = TRUE;
            }else if(ThumbResult == THUMB_TOOLARGE){
                MessageBoxA(NULL, "サムネイル画像のサイズが大きすぎます。", NULL, MB_ICONSTOP);
                return FALSE;
            }
    }

    if (Modified){
        char BackupName[PATH_MAX+5];
        struct stat buf;

        strcpy(BackupName, FileName);
        strcat(BackupName, ".orig");

        // Remove any .old file name that may pre-exist
        unlink(BackupName);

        // Rename the old file.
        rename(FileName, BackupName);

        // Write the new file.
        WriteJpegFile(FileName);

        // Copy the access rights from original file
        if (stat(BackupName, &buf) == 0){
            // set Unix access rights and time to new file
            struct utimbuf mtime;
            chmod(FileName, buf.st_mode);

            mtime.actime = buf.st_mtime;
            mtime.modtime = buf.st_mtime;

            utime(FileName, &mtime);
        }

        // Now that we are done, remove original file.
//        unlink(BackupName);
        return TRUE;
    }
    return FALSE;
}
