/*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#
	isbnconv Ver.1.00
	Coded by x@rgs

	This code is released under NYSL Version 0.9982
	See NYSL_withfaq.TXT for further details.

	cl isbnconv.cpp kernel32.lib user32.lib /O1 /GS- /link /subsystem:windows /nodefaultlib /merge:".rdata=.text"
#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*#*/
#define UNICODE
#define _UNICODE
#include<windows.h>
#include<tchar.h>

bool isbnconv(TCHAR* dst,const TCHAR *src){
	bool hyphen=false;
	int length=0;
	TCHAR* str=(TCHAR*)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,(13+4+1)*sizeof(TCHAR));

	for(int i=0;length<=13&&src[i];i++){
		if(src[i]=='-')hyphen=true;
		else str[length++]=src[i];
	}

	if(length==10){
		for(int i=9;i>=0;i--){
			str[i+3]=str[i];
		}
		str[0]='9';
		str[1]='7';
		str[2]='8';
		str[13]='\0';

		unsigned int cd=0;

		for(int i=0;i<12;i++){
			cd+=(str[i]-'0')*((i%2==0)?1:3);
		}
		cd%=10;
		str[12]=((cd%10)?10-cd:0)+'0';
		str[13]='\0';

		if(hyphen){
			for(int i=12,ii=12;i>=0;i--,ii--){
				if(i==11||i==6||i==3||i==2){
					str[ii--+4]='-';
				}
				str[ii+4]=str[i];
			}
			str[17]='\0';
		}
		lstrcpy(dst,str);
	}else if(length==13){
		lstrcpyn(str,str+3,10);

		unsigned int cd=0;

		for(int i=0,ii=10;ii>=2;ii--){
			cd+=(str[i++]-'0')*ii;
		}
		cd=11-cd%11;
		str[9]=(cd==11)?'0':(cd==10)?'X':cd+'0';
		str[10]='\0';

		if(hyphen){
			for(int i=9,ii=9;i>=0;i--,ii--){
				if(i==8||i==3||i==0){
					str[ii--+3]='-';
				}
				str[ii+3]=str[i];
			}
			str[13]='\0';
		}
		lstrcpy(dst,str);
	}

	HeapFree(GetProcessHeap(),0,str);
	return dst[0]!='\0';
}

int getClipboardSize(){
	if(!IsClipboardFormatAvailable(CF_TEXT))return -1;
	if(!OpenClipboard(NULL))return -1;

	HGLOBAL hglobal=GetClipboardData(CF_UNICODETEXT);

	CloseClipboard();
	return GlobalSize(hglobal);
} 

bool setClipboardText(const TCHAR* text,int length){
	bool result=false;

	if(!OpenClipboard(NULL))return result;

	HGLOBAL hglobal=GlobalAlloc(GMEM_MOVEABLE,(length+1)*sizeof(TCHAR));
	if(hglobal!=NULL){
		lstrcpy((TCHAR*)GlobalLock(hglobal),text);
		GlobalUnlock(hglobal);
		EmptyClipboard();
		result=SetClipboardData(CF_UNICODETEXT,hglobal)!=NULL;
	}
	CloseClipboard();
	return result;
}

bool getClipboardText(TCHAR* result){
	if(!IsClipboardFormatAvailable(CF_TEXT))return false;
	if(!OpenClipboard(NULL))return false;

	HGLOBAL hglobal=GetClipboardData(CF_UNICODETEXT);

	lstrcpy(result,(TCHAR*)GlobalLock(hglobal));

	GlobalUnlock(hglobal);
	CloseClipboard();

	return true;
}

extern "C" void WinMainCRTStartup(){
	TCHAR* src=(TCHAR*)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,getClipboardSize());
	TCHAR* dst=(TCHAR*)HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,(13+4+1)*sizeof(TCHAR));

	if(!src||!dst||!getClipboardText(src))ExitProcess(1);
	if(isbnconv(dst,src)){
		setClipboardText(dst,lstrlen(dst));
	}
	HeapFree(GetProcessHeap(),0,dst);
	HeapFree(GetProcessHeap(),0,src);
	ExitProcess(0);
}
