﻿#include"StdAfx.h"
#include"u2s.h"
#include"resources/resource.h"


using namespace sslib;


void createInstance(){
	new U2s;
}

bool U2s::init(){
	return true;
}

void U2s::cleanup(){
}

void U2s::usage(){
}

void U2s::ctrlCEvent(){
}

bool U2s::run(CommandArgument& cmd_arg){
	struct l{
		static bool u2s(tstring* dest,const TCHAR* src){
			bool result=false;
			int sjis_length=::WideCharToMultiByte(CP_ACP,0,src,-1,NULL,0,"_",NULL);

			if(sjis_length>0){
				std::vector<char> sjis_string(sjis_length);
				if(::WideCharToMultiByte(CP_ACP,0,src,-1,&sjis_string[0],sjis_length,"_",NULL)){

					int utf16_length=::MultiByteToWideChar(CP_ACP,0,&sjis_string[0],-1,NULL,0);

					if(utf16_length>0){
						std::vector<wchar_t> utf16_string(utf16_length);
						if(::MultiByteToWideChar(CP_ACP,0,&sjis_string[0],-1,&utf16_string[0],utf16_length)){
							if(dest)dest->assign(&utf16_string[0]);
							result=true;
						}
					}
				}
			}
			return result;
		}

		static bool convFile(const TCHAR* dir,const TCHAR* file){
			bool result=false;

			::SetCurrentDirectory(dir);

			tstring sjis_name;
			Console stdOut;

			stdOut.outputString(_T("%s\n"),file);

			if(u2s(&sjis_name,file)){
				if(::MoveFile(file,sjis_name.c_str())!=0){
					stdOut.outputString(_T("->%s\n"),sjis_name.c_str());
					result=true;
				}else{
					stdOut.outputString(_T("->リネーム失敗: %s\n"),sjis_name.c_str());
				}
			}
			return result;
		}

		static bool convDir(const TCHAR* search_dir){

			FileSearch fs;

			for(fs.first(search_dir);fs.next();){
				if(!fs.hasAttribute(FILE_ATTRIBUTE_DIRECTORY)){
					//ファイル
					convFile(search_dir,fs.data()->cFileName);
				}else{
					//サブディレクトリを検索
					convDir(fs.filepath().c_str());

					convFile(search_dir,fs.data()->cFileName);
				}
			}
			return true;
		}
	};

	if(!cmd_arg.filepaths().size()){
		m_stdout.outputString(_T("引数が不足しています。\n"));
		return false;
	}

	for(std::vector<tstring>::size_type i=0,size=cmd_arg.filepaths().size();!m_terminated&&i<size;++i){
		//ワイルドカードが展開されない(存在しない)パスは追加しない
		if(path::containsWildcard(cmd_arg.filepaths()[i].c_str()))continue;

		std::vector<TCHAR> buffer(32768);

		//フルパスを取得
		if(path::getFullPath(&buffer[0],buffer.size(),cmd_arg.filepaths()[i].c_str())){
			tstring buffer_str(&buffer[0]);

			if(!path::fileExists(buffer_str.c_str()))continue;

			tstring dir(path::getCurrentDirectory());

			//ディレクトリなら再帰的検索してリストに追加
			if(path::isDirectory(&buffer[0])){
				l::convDir(&buffer[0]);
			}
			l::convFile(dir.c_str(),path::getFileName(&buffer[0]).c_str());
			::SetCurrentDirectory(dir.c_str());
		}else{msg(_T("%s[%d]"),&buffer[0],::GetFileAttributes(&buffer[0]));msg(_T("err:%x"),::GetLastError());}
	}

	return true;
}
